// this should only be included in App.xul.

var AimSessionObserver = new Object();

AimSessionObserver.onAssert = function(datasource, source, property, target) {
	if (source.EqualsNode(aimRDFSession())) {
		if (property.EqualsNode(aimRDFSessionState())) {
			var state = target.QueryInterface(Components.interfaces.nsIRDFLiteral).Value;
			var signonItem =        top.document.getElementById("miSignOn");
			var signoffcloseItem =  top.document.getElementById("miSignOffClose");
			var editOptionsItem =   top.document.getElementById("editOptionsid");
			var peopleMenu =        top.document.getElementById("people_menu");
			var peoplePopup =       top.document.getElementById("menu_PeoplePopup");
			var newIM =             top.document.getElementById("cmd_IM");
			var importBuddyMenu =   top.document.getElementById("cmd_import");
			var exportBuddyMenu =   top.document.getElementById("cmd_export");
			var throbberObserver =  window.document.getElementById("navigator-throbber");

			if (state == "Register")
			{
				top.title = aimString(        "app.title.Register");
				signonItem.setAttribute(      "label", aimString("miSignOn.SignOn"));
				signonItem.setAttribute(      "disabled", "true");
				signoffcloseItem.setAttribute("disabled", "true");
				editOptionsItem.setAttribute( "disabled", "true");
				peopleMenu.setAttribute(      "disabled", "true");
				newIM.setAttribute(           "disabled", "true");
				importBuddyMenu.setAttribute( "disabled", "true");
        exportBuddyMenu.setAttribute( "disabled", "true");
				throbberObserver.setAttribute("busy", "false");
			}
			else if (state == "Offline") {
        ClearProcessTimer();
				top.title = aimString(        "app.title.SignOn");
				signonItem.setAttribute(      "label", aimString("miSignOn.SignOn"));
				signonItem.setAttribute(      "oncommand", "cmdSignOn();");
				signoffcloseItem.setAttribute("disabled", "true");
				editOptionsItem.setAttribute( "disabled", "true");
				signonItem.setAttribute(      "disabled", "false");
				peopleMenu.setAttribute(      "hidden", "true");
				peoplePopup.setAttribute(     "collapsed", "true");
				newIM.setAttribute(           "disabled", "true");
				importBuddyMenu.setAttribute( "disabled", "true");
        exportBuddyMenu.setAttribute( "disabled", "true");
				throbberObserver.setAttribute("busy", "false");
			}
			else if (state == "Online") {
        top.title = aimString(        "app.title.Online").replace(/%UserName%/, aimSessionCurrentScreenName());
				signonItem.setAttribute(      "label", aimString("miSignOn.SignOff"));
				signonItem.setAttribute(      "oncommand", "cmdSignOff();");
				signonItem.setAttribute(      "disabled", "false");
				signoffcloseItem.setAttribute("disabled", "false");
				editOptionsItem.setAttribute( "disabled", "false");
				peopleMenu.setAttribute(      "hidden", "false");
				peoplePopup.setAttribute(     "collapsed", "false");
				newIM.setAttribute(           "disabled", "false");
				importBuddyMenu.setAttribute( "disabled", "false");
				exportBuddyMenu.setAttribute( "disabled", "false");
				throbberObserver.setAttribute("busy", "false");
        // SetupCommandUpdateHandlers() will initialize command observers for Online tree and listsetup tree.
        // timeout is used coz it takes a bit of time for the Online and listsetup tab to show up!
        setTimeout("AimSetupCommandUpdateHandlers()", 500);
				aimMigrateBuddyList( aimSessionCurrentScreenName() );
        SetProcessTimer(10000);
			}

			else if (state == "OnlineAway") {
				top.title = aimString(        "app.title.OnlineAway");
				signonItem.setAttribute(      "label", aimString("miSignOn.SignOff"));
				signonItem.setAttribute(      "oncommand", "cmdSignOff();");
				signonItem.setAttribute(      "disabled", "false");
				signoffcloseItem.setAttribute("disabled", "false");
				editOptionsItem.setAttribute( "disabled", "false");
				peopleMenu.setAttribute(      "disabled", "false");
				newIM.setAttribute(           "disabled", "false");
				importBuddyMenu.setAttribute( "disabled", "false");
        exportBuddyMenu.setAttribute( "disabled", "false");
				throbberObserver.setAttribute("busy", "false");
			}
			else {
				top.title = aimString(        "app.title.Connecting");
				signonItem.setAttribute(      "label", aimString("miSignOn.Cancel"));
				signonItem.setAttribute(      "oncommand", "cmdCancelSignOn();");
				signoffcloseItem.setAttribute("disabled", "true");
				editOptionsItem.setAttribute( "disabled", "true");
				peopleMenu.setAttribute(      "hidden", "true");
				peoplePopup.setAttribute(     "collapsed", "true");
				newIM.setAttribute(           "disabled", "true");
				importBuddyMenu.setAttribute( "disabled", "true");
        exportBuddyMenu.setAttribute( "disabled", "true");
				throbberObserver.setAttribute("busy", "true");
			}
		}
	}
};

AimSessionObserver.onUnassert = function(datasource, source, property, target) {};

AimSessionObserver.onChange = function(datasource, source, property, oldTarget, newTarget) {
	AimSessionObserver.onAssert(datasource, source, property, newTarget);
};

AimSessionObserver.onMove = function(datasource, oldSource, newSource, property, target) {
	AimSessionObserver.onAssert(datasource, newSource, property, target);
};

AimSessionObserver.beginUpdateBatch = function(datasource) {
};

AimSessionObserver.endUpdateBatch = function(datasource) {
};