Name:     libiwpm
Version:  1.0.1
Release:  1
Summary:  iWarp Port Mapper userspace daemon
Requires: libnl-devel

Group: System Environment/Daemons
License: GPL/BSD
Url: http://www.openfabrics.org/
Source: http://www.openfabrics.org/downloads/%{name}-%{version}.tar.gz
BuildRoot: %{_tmppath}/%{name}-%{version}-%(%{__id_u} -n)

%define iwpmscript %{_builddir}/%{name}-%{version}/iwpm_script
%define rhel7 %(uname -r | grep "el7" | wc -l)

%if %rhel7
%define systemd  /usr/lib/systemd/system
%endif 

%description
libiwpm provides a userspace service for iWarp drivers to claim
tcp ports through the standard socket interface

%prep
%setup -q -n %{name}-%{version}

%build
%configure
make %{?_smp_mflags}

%install
rm -rf %{buildroot}
make DESTDIR=%{buildroot} install
touch %iwpmscript
 %if !%rhel7
	install -Dp -m 0755 %{_builddir}/%{name}-%{version}/iwpmd_init %{buildroot}%{_initrddir}/iwpmd
	echo "%{_initrddir}/iwpmd" >> %iwpmscript
 %else
	install -Dp -m 0644 %{_builddir}/%{name}-%{version}/iwpmd.service %{buildroot}/%{systemd}/iwpmd.service
	echo "%{systemd}/iwpmd.service" >> %iwpmscript
 %endif

%clean
rm -rf %{buildroot}

%post
 %if !%rhel7
	if [ $1 -eq 1 ]; then
		%_sbindir/chkconfig --add iwpmd
		%{_initrddir}/iwpmd start || exit 0
	elif [ $1 -gt 1 ]; then
		%{_initrddir}/iwpmd restart || exit 0
	fi
 %else
	%_bindir/systemctl enable iwpmd.service || exit 0
 %endif

%preun
if [ $1 -eq 0 ]; then 
 %if !%rhel7
        %_sbindir/chkconfig --del iwpmd
	%{_initrddir}/iwpmd stop || exit 0
 %else
	%_bindir/systemctl stop iwpmd.service || exit 0
	%_bindir/systemctl disable iwpmd.service || exit 0
 %endif	
fi

%postun
if [ $1 -ge 1 ]; then
 %if !%rhel7
	%{_initrddir}/iwpmd restart || exit 0
 %else
	%_bindir/systemctl restart iwpmd.service || exit 0
 %endif	
fi

%files -f %iwpmscript
%defattr(-,root,root,-) 
%_includedir/rdma/iwpm_netlink.h
%_includedir/rdma/iwarp_pm.h
%_bindir/iwpmd
%doc AUTHORS COPYING README


%changelog
*Fri Oct 31 2014 Tatyana Nikolova <tatyana.e.nikolova@intel.com> - 1.0.1
- Releasing libiwpm-1.0.1 to be included in OFED-3.18
*Mon Jun 10 2013 Tatyana Nikolova <tatyana.e.nikolova@intel.com> - 1.0.0
- Releasing iWarp Port Mapper Version 1.0.0 
