%define name tgt-generic
%define version 0.1
%define release 20080828

Name:           %{name}
Version:        %{version}
Release:        %{release}
Summary:	stgt program
Vendor:		Voltaire Inc
Packager:	Doron Shoham <dorons@voltaire.com>
Group:		Storage
License:        GPLv2
URL:            http://stgt.berlios.de
Source:         %name.tar.bz2
BuildRoot:       %{_tmppath}/%{name}

%description
This package provides stgt 

%package -n scsi-target-utils
Summary:        The SCSI target daemon and utility programs
Group:          System Environment/Daemons
%description -n scsi-target-utils
The SCSI target package contains the daemon and tools to setup a SCSI targets.
Currently, software iSCSI targets are supported.

%package -n tgt
Summary:        Generic Linux target framework (tgt)
Group:          System/Daemons
%description -n tgt
Linux target framework (tgt) aims to simplify various SCSI target
driver (iSCSI, Fibre Channel, SRP, etc) creation and maintenance.

Tgt consists of kernel modules, user-space daemon, and user-space
tools. Some target drivers uses all of them and some use only
user-space daemon and tools (i.e. they completely runs in user space).

%prep
rm -rf $RPM_BUILD_ROOT

%setup -q -n %name  

%build
%{__make} -C usr prefix=%_prefix libpath=%_libdir binpath=%_bindir ISCSI=1 ISCSI_RDMA=1
if (($?)); then
	echo "Failed to build tgt, cleaning up..."	
	exit 1
fi

%install 
function copy_n_add_file()
{
	orig_file=$1
	dest_path=$2
	distro=$3
	directive=$4

	if [ $5 ]; then
		file_name=$5
	else
		file_name=$(basename $orig_file)
	fi
					
	cp $orig_file ${RPM_BUILD_ROOT}$dest_path/$file_name

	add_file $orig_file $dest_path $distro $directive $file_name
}

function add_file()
{
	file_orig_path=$1
	file_dest_path=$2
	distro=$3
	directive=$4

	if [ $5 ]; then
		file_name=$5
	else
		file_name=$(basename $file_orig_path)
	fi

	echo "$directive $file_dest_path/$file_name" >> %{_tmppath}/open-iscsi-usr-file-list-$distro
}

%define DISTRO_LIST suse redhat

# Delete old file list files
for distro in %{DISTRO_LIST} ; do
	rm -f %{_tmppath}/open-iscsi-usr-file-list-$distro
done

# Delete the dir where the userspace programs were built
if [ "${RPM_BUILD_ROOT}" != "/" -a -d ${RPM_BUILD_ROOT} ] ; then rm -rf ${RPM_BUILD_ROOT} ; fi

rm -rf ${RPM_BUILD_ROOT}/tmp

# installing the man file
mkdir -p ${RPM_BUILD_ROOT}/%{_mandir}/man8
%{__install} -d ${RPM_BUILD_ROOT}/%{_mandir}/man8
%{__install} -p -m 0644 $PWD/doc/manpages/tgtadm.8 ${RPM_BUILD_ROOT}/%{_mandir}/man8
%{__install} -p -m 0644 $PWD/doc/manpages/tgt-setup-lun.8 ${RPM_BUILD_ROOT}/%{_mandir}/man8
%{__install} -p -m 0644 $PWD/doc/manpages/tgt-admin.8 ${RPM_BUILD_ROOT}/%{_mandir}/man8

# Put the new open-iscsi userspace tools in our tmp dir
%define USER_PROGRAMS_LIST tgtadm tgtd tgt-setup-lun tgt-admin

for i in %{USER_PROGRAMS_LIST} ; do
	found_new_file=$(find ${PWD} -type f -name "*$i")
	echo "cp $found_new_file ${RPM_BUILD_ROOT}/usr/sbin"
	mkdir -p ${RPM_BUILD_ROOT}/usr/sbin
	cp $found_new_file ${RPM_BUILD_ROOT}/usr/sbin
	for distro in %{DISTRO_LIST} ; do
		add_file $found_new_file /usr/sbin $distro "%attr(0755,root,root)"
	done
done

# Handle etc files (different names for each distribution)
mkdir -p ${RPM_BUILD_ROOT}/etc/init.d
copy_n_add_file $PWD/etc/initd/initd.suse /etc/init.d suse "%attr(0755,root,root)" tgtd
touch $PWD/etc/initd/tgtd
mkdir -p ${RPM_BUILD_ROOT}/etc/rc.d/init.d
copy_n_add_file $PWD/etc/initd/initd.redhat /etc/rc.d/init.d redhat "%attr(0755,root,root)" tgtd


# Put misc open-iscsi files in our tmp dir
%define MISC_LIST README README.iscsi 

for i in %{MISC_LIST} ; do
	found_new_file=$(find ${PWD} -type f -name "*$i")
	mkdir -p ${RPM_BUILD_ROOT}/usr/share/doc/packages/tgt
	cp $found_new_file ${RPM_BUILD_ROOT}/usr/share/doc/packages/tgt
	add_file $found_new_file /usr/share/doc/packages/tgt suse "%doc"

	mkdir -p ${RPM_BUILD_ROOT}/usr/share/doc/scsi-target-utils-%{version}.%{release}
	cp $found_new_file ${RPM_BUILD_ROOT}/usr/share/doc/scsi-target-utils-%{version}.%{release}
	add_file $found_new_file /usr/share/doc/scsi-target-utils-%{version}.%{release} redhat "%doc"
done

# Build the file list
FILE_LIST_SUSE=%{_tmppath}/open-iscsi-usr-file-list-suse
FILE_LIST_REDHAT=%{_tmppath}/open-iscsi-usr-file-list-redhat

# Add directories to the file list
echo "%dir /usr/share/doc/packages/tgt" >> ${FILE_LIST_SUSE}
echo "%dir /usr/share/doc/scsi-target-utils-%{version}.%{release}" >> ${FILE_LIST_REDHAT}

cat ${FILE_LIST_SUSE}
cat ${FILE_LIST_REDHAT}

%post -n scsi-target-utils
/sbin/chkconfig --add tgtd

%preun -n scsi-target-utils
if [ "$1" = "0" ] ; then
     /sbin/chkconfig tgtd stop > /dev/null 2>&1
     /sbin/chkconfig --del tgtd
fi

%postun -n scsi-target-utils
if [ "$1" = "1" ] ; then
     /sbin/service tgtd condrestart > /dev/null 2>&1
fi

%files -n tgt -f %{_tmppath}/open-iscsi-usr-file-list-suse
%{_mandir}/man8/*

%files -n scsi-target-utils -f %{_tmppath}/open-iscsi-usr-file-list-redhat
%{_mandir}/man8/*

%clean
[ "${RPM_BUILD_ROOT}" != "/" -a -d ${RPM_BUILD_ROOT} ] && rm -rf ${RPM_BUILD_ROOT}
