# Copyright (c) 2002-2011, The Ohio State University. All rights
# reserved.
#
# The MVAPICH software package is developed by the team members of The
# Ohio State University's Network-Based Computing Laboratory (NBCL),
# headed by Professor Dhabaleswar K. (DK) Panda.
#
# Contact:
# Prof. Dhabaleswar K. (DK) Panda
# Dept. of Computer Science and Engineering
# The Ohio State University
# 2015 Neil Avenue
# Columbus, OH - 43210-1277
# Tel: (614)-292-5199; Fax: (614)-292-2911
# E-mail: panda@cse.ohio-state.edu
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are
# met:
#
# (1) Redistributions of source code must retain the above copyright
# notice, this list of conditions and the following disclaimer.
#
# (2) Redistributions in binary form must reproduce the above copyright
# notice, this list of conditions and the following disclaimer in the
# documentation and/or other materials provided with the distribution.
#
# (3) Neither the name of The Ohio State University nor the names of
# their contributors may be used to endorse or promote products derived
# from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
# "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
# OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


# Macro setup section.
# We don't want debug packages right now.
%global debug_package %{nil}
# Define any macros with default values if they have not been specified.
%{!?_name: %global _name mvapich2}
%{!?impl: %global impl ofa}
%{!?auto_req: %global auto_req 1}
%global have_mpi_selector 0
%{?mpi_selector: %global have_mpi_selector 1}

Summary: OSU MVAPICH2 MPI package
License: BSD
Group: Development/Libraries
Name: %{_name}
Prefix: %{_prefix}
Release: 2.2011svn4978
Source: http://mvapich.cse.ohio-state.edu/download/mvapich2/mvapich2-1.7.tgz
Patch1: omb-no-errorcode.patch
Patch2: mpe2-no-libtool-finish.patch
Patch3: r4978.patch
URL: http://mvapich.cse.ohio-state.edu/
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
Version: 1.7

# The requires are either handled automatically, or with simple RPM package
# specifications.
%if %{auto_req}
Autoreq: 1
%else
Autoreq: 0

# These are defines that help out below.
%global OFA %(if (echo %{impl} |grep "ofa" >/dev/null); then echo -n '1'; else echo -n '0'; fi)
%global UDAPL %(if (echo %{impl} |grep "udapl" >/dev/null); then echo -n '1'; else echo -n '0'; fi)

# Set the Requires values based on the implemenation chosen.
%if %{OFA}
Requires: libibumad libibverbs %{!?blcr: librdmacm} %{?mpi-selector: mpi-selector}
%endif

%if %{UDAPL}
Requires: dapl %{?mpi-selector: mpi-selector}
%endif
%endif

%description
This is an MPI-2 implementation which includes all MPI-1 features.  It is
based on MPICH2 and MVICH.


%prep
%setup -q -n mvapich2-1.7
%patch1 -p1
%patch2 -p1
%patch3 -p0


%build
# Apparently optimization flags are added by rpm on the PPC64 platform.
# This should remove these flags and allow our build process to work correctly.
export -n CFLAGS CPPFLAGS CXXFLAGS FFLAGS LDFLAGS

./configure --prefix=%_prefix %{?rdma} %{?ib_include} %{?ib_libpath} %{?blcr: --enable-blcr} %{?blcr_include} %{?blcr_libpath} %{?dapl_include} %{?dapl_libpath} %{?cluster_size} %{?io_bus} %{?link_speed} %{?dapl_provider} %{?shared_libs: --enable-shared} %{!?romio: --disable-romio} %{?comp_env}
make

for f in bin/mpicc bin/mpich2version bin/mpicxx bin/mpif77 bin/mpif90 \
etc/mpicxx.conf etc/mpif77.conf etc/mpif90.conf etc/mpicc.conf; do
    if [ -f $f ]; then
	sed -i "s^prefix=${RPM_BUILD_ROOT}^prefix=^g" $f
    fi
done


%install
rm -rf $RPM_BUILD_ROOT
make install DESTDIR=$RPM_BUILD_ROOT

[ -f $RPM_BUILD_ROOT/%_prefix/sbin/mpeuninstall ] && sed -i "s^${RPM_BUILD_ROOT}^^g" $RPM_BUILD_ROOT/%_prefix/sbin/mpeuninstall

# Additionally, create the mpivars.[c]sh files.
cat > $RPM_BUILD_ROOT/%_prefix/bin/mpivars.csh <<EOF
if (\$?path) then
    if ( "\${path}" !~ *%{_prefix}/bin* ) then
	set path = ( %{_prefix}/bin \$path )
    endif
else
    set path = ( %{_prefix}/bin )
endif

if ("1" == "\$?LD_LIBRARY_PATH") then
    if ("\$LD_LIBRARY_PATH" !~ *%{_prefix}/lib) then
        setenv LD_LIBRARY_PATH %{_prefix}/lib:\${LD_LIBRARY_PATH}
    endif
else
    setenv LD_LIBRARY_PATH %{_prefix}/lib
endif

if (\$?MANPATH) then
    if ( "\${MANPATH}" !~ *%{_prefix}/man* ) then
	setenv MANPATH %{_prefix}/man:\$MANPATH
    endif
else
    setenv MANPATH %{_prefix}/man:
endif
EOF

cat > $RPM_BUILD_ROOT/%_prefix/bin/mpivars.sh <<EOF
if ! echo \${PATH} | grep -q %{_prefix}/bin ; then
    PATH=%{_prefix}/bin:\${PATH}
fi

if ! echo \${LD_LIBRARY_PATH} | grep -q %{_prefix}/lib ; then
    export LD_LIBRARY_PATH=%{_prefix}/lib:\${LD_LIBRARY_PATH} 
fi

if ! echo \${MANPATH} | grep -q %{_prefix}/man ; then
    MANPATH=%{_prefix}/man:\${MANPATH}
fi
EOF


%clean
rm -rf $RPM_BUILD_ROOT


# Post install section needed if mpi-selector is used.
%if %{have_mpi_selector}
%post
%{mpi_selector} \
        --register %{name}-%{version} \
        --source-dir %{_bindir} \
        --yes
%endif


# Pre-uninstall section needed if mpi-selector is used.
%if %{have_mpi_selector}
%preun
%{mpi_selector} --unregister %{name}-%{version} --yes || \
      /bin/true >/dev/null 2>/dev/null
%endif


%files
%defattr(-,root,root,-)
%{_prefix}

%changelog
* Mon Nov 01 2011 Jonathan Perkins <perkinjo@cse.ohio-state.edu> - 1.7-2.2011svn4978
- mvapich2-1.7 post release update

* Mon Oct 17 2011 Jonathan Perkins <perkinjo@cse.ohio-state.edu> - 1.7-1
- mvapich2-1.7 release

* Tue Sep 20 2011 Jonathan Perkins <perkinjo@cse.ohio-state.edu> - 1.7-0.3.rc2
- mvapich2-1.7 pre-release

* Tue Jul 26 2011 Jonathan Perkins <perkinjo@cse.ohio-state.edu> - 1.7-0.2.rc1
- use --enable-shared instead of --enable-sharedlibs=gcc

* Tue Jul 26 2011 Jonathan Perkins <perkinjo@cse.ohio-state.edu> - 1.7-0.1.rc1
- mvapich2-1.7 pre-release

* Tue Mar 08 2011 Jonathan Perkins <perkinjo@cse.ohio-state.edu> - 1.6-2
- mvapich2-1.6 release

* Mon Mar 07 2011 Jonathan Perkins <perkinjo@cse.ohio-state.edu> - 1.6-1
- mvapich2-1.6 release

* Fri Mar 04 2011 Jonathan Perkins <perkinjo@cse.ohio-state.edu> - 1.6-0.4.2011svn4512
- mvapich2-1.6 pre-release

* Tue Feb 22 2011 Jonathan Perkins <perkinjo@cse.ohio-state.edu> - 1.6-0.3.rc3
- mvapich2-1.6 pre-release

* Tue Jan 25 2011 Jonathan Perkins <perkinjo@cse.ohio-state.edu> - 1.6-0.2.2011svn4431
- mvapich2-1.6 pre-release
 
* Tue Dec 28 2010 Jonathan Perkins <perkinjo@cse.ohio-state.edu> - 1.6-0.1.rc2
- mvapich2-1.6 pre-release

* Thu Sep 16 2010 Jonathan Perkins <perkinjo@cse.ohio-state.edu> - 1.5.1-2.p1
- mvapich2-1.5.1p1 release

* Wed Sep 15 2010 Jonathan Perkins <perkinjo@cse.ohio-state.edu> - 1.5.1-1
- mvapich2-1.5.1 release

* Sun Sep 05 2010 Jonathan Perkins <perkinjo@cse.ohio-state.edu> - 1.5.1-0.1.20100909svn4174
- mvapich2-1.5.1 pre-release

* Sun Sep 05 2010 Jonathan Perkins <perkinjo@cse.ohio-state.edu> - 1.5.1-0.1.20100905svn4167
- mvapich2-1.5.1 pre-release

* Mon Jul 12 2010 Jonathan Perkins <perkinjo@cse.ohio-state.edu> - 1.5-1
- mvapich2-1.5 release

* Wed Jul 07 2010 Jonathan Perkins <perkinjo@cse.ohio-state.edu> - 1.5-0.3.20100707svn4032
- mvapich2-1.5 pre-release

* Tue Jul 06 2010 Jonathan Perkins <perkinjo@cse.ohio-state.edu> - 1.5-0.2.20100705nightly
- mvapich2-1.5 pre-release

* Tue Jun 22 2010 Jonathan Perkins <perkinjo@cse.ohio-state.edu> - 1.5-0.1.rc2
- mvapich2-1.5 pre-release

* Sat Mar 13 2010 Jonathan Perkins <perkinjo@cse.ohio-state.edu> - 1.4.1-1
- mvapich2-1.4.1 release

* Wed Mar 02 2010 Jonathan Perkins <perkinjo@cse.ohio-state.edu> - 1.4-4.20100302svn3789
- Update with new mvapich2-1.4.1 pre-release

* Mon Feb 22 2010 Jonathan Perkins <perkinjo@cse.ohio-state.edu> - 1.4-3.20100222svn3774
- Update to mvapich2-1.4.1 pre-release
- Add special CFLAGS for rhel4 builds

* Thu Nov 19 2009 Jonathan Perkins <perkinjo@cse.ohio-state.edu> - 1.4-2
- Explicitly specify directory to setup macro since the name of this package can
  be overwritten

* Wed Nov 12 2009 Jonathan Perkins <perkinjo@cse.ohio-state.edu>
- Update for mvapich2-1.4 release.

* Mon Oct 19 2009 Jonathan Perkins <perkinjo@cse.ohio-state.edu>
- Repackaged to use md5

* Mon Oct 19 2009 Jonathan Perkins <perkinjo@cse.ohio-state.edu>
- Update to mvapich2-1.4 pre-release.

* Tue Nov 11 2008 Jonathan Perkins <perkinjo@cse.ohio-state.edu>
- Update with mvapich2-1.2p1 which includes a fix shared-memory communication
  issue for AMD Barcelona systems.

* Fri Nov 07 2008 Jonathan Perkins <perkinjo@cse.ohio-state.edu>
- Update to mvapich2-1.2 release.  Please see
  http://mvapich.cse.ohio-state.edu/download/mvapich2/changes.shtml for a
  comprehensive list of updates since 1.0.3.

* Fri Oct 31 2008 Jonathan Perkins <perkinjo@cse.ohio-state.edu>
- Update to Revision 3103 of the mvapich2 trunk.

* Fri Oct 17 2008 Jonathan Perkins <perkinjo@cse.ohio-state.edu>
- Add LD_LIBRARY to mpivars.* scripts.  Contributed by Mike Heinz from QLogic.

* Tue Oct 14 2008 Jonathan Perkins <perkinjo@cse.ohio-state.edu>
- Detect path to mpispawn if /proc filesystem is available.
- Converting "SHMEM_BCAST_LEADERS" macro to an environment variable.

* Thu Oct 09 2008 Jonathan Perkins <perkinjo@cse.ohio-state.edu>
- Change MV2_DEFAULT_MAX_WQE from 200 to 64 to reduce memory usage.
- Fix mpirun_rsh ssh stdin bug.
- Always build and install mpirun_rsh in addition to the process manager(s)
  selected through the --with-pm mechanism.
- Remove various compilation warnings.

* Tue Sep 24 2008 Jonathan Perkins <perkinjo@cse.ohio-state.edu>
- Change naming scheme of srpm since it's now based off of a subversion branch
  and not a release tarball.

* Tue Sep 20 2008 Jonathan Perkins <perkinjo@cse.ohio-state.edu>
- Base srpm on https://mvapich.cse.ohio-state.edu/svn/mpi/mvapich2/trunk to
  capture latest commits instead of applying patches to mvapich2-1.2rc2.

* Thu Sep 11 2008 Jonathan Perkins <perkinjo@cse.ohio-state.edu>
- Add variable substitution to configure line to all for selection of process
  manager.

* Tue Sep 09 2008 Jonathan Perkins <perkinjo@cse.ohio-state.edu>
- Remove configure options that force configuration files and man pages into
  the system conf and man directories.  Removing this allows multiple versions
  of mvapich2 rpms to be installed.  This is useful for OFED where users may
  want a version of mvapich2 built with several compilers.

* Mon Sep 08 2008 Jonathan Perkins <perkinjo@cse.ohio-state.edu>
- The previous ppc64 patch was incomplete.  Replaced with correct patch.

* Sun Sep 07 2008 Jonathan Perkins <perkinjo@cse.ohio-state.edu>
- Repackage with fix for ppc64 and other unaccounted for platforms.

* Mon Aug 25 2008 Jonathan Perkins <perkinjo@cse.ohio-state.edu>
- Replace \%configure with explicit ./configure to resolve build issues.

* Sat Aug 23 2008 Jonathan Perkins <perkinjo@cse.ohio-state.edu>
- Fix false positive for enabling blcr.
- Remove unused variables and commented code.

* Fri Aug 22 2008 Jonathan Perkins <perkinjo@cse.ohio-state.edu>
- Refactor spec file to account for our move to using configure directly for
  MVAPICH2-1.2rc1 and later.

* Sun May 04 2008 Jonathan Perkins <perkinjo@cse.ohio-state.edu>
- Created initial MVAPICH2 1.0.3 SRPM with IB and iWARP support.

