Summary: NFS Utils for NFS-RDMA
Name: rnfs-utils
Group: System Environment/Daemons
License: GPL
BuildRequires: krb5-devel >= 1.3.1
BuildRequires: krb5-devel libtool
Version: 1.1.5
Release: 10.OFED
BuildRoot: /var/tmp/nfs-utils-%{version}

Source: http://downloads.sourceforge.net/nfs/nfs-utils-%{version}.tar.bz2

Patch0: nfs-utils-ignore_kernel_version.patch
Patch1: rnfsv4_support.patch

%description
This package provides only the mount binary necessary to mount NFS-RDMA
connections.  All other NFS utilities are provided by the nfs-utils RPM
(which is required by this package).  The installed binary will be named
mount.rnfs

This package should be unnecessary on systems with kernels newer than
2.6.22 and nfs-utils newer than 1.1.2.

%prep
%setup -n nfs-utils-%{version} 
%patch0 -p1
%patch1 -p1

%build
%configure --disable-gss --without-tcp-wrappers --program-transform-name="s/nfs/rnfs/g"
make %{?_smp_mflags}

%install
mkdir -p $RPM_BUILD_ROOT/sbin
if [ ! -e /sbin/rpc.statd ]; then
	cp utils/statd/statd $RPM_BUILD_ROOT/sbin/rpc.statd
fi
cp utils/mount/mount.nfs $RPM_BUILD_ROOT/sbin/mount.rnfs
cp utils/mount/mount.nfs $RPM_BUILD_ROOT/sbin/mount.rnfs4
cp utils/mount/mount.nfs $RPM_BUILD_ROOT/sbin/umount.rnfs
cp utils/mount/mount.nfs $RPM_BUILD_ROOT/sbin/umount.rnfs4

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
/sbin/*

%post
#determine if it is SLES10, if so need to add rpc.statd to the nfsserver script
if test `uname -r | cut -d "-" -f 1` = "2.6.16.60"; then sed -i -e 's/  nfs4_bind_mounts$/  nfs4_bind_mounts\n\t\/sbin\/rpc.statd\n\trc_status/g' -e 's/nfs4_unbind_mounts$/nfs4_unbind_mounts\n\tkillall \/sbin\/rpc.statd\n\trc_status/g' /etc/init.d/nfsserver; fi

%postun
#determine if it is SLES10, if so need to remove rpc.statd from the nfsserver script on uninstall
if test `uname -r | cut -d "-" -f 1` = "2.6.16.60"; then sed -i -e '/rpc.statd/{N;d;}' /etc/init.d/nfsserver; fi
