%define name ib-bonding
%define version 0.9.0
%define my_release 42
%{!?_release: %define _release %{my_release}}

%{!?KVERSION: %define KVERSION %(uname -r)}
%{!?force_all_os: %define force_all_os 0}

%{!?_prefix: %define _prefix /usr}
%define IB_CONF_DIR /etc/infiniband
%define redhat4u45678 %( if  ( rpm -q redhat-release > /dev/null ) && ([ "$(rpm -q --qf '%{RELEASE}' redhat-release)" = 5.5 ] || [ "$(rpm -q --qf '%{RELEASE}' redhat-release)" = 6.1 ] || [ "$(rpm -q --qf '%{RELEASE}' redhat-release)" = 7 ] || [ "$(rpm -q --qf '%{RELEASE}' redhat-release)" = 8 ] || [ "$(rpm -q --qf '%{RELEASE}' redhat-release)" = 9 ]) ; then echo 1; else echo 0;fi)
%define redhat5 %( if  ( rpm -q redhat-release > /dev/null ) && ([ "$(rpm -q --qf '%{RELEASE}' redhat-release )" = 5.0.0.9 ]) ; then echo 1; else echo 0;fi)
%define redhat5u123 %( if  ( rpm -q redhat-release > /dev/null ) && ([ "$(rpm -q --qf '%{RELEASE}' redhat-release )" = 5.3.0.3 ] || [ "$(rpm -q --qf '%{RELEASE}' redhat-release )" = 5.1.0.2 ] || [ "$(rpm -q --qf '%{RELEASE}' redhat-release )" = 5.2.0.4 ]) ; then echo 1; else echo 0;fi)
%define redhat5u4 %( if  ( rpm -q redhat-release > /dev/null ) && ( [ "$(rpm -q --qf '%{RELEASE}' redhat-release )" = 5.4.0.3 ]) ; then echo 1; else echo 0;fi)
%define sles10sp123 %( if  ( rpm -q sles-release > /dev/null ) && ( [ "$(rpm -q --qf '%{RELEASE}' sles-release)" = 15.22 ] || [ "$(rpm -q --qf '%{RELEASE}' sles-release)" = 15.35 ] || [ "$(rpm -q --qf '%{RELEASE}' sles-release)" = 15.45.8 ] ); then echo 1; else echo 0;fi)

Summary         : ib_bonding patch and modules.
Name            : %{name}
Version         : %{version}
Release         : %{_release}
Vendor          : Voltaire Inc.
Source          : ib-bonding-%{version}.tar.gz
Group           : Applications/System
License         : GPL
BuildRoot:      %{_tmppath}/%{name}-%{version}-root

%description
This package provides a bonding device which is capable of enslaving
IP over InfiniBand (IPoIB) network devices.

%prep
rm -rf $RPM_BUILD_ROOT
%setup
%if %{redhat4u45678} || %{redhat5} || %{redhat5u123} || %{sles10sp123} || %{force_all_os}
cd linux/
./configure --kernel-version %{KVERSION}
%endif

%build
%if %{redhat4u45678} || %{redhat5} || %{redhat5u123} || %{sles10sp123} || %{force_all_os}
cd linux/drivers/net/bonding/
if make -C /lib/modules/%{KVERSION}/build  modules M=`pwd`; then
        echo " Building  IB bonding driver finished with success"
else
        echo " Building  IB bonding driver failed"
	exit 1
fi
%endif



%install
[ "${RPM_BUILD_ROOT}" != "/" -a -d ${RPM_BUILD_ROOT} ] && rm -rf ${RPM_BUILD_ROOT}
mkdir -p ${RPM_BUILD_ROOT}/lib/modules/%{KVERSION}/updates/kernel/drivers/net/bonding/
mkdir -p ${RPM_BUILD_ROOT}%{_prefix}/bin
mkdir -p ${RPM_BUILD_ROOT}%{_defaultdocdir}/%{name}-%{version}
%if %{redhat4u45678} || %{redhat5} || %{redhat5u123} || %{redhat5u4}
mkdir -p ${RPM_BUILD_ROOT}/etc/sysconfig/network-scripts
mkdir -p ${RPM_BUILD_ROOT}/sbin
%endif

%if %{sles10sp123}
mkdir -p ${RPM_BUILD_ROOT}/etc/sysconfig/network
%endif

%if %{redhat4u45678} || %{redhat5} || %{redhat5u123} || %{sles10sp123} || %{force_all_os}
install  -m 755 linux/drivers/net/bonding/bonding.ko ${RPM_BUILD_ROOT}/lib/modules/%{KVERSION}/updates/kernel/drivers/net/bonding/
%endif

%if %{redhat4u45678}
install  -m 755 linux/etc/sysconfig/network-scripts/ifup-pre-ibbond ${RPM_BUILD_ROOT}/etc/sysconfig/network-scripts/
install  -m 755 linux/sbin/call_ifenslave 			${RPM_BUILD_ROOT}/sbin/
install  -m 755 patches/os/redhat4/series 			${RPM_BUILD_ROOT}%{_defaultdocdir}/%{name}-%{version}
install  -m 755 patches/os/redhat4/redhat4-initscripts.patch 	${RPM_BUILD_ROOT}%{_defaultdocdir}/%{name}-%{version}
%endif

%if %{sles10sp123}
install  -m 755 linux/etc/sysconfig/network/unenslave.sh	    ${RPM_BUILD_ROOT}/etc/sysconfig/network/
install  -m 755 patches/os/sles10/series                            ${RPM_BUILD_ROOT}%{_defaultdocdir}/%{name}-%{version}
install  -m 755 patches/os/sles10/sles10-sysconfig-functions1.patch ${RPM_BUILD_ROOT}%{_defaultdocdir}/%{name}-%{version}
install  -m 755 patches/os/sles10/sles10-sysconfig-functions2.patch ${RPM_BUILD_ROOT}%{_defaultdocdir}/%{name}-%{version}
install  -m 755 patches/os/sles10/sles10-sysconfig-functions3.patch ${RPM_BUILD_ROOT}%{_defaultdocdir}/%{name}-%{version}
install  -m 755 patches/os/sles10/sles10-sysconfig-ifup.patch       ${RPM_BUILD_ROOT}%{_defaultdocdir}/%{name}-%{version}
%endif

%if %{sles10sp123}
cp /dev/null ${RPM_BUILD_ROOT}%{_defaultdocdir}/%{name}-%{version}/sles10-sysconfig-functions2.patch
cp /dev/null ${RPM_BUILD_ROOT}%{_defaultdocdir}/%{name}-%{version}/sles10-sysconfig-functions3.patch
cp /dev/null ${RPM_BUILD_ROOT}%{_defaultdocdir}/%{name}-%{version}/sles10-sysconfig-ifup.patch
%endif

%if %{redhat5} || %{redhat5u123} || %{redhat5u4}
install  -m 755 patches/os/redhat5/series 			${RPM_BUILD_ROOT}%{_defaultdocdir}/%{name}-%{version}
install  -m 755 patches/os/redhat5/ifdown-ib			${RPM_BUILD_ROOT}/etc/sysconfig/network-scripts/
install  -m 755 patches/os/redhat5/ifup-ib			${RPM_BUILD_ROOT}/etc/sysconfig/network-scripts/
%endif

%if %{redhat5}
install  -m 755 patches/os/redhat5/redhat5.0-initscripts.patch 	${RPM_BUILD_ROOT}%{_defaultdocdir}/%{name}-%{version}/redhat5-initscripts.patch
%endif

%if  %{redhat5u123} || %{redhat5u4}
install  -m 755 patches/os/redhat5/redhat5.123-initscripts.patch 	${RPM_BUILD_ROOT}%{_defaultdocdir}/%{name}-%{version}/redhat5-initscripts.patch
%endif


%post

%if %{redhat4u45678}
if [ ! -e /sbin/ifup-pre-local ] ; then
	echo "#!/bin/bash" >> /sbin/ifup-pre-local
fi
if ( ! grep ^/etc/sysconfig/network-scripts/ifup-pre-ibbond /sbin/ifup-pre-local > /dev/null) ; then
	echo "/etc/sysconfig/network-scripts/ifup-pre-ibbond \$1" >> /sbin/ifup-pre-local
fi
chmod +x /sbin/ifup-pre-local
%endif
%if %{redhat4u45678} || %{sles10sp123} || %{redhat5} || %{redhat5u123} || %{redhat5u4}
for p in $(cat %{_defaultdocdir}/%{name}-%{version}/series) ; do
	if (patch -N --dry-run -p0 < %{_defaultdocdir}/%{name}-%{version}/$p &> /dev/null) ; then
		patch -s  -p0 < %{_defaultdocdir}/%{name}-%{version}/$p
	else
		echo Warning: failed to apply OS patch. Your configuration files may not work properly.
		cp /dev/null %{_defaultdocdir}/%{name}-%{version}/$p
	fi
done
%endif

depmod -a

if [ -e /sys/class/net/bonding_masters ] ; then
	if [ ! -z "$KEEP_CURRENT_BONDING" ] ; then
		echo Another bonding module is currently loaded. 
		echo You must unload it before new bonding using the supplied bonding module.
	else
		modprobe -r bonding
	fi
fi
%pre

%postun
%if %{redhat4u45678}
grep -v "/etc/sysconfig/network-scripts/ifup-pre-ibbond" /sbin/ifup-pre-local > /tmp/ifup-pre-local
cp /tmp/ifup-pre-local /sbin/ifup-pre-local
%endif

depmod -a

if [ -e /sys/class/net/bonding_masters ] ; then
	if [ ! -z "$KEEP_CURRENT_BONDING" ] ; then
		echo The bonding module file that you just erased is currently loaded. 
		echo It is recommended that you unload it and restart the network.
	else
		modprobe -r bonding
	fi
fi


%preun
%if %{redhat4u45678} || %{sles10sp123} || %{redhat5} || %{redhat5u123} || %{redhat5u4}
for p in $(tac %{_defaultdocdir}/%{name}-%{version}/series) ; do
	if (patch -N -R --dry-run -p0 < %{_defaultdocdir}/%{name}-%{version}/$p &> /dev/null) ; then
		patch -s -R -p0 < %{_defaultdocdir}/%{name}-%{version}/$p
	fi
done
%endif

%files 
%if %{redhat4u45678} || %{redhat5} || %{redhat5u123} || %{sles10sp123} || %{force_all_os}
/lib/modules/%{KVERSION}/updates/kernel/drivers/net/bonding/bonding.ko
%endif
%if %{redhat4u45678}
/etc/sysconfig/network-scripts/ifup-pre-ibbond
/sbin/call_ifenslave
%{_defaultdocdir}/%{name}-%{version}/series
%{_defaultdocdir}/%{name}-%{version}/redhat4-initscripts.patch
%endif
%if %{sles10sp123}
/etc/sysconfig/network/unenslave.sh
%{_defaultdocdir}/%{name}-%{version}/series                            
%{_defaultdocdir}/%{name}-%{version}/sles10-sysconfig-functions1.patch 
%{_defaultdocdir}/%{name}-%{version}/sles10-sysconfig-functions2.patch 
%{_defaultdocdir}/%{name}-%{version}/sles10-sysconfig-functions3.patch 
%{_defaultdocdir}/%{name}-%{version}/sles10-sysconfig-ifup.patch       
%endif
%if %{redhat5} || %{redhat5u123} || %{redhat5u4}
%{_defaultdocdir}/%{name}-%{version}/series
%{_defaultdocdir}/%{name}-%{version}/redhat5-initscripts.patch
/etc/sysconfig/network-scripts/ifdown-ib
/etc/sysconfig/network-scripts/ifup-ib
%endif
