Summary: NFS Utils for NFS-RDMA
Name: rnfs-utils
Group: System Environment/Daemons
License: GPL
BuildRequires: krb5-devel >= 1.3.1 autoconf >= 2.57 automake
BuildRequires: krb5-devel libtool
Version: 1.1.5
Release: 2.OFED
BuildRoot: /var/tmp/nfs-utils-%{version}

Source: http://downloads.sourceforge.net/nfs/nfs-utils-%{version}.tar.bz2

Patch: nfs-utils-ignore_kernel_version.patch

%description
This package provides only the mount binary necessary to mount NFS-RDMA
connections.  All other NFS utilities are provided by the nfs-utils RPM
(which is required by this package).  The installed binary will be named
mount.rnfs

This package should be unnecessary on systems with kernels newer than
2.6.22 and nfs-utils newer than 1.1.2.

%prep
%setup -n nfs-utils-%{version} 
%patch -p1
 
%build
%configure --disable-gss --disable-nfsv4 --without-tcp-wrappers --program-transform-name="s/nfs/rnfs/g"
make %{?_smp_mflags}

%install
mkdir -p $RPM_BUILD_ROOT/sbin
cp utils/mount/mount.nfs $RPM_BUILD_ROOT/sbin/mount.rnfs

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
/sbin/*
