# Copyright (c) 2002-2005, Network Appliance, Inc. All rights reserved.
# Copyright (c) 2007, Intel Corporation. All rights reserved.
#
# This Software is licensed under one of the following licenses:
#
# 1) under the terms of the "Common Public License 1.0" a copy of which is
#    in the file LICENSE.txt in the root directory. The license is also
#    available from the Open Source Initiative, see
#    http://www.opensource.org/licenses/cpl.php.
#
# 2) under the terms of the "The BSD License" a copy of which is in the file
#    LICENSE2.txt in the root directory. The license is also available from
#    the Open Source Initiative, see
#    http://www.opensource.org/licenses/bsd-license.php.
#
# 3) under the terms of the "GNU General Public License (GPL) Version 2" a 
#    copy of which is in the file LICENSE3.txt in the root directory. The 
#    license is also available from the Open Source Initiative, see
#    http://www.opensource.org/licenses/gpl-license.php.
#
# Licensee has the right to choose one of the above licenses.
#
# Redistributions of source code must retain the above copyright
# notice and one of the license notices.
#
# Redistributions in binary form must reproduce both the above copyright
# notice, one of the license notices in the documentation
# and/or other materials provided with the distribution.
#
#
# uDAT and uDAPL 2.0 Registry RPM SPEC file
#
# $Id: $
Name: dapl
Version: 2.0.8
Release: 0.4.ofed20080504
Summary: A Library for userspace access to RDMA devices using OS Agnostic DAT APIs.

Group: System Environment/Libraries
License: Dual GPL/BSD/CPL
Url: http://openfabrics.org/
Source: http://www.openfabrics.org/downloads/dapl-2.0.8-0.4.ofed20080504.tar.gz
BuildRoot: %(mktemp -ud %{_tmppath}/%{name}-%{version}-%{release}-XXXXXX)
Requires(post): /sbin/ldconfig
Requires(postun): /sbin/ldconfig

%description
Along with the OpenFabrics kernel drivers, libdat and libdapl provides a userspace
RDMA API that supports DAT 2.0 specification and IB transport extensions for
atomic operations and rdma write with immediate data.

%package devel
Summary: Development files for the libdat and libdapl libraries
Group: System Environment/Libraries

%description devel
Header files for libdat and libdapl library.

%package devel-static
Summary: Static development files for libdat and libdapl library
Group: System Environment/Libraries
 
%description devel-static
Static libraries for libdat and libdapl library.

%package utils
Summary: Test suites for uDAPL library
Group: System Environment/Libraries
Requires: %{name} = %{version}-%{release}

%description utils
Useful test suites to validate uDAPL library API's.

%prep
%setup -q

%build
%configure --enable-debug --enable-ext-type=ib 
make %{?_smp_mflags}

%install
rm -rf %{buildroot}
make DESTDIR=%{buildroot} install
# remove unpackaged files from the buildroot
rm -f %{buildroot}%{_libdir}/*.la

%clean
rm -rf %{buildroot}

%post 
/sbin/ldconfig
if [ -e %{_sysconfdir}/dat.conf ]; then
    sed -e '/ofa-v2-.* u2/d' < %{_sysconfdir}/dat.conf > /tmp/$$ofadapl
    mv /tmp/$$ofadapl %{_sysconfdir}/dat.conf
fi
echo ofa-v2-ib0 u2.0 nonthreadsafe default libdaplofa.so.2 dapl.2.0 '"ib0 0" ""' >> %{_sysconfdir}/dat.conf
echo ofa-v2-ib1 u2.0 nonthreadsafe default libdaplofa.so.2 dapl.2.0 '"ib1 0" ""' >> %{_sysconfdir}/dat.conf
echo ofa-v2-ib2 u2.0 nonthreadsafe default libdaplofa.so.2 dapl.2.0 '"ib2 0" ""' >> %{_sysconfdir}/dat.conf
echo ofa-v2-ib3 u2.0 nonthreadsafe default libdaplofa.so.2 dapl.2.0 '"ib3 0" ""' >> %{_sysconfdir}/dat.conf
echo ofa-v2-bond u2.0 nonthreadsafe default libdaplofa.so.2 dapl.2.0 '"bond0 0" ""' >> %{_sysconfdir}/dat.conf

%postun 
/sbin/ldconfig
if [ -e %{_sysconfdir}/dat.conf ]; then
    sed -e '/ofa-v2-.* u2/d' < %{_sysconfdir}/dat.conf > /tmp/$$ofadapl
    mv /tmp/$$ofadapl %{_sysconfdir}/dat.conf
fi

%files
%defattr(-,root,root,-)
%{_libdir}/libda*.so.*
%doc AUTHORS README ChangeLog

%files devel
%defattr(-,root,root,-)
%{_libdir}/*.so
%dir %{_includedir}/dat2
%{_includedir}/dat2/*

%files devel-static
%defattr(-,root,root,-)
%{_libdir}/*.a

%files utils
%defattr(-,root,root,-)
%{_bindir}/*
%{_mandir}/man1/*.1*
%{_mandir}/man5/*.5*

%changelog
* Thu May 1 2008 Arlin Davis <ardavis@ichips.intel.com> - 2.0.8
- DAT/DAPL Version 2.0.8 Release 1, OFED 1.3.1  

* Thu Feb 14 2008 Arlin Davis <ardavis@ichips.intel.com> - 2.0.7
- DAT/DAPL Version 2.0.7 Release 1, OFED 1.3 GA 

* Mon Feb 04 2008 Arlin Davis <ardavis@ichips.intel.com> - 2.0.6
- DAT/DAPL Version 2.0.6 Release 1, OFED 1.3 RC4

* Tue Jan 29 2008 Arlin Davis <ardavis@ichips.intel.com> - 2.0.5
- DAT/DAPL Version 2.0.5 Release 1, OFED 1.3 RC3

* Thu Jan 17 2008 Arlin Davis <ardavis@ichips.intel.com> - 2.0.4
- DAT/DAPL Version 2.0.4 Release 1, OFED 1.3 RC2

* Tue Nov 20 2007 Arlin Davis <ardavis@ichips.intel.com> - 2.0.3
- DAT/DAPL Version 2.0.3 Release 1

* Tue Oct 30 2007 Arlin Davis <ardavis@ichips.intel.com> - 2.0.2
- DAT/DAPL Version 2.0.2 Release 1

* Tue Sep 18 2007 Arlin Davis <ardavis@ichips.intel.com> - 2.0.1-1
- OFED 1.3-alpha, co-exist with DAT 1.2 library package.  

* Wed Mar 7 2007 Arlin Davis <ardavis@ichips.intel.com> - 2.0.0.pre
- Initial release of DAT 2.0 APIs, includes IB extensions 
