# Copyright (c) 2002-2008, The Ohio State University. All rights
# reserved.
#
# The MVAPICH software package is developed by the team members of The
# Ohio State University's Network-Based Computing Laboratory (NBCL),
# headed by Professor Dhabaleswar K. (DK) Panda.
#
# Contact:
# Prof. Dhabaleswar K. (DK) Panda
# Dept. of Computer Science and Engineering
# The Ohio State University
# 2015 Neil Avenue
# Columbus, OH - 43210-1277
# Tel: (614)-292-5199; Fax: (614)-292-2911
# E-mail: panda@cse.ohio-state.edu
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are
# met:
#
# (1) Redistributions of source code must retain the above copyright
# notice, this list of conditions and the following disclaimer.
#
# (2) Redistributions in binary form must reproduce the above copyright
# notice, this list of conditions and the following disclaimer in the
# documentation and/or other materials provided with the distribution.
#
# (3) Neither the name of The Ohio State University nor the names of
# their contributors may be used to endorse or promote products derived
# from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
# "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
# OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


# Macro setup section.
# We don't want debug packages right now.
%define debug_package %{nil}
# Define any macros with default values if they have not been specified.
%{!?_name: %define _name mvapich2}
%{!?build_root: %define build_root /var/tmp/mvapich2}
%{!?impl: %define impl ofa}
%{!?romio: %define romio 0}
%{!?shared_libs: %define shared_libs 0}
%{!?rdma_cm: %define rdma_cm 0}
%{!?ckpt: %define ckpt 0}
%{!?vcluster: %define vcluster small}
%{!?io_bus: %define io_bus pci-ex}
%{!?link_speed: %define link_speed sdr}
%{!?dapl_provider: %define dapl_provider ib0}
%{!?open_ib_home: %define open_ib_home /usr/local/ofed}
%{!?dat_lib: %define dat_lib /usr/local/ofed/lib64}
%{!?dat_include: %define dat_include /usr/local/ofed/include}
%{!?mthome: %define mthome /usr/local/ibgd/driver/infinihost}
%define have_comp_env 0
%{?comp_env: %define have_comp_env 1}
%{!?auto_req: %define auto_req 1}
%define have_mpi_selector 0
%{?mpi_selector: %define have_mpi_selector 1}

# This is required in the OFED 1.2 installer environment because the
# software stack (STACK_PREFIX) is installed in the OFED Buildroot location,
# not in the final STACK_PREFIX location when this package will be built.
# If ofa_build is given, this is dealt with in the install section.
%{!?ofa_build: %define ofa_build 0}

# If running in the OFED 1.2 installer environment, this package is
# installed into the OFED RPM_BUILD_ROOT, which should also be the value
# of our build_root macro.  This turns off the error concerning unpackaged
# files in the build_root if this is the case.
%if %{ofa_build}
%define _unpackaged_files_terminate_build 0
%endif

Summary: OSU MVAPICH2 MPI package
License: BSD
Group: Development/Libraries
Name: %{_name}
Prefix: %{_prefix}
Release: 1
Source: mvapich2-1.0.3.tar.gz
URL: http://mvapich.cse.ohio-state.edu/
Buildroot: %{build_root}
Version: 1.0.3

# The requires are either handled automatically, or with simple RPM package
# specifications.
%if %{auto_req}
Autoreq: 1
%else
Autoreq: 0

# These are defines that help out below.
%define OFA %(if (echo %{impl} |grep "ofa" >/dev/null); then echo -n '1'; else echo -n '0'; fi)
%define UDAPL %(if (echo %{impl} |grep "udapl" >/dev/null); then echo -n '1'; else echo -n '0'; fi)
%define VAPI %(if (echo %{impl} |grep "vapi" >/dev/null); then echo -n '1'; else echo -n '0'; fi)

# Set the Requires values based on the implemenation chosen.
%if %{OFA}
%if %{ckpt}
%if %{have_mpi_selector}
Requires: libibumad libibverbs mpi-selector
%else
Requires: libibumad libibverbs
%endif
%else
%if %{have_mpi_selector}
Requires: libibumad libibverbs librdmacm mpi-selector
%else
Requires: libibumad libibverbs librdmacm
%endif
%endif
%endif

%if %{UDAPL}
%if %{have_mpi_selector}
Requires: dapl mpi-selector
%else
Requires: dapl
%endif
%endif

%if %{VAPI}
%if %{have_mpi_selector}
Requires: mpi-selector
%endif
%endif
%endif

%description
This is an MPI-2 implementation which includes all MPI-1 features.  It is
based on MPICH2 and MVICH.

%prep
%setup -q -n mvapich2-%{version}

# The install macro also does the build.  This is a workaround for a
# SUSE issue where the build macro removes $RPM_BUILD_ROOT.
%install

if [ %{impl} = "ofa" ]; then
    if [ %{ofa_build} -eq 1 ]; then
        export OPEN_IB_HOME=%{build_root}%{open_ib_home}
    else
        export OPEN_IB_HOME=%{open_ib_home}
    fi

    if [ %{rdma_cm} -eq 1 ]; then
        export RDMA_CM_SUPPORT=yes
    else
        export RDMA_CM_SUPPORT=no
    fi
elif [ %{impl} = "udapl" ]; then
    if [ %{ofa_build} -eq 1 ]; then
        export DAT_LIB=%{build_root}%{dat_lib}
        export DAT_INCLUDE=%{build_root}%{dat_include}
    else
        export DAT_LIB=%{dat_lib}
        export DAT_INCLUDE=%{dat_include}
    fi

    if [ -d $DAT_INCLUDE/dat2 ]; then
	export DAPL_VERSION=_V2_
    else
	export DAPL_VERSION=_V1_
    fi
elif [ %{impl} = "vapi" ]; then
    export MTHOME=%{mthome}
fi

export PREFIX=${RPM_BUILD_ROOT}%{_prefix}

%if %{romio}
export ROMIO=yes
%endif

%if %{shared_libs}
export SHARED_LIBS=yes
%endif

if [ %{impl} = "ofa" ] && [ %{ckpt} -eq 1 ]; then
    export RDMA_CM_SUPPORT=no
    export ENABLE_CKPT=yes
    export BLCR_HOME=%{blcr_home}
fi

if [ %{impl} = "udapl" ] || [ %{impl} = "vapi" ]; then
    if [ %{vcluster} = "small" ]; then
        export VCLUSTER=_SMALL_CLUSTER
    elif [ %{vcluster} = "medium" ]; then
        export VCLUSTER=_MEDIUM_CLUSTER
    elif [ %{vcluster} = "large" ]; then
        export VCLUSTER=_LARGE_CLUSTER
    fi

    if [ %{io_bus} = "pci-ex" ]; then
        export IO_BUS=_PCI_EX_

        if [ %{link_speed} = "ddr" ]; then
            export LINKS=_DDR_
        elif [ %{link_speed} = "sdr" ]; then
            export LINKS=_SDR_
        fi
    elif [ %{io_bus} = "pci-x" ]; then
        export IO_BUS=_PCI_X_
        export LINKS=_SDR_
    fi
fi

if [ %{impl} = "udapl" ]; then
    export DAPL_DEFAULT_PROVIDER=%{dapl_provider}
fi

%if %{have_comp_env}
export %{comp_env}
%endif

# Apparently optimization flags are added by rpm on the PPC64 platform.
# This should remove these flags and allow our build process to work correctly.
export -n CFLAGS CPPFLAGS CXXFLAGS FFLAGS LDFLAGS

if [ %{impl} = "ofa" ]; then
    ./make.mvapich2.ofa
elif [ %{impl} = "udapl" ]; then
    ./make.mvapich2.udapl $DAT_LIB $DAT_INCLUDE
elif [ %{impl} = "vapi" ]; then
    ./make.mvapich2.vapi
fi

# The install is actually done by our make scripts, but here we do some
# fixes.  This RPM spec uses RPM_BUILD_ROOT as part of the prefix to
# install in that location.  The binary RPM result will relocate this to
# the %{_prefix}, so here we clean up the few files where this path was
# hard coded in.
cd ${RPM_BUILD_ROOT}%{_prefix}

for f in bin/mpicc bin/mpich2version bin/mpicxx bin/mpif77 bin/mpif90 \
etc/mpicxx.conf etc/mpif77.conf etc/mpif90.conf etc/mpicc.conf; do
    if [ -f $f ]; then
	sed -i "s^prefix=${RPM_BUILD_ROOT}^prefix=^g" $f
    fi
done

%if %{ofa_build}
for f in bin/mpicc bin/mpicxx bin/mpif77 bin/mpif90 etc/mpicc.conf \
etc/mpicxx.conf etc/mpif77.conf etc/mpif90.conf; do
    if [ -f $f ]; then
	sed -i -e "s^-L${RPM_BUILD_ROOT}^-L^g" -e "s^-I${RPM_BUILD_ROOT}^-I^g" $f
    fi
done
%endif

# Additionally, create the mpivars.[c]sh files.
cat >bin/mpivars.csh <<EOF
if (\$?path) then
    if ( "\${path}" !~ *%{_prefix}/bin* ) then
	set path = ( %{_prefix}/bin \$path )
    endif
else
    set path = ( %{_prefix}/bin )
endif

if (\$?MANPATH) then
    if ( "\${MANPATH}" !~ *%{_prefix}/man* ) then
	setenv MANPATH %{_prefix}/man:\$MANPATH
    endif
else
    setenv MANPATH %{_prefix}/man:
endif
EOF

cat >bin/mpivars.sh <<EOF
if ! echo \${PATH} | grep -q %{_prefix}/bin ; then
    PATH=%{_prefix}/bin:\${PATH}
fi

if ! echo \${MANPATH} | grep -q %{_prefix}/man ; then
    MANPATH=%{_prefix}/man:\${MANPATH}
fi
EOF

%clean

%if ! %{ofa_build}
rm -rf $RPM_BUILD_ROOT
%endif

# Post install section needed if mpi-selector is used.
%if %{have_mpi_selector}
%post
%{mpi_selector} \
        --register %{name}-%{version} \
        --source-dir %{_bindir} \
        --yes
%endif

# Pre-uninstall section needed if mpi-selector is used.
%if %{have_mpi_selector}
%preun
%{mpi_selector} --unregister %{name}-%{version} --yes || \
      /bin/true >/dev/null 2>/dev/null
%endif

%files
%{_prefix}

%changelog
* Sun May 04 2008 Jonathan Perkins <perkinjo@cse.ohio-state.edu>
- Created initial MVAPICH2 1.0.3 SRPM with IB and iWARP support.

