%define name ib-bonding
%define version 0.9.0
%define my_release 24
%{!?_release: %define _release %{my_release}}

%{!?KVERSION: %define KVERSION %(uname -r)}

%{!?_prefix: %define _prefix /usr}
%define IB_CONF_DIR /etc/infiniband
%define redhat4u456 %( if  ( rpm -q redhat-release-4AS > /dev/null ) && ([ "$(rpm -q --qf '%{RELEASE}' redhat-release-4AS)" = 5.5 ] || [ "$(rpm -q --qf '%{RELEASE}' redhat-release-4AS)" = 6.1 ] || [ "$(rpm -q --qf '%{RELEASE}' redhat-release-4AS)" = 7 ]) ; then echo 1; else echo 0;fi)
%define redhat5 %( if  ( rpm -q redhat-release-5Server > /dev/null ) && ([ "$(rpm -q --qf '%{RELEASE}' redhat-release-5Server)" = 5.0.0.9 ]) ; then echo 1; else echo 0;fi)
%define sles10sp1 %( if  ( rpm -q sles-release > /dev/null ) && ([ "$(rpm -q --qf '%{RELEASE}' sles-release)" = 15.22 ]); then echo 1; else echo 0;fi)

Summary         : ib_bonding patch and modules.
Name            : %{name}
Version         : %{version}
Release         : %{_release}
Vendor          : Voltaire Inc.
Source          : ib-bonding-%{version}.tar.gz
Group           : Applications/System
License         : GPL
BuildRoot:      %{_tmppath}/%{name}-%{version}-root

%description
This package provides a bonding device which is capable of enslaving
IP over InfiniBand (IPoIB) network devices.

%prep
rm -rf $RPM_BUILD_ROOT
%setup
cd linux/
./configure --kernel-version %{KVERSION}

%build
cd linux/drivers/net/bonding/
if make -C /lib/modules/%{KVERSION}/build  modules M=`pwd`; then
        echo " Building  IB bonding driver finished with success"
else
        echo " Building  IB bonding driver failed"
	exit 1
fi



%install
[ "${RPM_BUILD_ROOT}" != "/" -a -d ${RPM_BUILD_ROOT} ] && rm -rf ${RPM_BUILD_ROOT}
mkdir -p ${RPM_BUILD_ROOT}/lib/modules/%{KVERSION}/updates/kernel/drivers/net/bonding/
mkdir -p ${RPM_BUILD_ROOT}%{_prefix}/bin
mkdir -p ${RPM_BUILD_ROOT}%{_defaultdocdir}/%{name}-%{version}
%if %{redhat4u456}
mkdir -p ${RPM_BUILD_ROOT}/etc/sysconfig/network-scripts
mkdir -p ${RPM_BUILD_ROOT}/sbin
%endif
%if %{sles10sp1}
mkdir -p ${RPM_BUILD_ROOT}/etc/sysconfig/network
%endif
install  -m 755 linux/drivers/net/bonding/bonding.ko ${RPM_BUILD_ROOT}/lib/modules/%{KVERSION}/updates/kernel/drivers/net/bonding/
install  -m 755 bin/ib-bond ${RPM_BUILD_ROOT}%{_prefix}/bin
install  -m 755 docs/ib-bonding.txt ${RPM_BUILD_ROOT}%{_defaultdocdir}/%{name}-%{version}
sed -i -e {s/VERSION=/VERSION=%{version}/g} ${RPM_BUILD_ROOT}%{_prefix}/bin/ib-bond 
sed -i -e {s/RELEASE=/RELEASE=%{my_release}/g} ${RPM_BUILD_ROOT}%{_prefix}/bin/ib-bond
%if %{redhat4u456}
install  -m 755 linux/etc/sysconfig/network-scripts/ifup-pre-ibbond ${RPM_BUILD_ROOT}/etc/sysconfig/network-scripts/
install  -m 755 linux/sbin/call_ifenslave 			${RPM_BUILD_ROOT}/sbin/
install  -m 755 patches/os/redhat4/series 			${RPM_BUILD_ROOT}%{_defaultdocdir}/%{name}-%{version}
install  -m 755 patches/os/redhat4/redhat4-initscripts.patch 	${RPM_BUILD_ROOT}%{_defaultdocdir}/%{name}-%{version}
%endif
%if %{sles10sp1}
install  -m 755 linux/etc/sysconfig/network/unenslave.sh	    ${RPM_BUILD_ROOT}/etc/sysconfig/network/
install  -m 755 patches/os/sles10/series                            ${RPM_BUILD_ROOT}%{_defaultdocdir}/%{name}-%{version}
install  -m 755 patches/os/sles10/sles10-sysconfig-functions1.patch ${RPM_BUILD_ROOT}%{_defaultdocdir}/%{name}-%{version}
install  -m 755 patches/os/sles10/sles10-sysconfig-functions2.patch ${RPM_BUILD_ROOT}%{_defaultdocdir}/%{name}-%{version}
install  -m 755 patches/os/sles10/sles10-sysconfig-functions3.patch ${RPM_BUILD_ROOT}%{_defaultdocdir}/%{name}-%{version}
install  -m 755 patches/os/sles10/sles10-sysconfig-ifup.patch       ${RPM_BUILD_ROOT}%{_defaultdocdir}/%{name}-%{version}
%endif
%if %{redhat5}
install  -m 755 patches/os/redhat5/series 			${RPM_BUILD_ROOT}%{_defaultdocdir}/%{name}-%{version}
install  -m 755 patches/os/redhat5/redhat5-initscripts.patch 	${RPM_BUILD_ROOT}%{_defaultdocdir}/%{name}-%{version}
%endif




%post
modprobe -r bonding
if [ -e %{IB_CONF_DIR}/openib.conf ]; then
	if ( ! grep IPOIBBOND_ENABLE %{IB_CONF_DIR}/openib.conf > /dev/null ) ; then
		echo							>> %{IB_CONF_DIR}/openib.conf
		echo "# Enable the bonding driver on startup"		>> %{IB_CONF_DIR}/openib.conf
		echo "IPOIBBOND_ENABLE=no"				>> %{IB_CONF_DIR}/openib.conf
		echo "# Set bond interface names"			>> %{IB_CONF_DIR}/openib.conf
		echo "#IPOIB_BONDS=bond0,bond1"				>> %{IB_CONF_DIR}/openib.conf
		echo "# Set specific bond params; address and slaves" 	>> %{IB_CONF_DIR}/openib.conf
		echo "#bond0_IP=10.10.10.1"				>> %{IB_CONF_DIR}/openib.conf
		echo "#bond0_SLAVES=ib0,ib1"				>> %{IB_CONF_DIR}/openib.conf
		echo "#bond1_IP=20.10.10.1"				>> %{IB_CONF_DIR}/openib.conf
		echo "#bond1_SLAVES=ib2,ib3,ib4"			>> %{IB_CONF_DIR}/openib.conf
	fi
fi

%if %{redhat4u456}
if [ ! -e /sbin/ifup-pre-local ] ; then
	echo "#!/bin/bash" >> /sbin/ifup-pre-local
fi
if ( ! grep ^/etc/sysconfig/network-scripts/ifup-pre-ibbond /sbin/ifup-pre-local > /dev/null) ; then
	echo "/etc/sysconfig/network-scripts/ifup-pre-ibbond \$1" >> /sbin/ifup-pre-local
fi
chmod +x /sbin/ifup-pre-local
%endif
%if %{redhat4u456} || %{sles10sp1} || %{redhat5}
for p in $(cat %{_defaultdocdir}/%{name}-%{version}/series) ; do
	if (patch -N --dry-run -p0 < %{_defaultdocdir}/%{name}-%{version}/$p &> /dev/null) ; then
		patch -s  -p0 < %{_defaultdocdir}/%{name}-%{version}/$p
	else
		cp /dev/null %{_defaultdocdir}/%{name}-%{version}/$p
	fi
done
%endif

depmod -a

%pre

%postun
%if %{redhat4u456}
grep -v "/etc/sysconfig/network-scripts/ifup-pre-ibbond" /sbin/ifup-pre-local > /tmp/ifup-pre-local
cp /tmp/ifup-pre-local /sbin/ifup-pre-local
%endif

depmod -a
%preun
ib-bond --stop-all
modprobe -r bonding
%if %{redhat4u456} || %{sles10sp1} || %{redhat5}
for p in $(tac %{_defaultdocdir}/%{name}-%{version}/series) ; do
	if (patch -N -R --dry-run -p0 < %{_defaultdocdir}/%{name}-%{version}/$p &> /dev/null) ; then
		patch -s -R -p0 < %{_defaultdocdir}/%{name}-%{version}/$p
	fi
done
%endif

%files 
/lib/modules/%{KVERSION}/updates/kernel/drivers/net/bonding/bonding.ko
%{_prefix}/bin/ib-bond
%{_defaultdocdir}/%{name}-%{version}/ib-bonding.txt
%if %{redhat4u456}
/etc/sysconfig/network-scripts/ifup-pre-ibbond
/sbin/call_ifenslave
%{_defaultdocdir}/%{name}-%{version}/series
%{_defaultdocdir}/%{name}-%{version}/redhat4-initscripts.patch
%endif
%if %{sles10sp1}
/etc/sysconfig/network/unenslave.sh
%{_defaultdocdir}/%{name}-%{version}/series                            
%{_defaultdocdir}/%{name}-%{version}/sles10-sysconfig-functions1.patch 
%{_defaultdocdir}/%{name}-%{version}/sles10-sysconfig-functions2.patch 
%{_defaultdocdir}/%{name}-%{version}/sles10-sysconfig-functions3.patch 
%{_defaultdocdir}/%{name}-%{version}/sles10-sysconfig-ifup.patch       
%endif
%if %{redhat5}
%{_defaultdocdir}/%{name}-%{version}/series
%{_defaultdocdir}/%{name}-%{version}/redhat5-initscripts.patch
%endif
