%define name open-iscsi-generic
%define version 2.0
%define release 754

Summary		: open-iscsi programs
Name		: %{name}
Version		: %{version}
Release		: %{release}
Vendor		: Voltaire Inc.
Source		: open-iscsi-generic-%{version}.tar.gz
Packager	: Erez Zilber <erezz@voltaire.com>
Provides	: iscsi initiator
Group		: Storage
License		: GPL
BuildRoot:      %{_tmppath}/%{name}

%description
This package provides open-iscsi userspace programs

%define kversion $(uname -r | sed "s/-ppc64\|-smp//")

%package -n iscsi-initiator-utils
Summary		: iSCSI daemon and utility programs
Group		: System Environment/Daemons
%description -n iscsi-initiator-utils
The iscsi package provides the server daemon for the iSCSI protocol,
as well as the utility programs used to manage it. iSCSI is a protocol
for distributed disk access using SCSI commands sent over Internet
Protocol networks.

%package -n open-iscsi
Summary     : Linux* Open-iSCSI Software Initiator
Group       : Productivity/Networking/Other
%description -n open-iscsi
Open-iSCSI is a high-performance, transport independent, multi-platform
implementation of RFC3720 iSCSI.

Open-iSCSI is partitioned into user and kernel parts.

The kernel portion of Open-iSCSI is a from-scratch code licensed under
GPL. The kernel part implements iSCSI data path (that is, iSCSI Read
and iSCSI Write), and consists of two loadable modules: iscsi_if.ko and
iscsi_tcp.ko.

User space contains the entire control plane: configuration manager,
iSCSI Discovery, Login and Logout processing, connection-level error
processing, Nop-In and Nop-Out handling, and (in the future:) Text
processing, iSNS, SLP, Radius, etc.

The user space Open-iSCSI consists of a daemon process called iscsid,
and a management utility iscsiadm.

%prep
rm -rf $RPM_BUILD_ROOT

%setup

%build

cd usr
if make; then
	echo "open-iscsi userspace code built ok"
	bail_out=0
else
	echo "Failed to build open-iscsi userspace code, cleaning up..."
	bail_out=1
fi

cd ..

if [ $bail_out = 1 ] ; then
        echo "Unable to build open-iscsi userspace"
        exit 1
fi

cd linux-iscsi
if make utils; then
	echo "linux-iscsi utils code built ok"
	bail_out=0
else
	echo "Failed to build linux-iscsi utils, cleaning up..."
	bail_out=1
fi
cd ..

if [ $bail_out = 1 ] ; then
        echo "Unable to build linux-iscsi utils"
        exit 1
fi

%install

function copy_n_add_file()
{
	orig_file=$1
	dest_path=$2
	distro=$3
	directive=$4

	if [ $5 ]; then
		file_name=$5
	else
		file_name=$(basename $orig_file)
	fi
					
	cp $orig_file ${RPM_BUILD_ROOT}$dest_path/$file_name

	add_file $orig_file $dest_path $distro $directive $file_name
}

function add_file()
{
	file_orig_path=$1
	file_dest_path=$2
	distro=$3
	directive=$4

	if [ $5 ]; then
		file_name=$5
	else
		file_name=$(basename $file_orig_path)
	fi

	echo "$directive $file_dest_path/$file_name" >> %{_tmppath}/open-iscsi-usr-file-list-$distro
}

%define DISTRO_LIST suse redhat

# Delete old file list files
for distro in %{DISTRO_LIST} ; do
	rm -f %{_tmppath}/open-iscsi-usr-file-list-$distro
done

# Delete the dir where the userspace programs were built
if [ "${RPM_BUILD_ROOT}" != "/" -a -d ${RPM_BUILD_ROOT} ] ; then rm -rf ${RPM_BUILD_ROOT} ; fi

rm -rf ${RPM_BUILD_ROOT}/tmp

# Put the new open-iscsi userspace tools in our tmp dir
%define USER_PROGRAMS_LIST iscsiadm iscsid iscsistart iscsi_discovery iscsi-iname

for i in %{USER_PROGRAMS_LIST} ; do
	found_new_file=$(find ${PWD} -type f -name "*$i")
	mkdir -p ${RPM_BUILD_ROOT}/sbin
	cp $found_new_file ${RPM_BUILD_ROOT}/sbin
	for distro in %{DISTRO_LIST} ; do
		add_file $found_new_file /sbin $distro "%attr(0755,root,root)"
	done
done

# Handle etc files (different names for each distribution)
mkdir -p ${RPM_BUILD_ROOT}/etc/init.d
copy_n_add_file $PWD/etc/initd/initd.suse /etc/init.d/ suse "%attr(0755,root,root)" open-iscsi
mkdir -p ${RPM_BUILD_ROOT}/etc/iscsi
copy_n_add_file $PWD/etc/iscsid.conf /etc/iscsi suse "%config"
mkdir -p ${RPM_BUILD_ROOT}/etc/sysconfig
copy_n_add_file $PWD/etc/sysconfig/open-iscsi /etc/sysconfig suse "%config"

mkdir -p ${RPM_BUILD_ROOT}/etc/init.d
copy_n_add_file $PWD/etc/initd/initd.redhat /etc/init.d/ redhat "%attr(0755,root,root)" iscsi
mkdir -p ${RPM_BUILD_ROOT}/etc/iscsi
copy_n_add_file $PWD/etc/iscsid.conf /etc/iscsi redhat "%config"

#  Put the new open-iscsi man pages in our tmp dir
%define MAN_LIST iscsi_discovery.8.gz  iscsiadm.8.gz  iscsid.8.gz

for i in %{MAN_LIST} ; do
	found_new_file=$(find ${PWD} -type f -name "*$i")
	mkdir -p ${RPM_BUILD_ROOT}/usr/share/man/man8
	cp $found_new_file ${RPM_BUILD_ROOT}/usr/share/man/man8
	for distro in %{DISTRO_LIST} ; do
		add_file $found_new_file /usr/share/man/man8 $distro "%doc"
	done	
done

# Put misc open-iscsi files in our tmp dir
%define MISC_LIST COPYING README

for i in %{MISC_LIST} ; do
	found_new_file=$(find ${PWD} -type f -name "*$i")
	mkdir -p ${RPM_BUILD_ROOT}/usr/share/doc/packages/open-iscsi
	cp $found_new_file ${RPM_BUILD_ROOT}/usr/share/doc/packages/open-iscsi
	add_file $found_new_file /usr/share/doc/packages/open-iscsi suse "%doc"

	mkdir -p ${RPM_BUILD_ROOT}/usr/share/doc/iscsi-initiator-utils-6.%{version}.%{release}
	cp $found_new_file ${RPM_BUILD_ROOT}/usr/share/doc/iscsi-initiator-utils-6.%{version}.%{release}
	add_file $found_new_file /usr/share/doc/iscsi-initiator-utils-6.%{version}.%{release} redhat "%doc"
done

# Build the file list
FILE_LIST_SUSE=%{_tmppath}/open-iscsi-usr-file-list-suse
FILE_LIST_REDHAT=%{_tmppath}/open-iscsi-usr-file-list-redhat

# Add directories to the file list
echo "%dir /usr/share/doc/packages/open-iscsi" >> ${FILE_LIST_SUSE}
echo "%dir /usr/share/doc/iscsi-initiator-utils-6.%{version}.%{release}" >> ${FILE_LIST_REDHAT}

cat ${FILE_LIST_SUSE}
cat ${FILE_LIST_REDHAT}

%clean
[ "${RPM_BUILD_ROOT}" != "/" -a -d ${RPM_BUILD_ROOT} ] && rm -rf ${RPM_BUILD_ROOT}

%post -n open-iscsi
mkdir -p /etc/iscsi
# Create the initiatorname file if it does not exist
if [ ! -f /etc/initiatorname.iscsi ]; then
	cat << EOF >> /etc/initiatorname.iscsi
## DO NOT EDIT OR REMOVE THIS FILE!
## If you remove this file, the iSCSI daemon will not start.
## If you change the InitiatorName, existing access control lists
## may reject this initiator.  The InitiatorName must be unique
## for each iSCSI initiator.  Do NOT duplicate iSCSI InitiatorNames.
EOF
	ISSUEDATE="1996-04"
	INAME=$(/sbin/iscsi-iname -p iqn.$ISSUEDATE.voltaire.com:01)
	printf "InitiatorName=$INAME\n"  >>/etc/initiatorname.iscsi
	chmod 0600 /etc/initiatorname.iscsi
fi

# If the initiatorname file is not in its new location, add a link to it
if ! [ -e /etc/iscsi/initiatorname.iscsi ] ; then
	ln -snf /etc/initiatorname.iscsi /etc/iscsi/initiatorname.iscsi
fi

%post -n iscsi-initiator-utils
mkdir -p /etc/iscsi
# Create the initiatorname file if it does not exist
if [ ! -f /etc/initiatorname.iscsi ]; then
	cat << EOF >> /etc/initiatorname.iscsi
## DO NOT EDIT OR REMOVE THIS FILE!
## If you remove this file, the iSCSI daemon will not start.
## If you change the InitiatorName, existing access control lists
## may reject this initiator.  The InitiatorName must be unique
## for each iSCSI initiator.  Do NOT duplicate iSCSI InitiatorNames.
EOF
	ISSUEDATE="1996-04"
	INAME=$(/sbin/iscsi-iname -p iqn.$ISSUEDATE.voltaire.com:01)
	printf "InitiatorName=$INAME\n"  >>/etc/initiatorname.iscsi
	chmod 0600 /etc/initiatorname.iscsi
fi

# If the initiatorname file is not in its new location, add a link to it
if ! [ -e /etc/iscsi/initiatorname.iscsi ] ; then
	ln -snf /etc/initiatorname.iscsi /etc/iscsi/initiatorname.iscsi
fi
 
%files -n open-iscsi -f %{_tmppath}/open-iscsi-usr-file-list-suse
%files -n iscsi-initiator-utils -f %{_tmppath}/open-iscsi-usr-file-list-redhat

