%define name ib-bonding
%define version 0.9.0
%define my_release 12
%{!?_release: %define _release %{my_release}}

%{!?KVERSION: %define KVERSION %(uname -r)}

%{!?_prefix: %define _prefix /usr}
%define IB_CONF_DIR /etc/infiniband

Summary         : ib_bonding patch and modules.
Name            : %{name}
Version         : %{version}
Release         : %{_release}
Vendor          : Voltaire Inc.
Source          : ib-bonding-%{version}.tar.gz
Group           : Applications/System
License         : GPL
BuildRoot:      %{_tmppath}/%{name}-%{version}-root

%description
This package provides a bonding device which is capable of enslaving
IP over InfiniBand (IPoIB) network devices.

%prep
rm -rf $RPM_BUILD_ROOT
%setup
cd linux/
./configure --kernel-version %{KVERSION}

%build
cd linux/drivers/net/bonding/
if make -C /lib/modules/%{KVERSION}/build  modules M=`pwd`; then
        echo " Building  IB bonding driver finished with success"
else
        echo " Building  IB bonding driver failed"
	exit 1
fi



%install
[ "${RPM_BUILD_ROOT}" != "/" -a -d ${RPM_BUILD_ROOT} ] && rm -rf ${RPM_BUILD_ROOT}
mkdir -p ${RPM_BUILD_ROOT}/lib/modules/%{KVERSION}/updates/kernel/drivers/net/bonding/
mkdir -p ${RPM_BUILD_ROOT}%{_prefix}/bin
mkdir -p ${RPM_BUILD_ROOT}%{_defaultdocdir}/%{name}-%{version}
install  -m 755 linux/drivers/net/bonding/bonding.ko ${RPM_BUILD_ROOT}/lib/modules/%{KVERSION}/updates/kernel/drivers/net/bonding/
install  -m 755 bin/ib-bond ${RPM_BUILD_ROOT}%{_prefix}/bin
install  -m 755 docs/ib-bonding.txt ${RPM_BUILD_ROOT}%{_defaultdocdir}/%{name}-%{version}
sed -e {s/VERSION=/VERSION=%{version}/g} ${RPM_BUILD_ROOT}%{_prefix}/bin/ib-bond > /tmp/ib-bond
cp /tmp/ib-bond ${RPM_BUILD_ROOT}%{_prefix}/bin/ib-bond
sed -e {s/RELEASE=/RELEASE=%{my_release}/g} ${RPM_BUILD_ROOT}%{_prefix}/bin/ib-bond > /tmp/ib-bond
cp /tmp/ib-bond ${RPM_BUILD_ROOT}%{_prefix}/bin/ib-bond

%post
if [ -e %{IB_CONF_DIR}/openib.conf ]; then
	if ( ! grep IPOIBBOND_ENABLE %{IB_CONF_DIR}/openib.conf >/dev/null ) ; then
		echo							>> %{IB_CONF_DIR}/openib.conf
		echo "# Enable the bonding driver on startup"		>> %{IB_CONF_DIR}/openib.conf
		echo "IPOIBBOND_ENABLE=no"				>> %{IB_CONF_DIR}/openib.conf
		echo "# Set bond interface names"			>> %{IB_CONF_DIR}/openib.conf
		echo "#IPOIB_BONDS=bond0,bond1"				>> %{IB_CONF_DIR}/openib.conf
		echo "# Set specific bond params; address and slaves" 	>> %{IB_CONF_DIR}/openib.conf
		echo "#bond0_IP=10.10.10.1"				>> %{IB_CONF_DIR}/openib.conf
		echo "#bond0_SLAVES=ib0,ib1"				>> %{IB_CONF_DIR}/openib.conf
		echo "#bond1_IP=20.10.10.1"				>> %{IB_CONF_DIR}/openib.conf
		echo "#bond1_SLAVES=ib2,ib3,ib4"			>> %{IB_CONF_DIR}/openib.conf
	fi
fi

depmod -a

%pre

%postun
depmod -a

%files 
/lib/modules/%{KVERSION}/updates/kernel/drivers/net/bonding/bonding.ko
%{_prefix}/bin/ib-bond
%{_defaultdocdir}/%{name}-%{version}/ib-bonding.txt

