%define install_root %(echo ${install_root})
%define STACK_PREFIX %(echo ${STACK_PREFIX})
%define MTHOME_INCLUDE %(echo ${MTHOME_INCLUDE})
%define MTHOME_LIB %(echo ${MTHOME_LIB})
%define arch_name %(echo ${arch_name})
%define compfile %(echo ${compfile})
%define compiler %(echo ${compiler})
%define comp_ver %(echo ${comp_ver})
%define mvapich_rev_rpm %(echo ${mvapich_rev} | sed 's/-/_/g')
%define mvapich_rev %(echo ${mvapich_rev})
%define build_id %(echo ${build_id})
%define patch_level %(echo ${patch_level})
%define name %(echo "mpich_mlx_${compiler}${comp_ver}")
%define cluster_size %(echo "${cluster_size}")
%define debug_package %{nil}
%define __check_files %{nil}

# Disable brp-lib64-linux
%ifarch x86_64 ia64
%define __arch_install_post %{nil}
%endif

Summary: Argonne National Laboratory MPI implementation
Name: %{name}
Vendor: Argonne National Laboratory
Packager: Mellanox Technologies http://www.mellanox.com
License: BSD-like
Group: System Environment/Libraries 
URL: http://www.mcs.anl.gov/mpi/mpich/

%define krelver %(echo $(uname -r) | tr -s '-' '_')

# Define the release value; this will be used, along with the compiler
# choice, to specify an actual Release name
%define release 1

#
# Set update_paths to 1 when building an RPM for distribution.  Set it
# to 0 when building a test RPM that you want to tryout when a BUILDRROOT
# is specified (if update_paths is 1, then the MPICH commands that need
# to know the file locations are edited to remove the BUILDROOT).
%define update_paths 1

Version: %{mvapich_rev_rpm}%{patch_level}
Release: %{release}
Source: mvapich-%{mvapich_rev}.tar.gz
BuildRoot: %{install_root}

%ifarch x86_64 ia64
Provides: libmpich.so.1()(64bit) libmpich.so()(64bit) libmpich.so.1.0()(64bit)
%else
Provides: libmpich.so.1 libmpich.so libmpich.so.1.0
%endif

%description 
MPICH is an open-source and portable implementation of the Message-Passing
Interface (MPI, www.mpi-forum.org).  MPI is a library for parallel programming,
and is available on a wide range of parallel machines, from single laptops to
massively parallel vector parallel processors.  
MPICH includes all of the routines in MPI 1.2, along with the I/O routines
from MPI-2 and some additional routines from MPI-2, including those supporting
MPI Info and some of the additional datatype constructors.  MPICH  was
developed by Argonne National Laboratory. See www.mcs.anl.gov/mpi/mpich for
more information.

%prep

%install
cd mvapich-%{mvapich_rev}
./install-mvapich.sh --arch %{arch_name} --comp %{compfile} --include_path %{MTHOME_INCLUDE} \
    --lib_path %{MTHOME_LIB} --mpi_install /%{STACK_PREFIX}/mpi/%{compiler}%{comp_ver} --csize %{cluster_size} --install_root  %{install_root}

%post	
# perl -ni -e "print unless (m@%{STACK_PREFIX}/mpi/%{compiler}%{comp_ver}/mvapich-%{mvapich_rev}%{patch_level}/lib/shared@)" /etc/ld.so.conf
# echo "%{STACK_PREFIX}/mpi/%{compiler}%{comp_ver}/mvapich-%{mvapich_rev}%{patch_level}/lib/shared" >> /etc/ld.so.conf
# /sbin/ldconfig

%postun
# if (grep -v %{STACK_PREFIX}/mpi/%{compiler}%{comp_ver}/mvapich-%{mvapich_rev}%{patch_level}/lib/shared /etc/ld.so.conf > /tmp/tmp.file.mvapich); then
# 	mv -f /tmp/tmp.file.mvapich /etc/ld.so.conf
# fi
# rm -f /tmp/tmp.file.mvapich
# /sbin/ldconfig

%clean
rm -rf $RPM_BUILD_DIR/mvapich-%{mvapich_rev}

%files
%defattr(-,root,root)
%{STACK_PREFIX}/mpi/%{compiler}%{comp_ver}/mvapich-%{mvapich_rev}%{patch_level}
