#!/bin/bash

function usage {
    echo 'install-mvapich.sh [--help] [--arch <-D_IA32_/-D_IA64_/-D_EM64T_/-D_X86_64>] [--comp <COMPILER>] [--include_path <INCLUDE_PATH>] [--lib_path <LIB_PATH>] [--mpi_install <MPI_INSTALL>] [--install_root <INSTALL_ROOT>]'
    exit 1
}

build_dir=`cd ${0%*/*};pwd`
ARCH_NAME="-D_IA32_"
INCLUDE_PATH=""
LIB_PATH=""
MPI_INSTALL=/usr/local/ibgd/mpi/osu/gcc
compfile=gcc
cluster_size=small

while [ "$1" ]; do
    case "$1" in
        --arch)
            ARCH_NAME=$2
            shift 2
            ;;
        --include_path)
            INCLUDE_PATH=$2
            shift 2
            ;;
        --lib_path)
            LIB_PATH=$2
            shift 2
            ;;
        --mpi_install)
            MPI_INSTALL=$2
            shift 2
            ;;
	--install_root)
	    INSTALL_ROOT=$2
	    shift 2
	    ;;
        --comp)
	    compfile=$2
            shift 2
            ;;
        --csize)
	    cluster_size=$2
	    shift 2
	    ;;
        --help)
            usage
            shift
            ;;
        *)
            echo "Wrong parameter error!"
            usage
            ;;
    esac
done
mvapich_rev=${mvapich_rev}${patch_level}

INSTALL_PATH=$INSTALL_ROOT/$MPI_INSTALL/mvapich-${mvapich_rev}

case $compfile in
	gcc)
		compfile="./gcc.def"
		;;
	pathscale)
		compfile="./pathscale.def"
		;;
	intel)
		compfile="./icc.def"
		;;
	pgi)
		compfile="./pgi.def"
		;;
	*)
		# all other custom file defenition
		if [ ! -f $compfile ]; then
			echo "Can not open compiler def file $compfile"	
		fi
		compfile="$compfile"
		;;
esac

if [[ "$cluster_size" != "small" && "$cluster_size" != "medium" && "$cluster_size" != "big" ]]; then
	echo "Cluster size - $cluster_size is incorrect"
	exit 1
fi

# Start build
./mvapich.make --def_file $compfile --arch $ARCH_NAME --include_path $INCLUDE_PATH --lib_path $LIB_PATH --install_path $MPI_INSTALL/mvapich-${mvapich_rev} --csize $cluster_size --ibgd_tmpbuild $INSTALL_ROOT
if [ $? -ne 0 ]; then
    echo "Mvapich installation failed"
    exit 1
fi

# mvapich docs
cp CHANGES.mvapich CHANGES.mvapich.mlx COPYRIGHT COPYRIGHT_MVAPICH CREDITS.mvapich KnownBugs LICENSE.TXT mvapich.tuning_guide mvapich.user_guide README README_MPICH $INSTALL_PATH/doc
cp mpid/vapi/COPYRIGHT_MVICH mpid/vapi/CREDITS.mvich mpid/vapi/MVICH_LICENSE.TXT $INSTALL_PATH/doc
cp mpid/vapi/README $INSTALL_PATH/doc/README_MVICH

# We don't need it in IBED
# Installing tests
# PALLAS test
#export MPICH_ROOT=$INSTALL_PATH
#cd  ${build_dir}/PMB2.2.1/SRC_PMB
#make clean
#make MPIHOME=$MPICH_ROOT
#if [ $? -ne 0 ]; then
#    echo "Pallas compilation failed"
#    exit 1
#fi
#
#mkdir -p $MPICH_ROOT/tests/PMB2.2.1
#cp PMB-MPI1 $MPICH_ROOT/tests/PMB2.2.1/
#
## osu-tests test
#cd ${build_dir}/osu-tests
#make MPIHOME=$MPICH_ROOT
#if [ $? -ne 0 ]; then
#    echo "BW/LT compilation failed"
#    exit 1
#fi
#
#mkdir -p $MPICH_ROOT/tests/osu-tests/
#cp bw lt $MPICH_ROOT/tests/osu-tests/
#
## presta test
#cd ${build_dir}/presta1.2
#make clean
#make MPIHOME=$MPICH_ROOT
#if [ $? -ne 0 ]; then
#    echo "Presta compilation failed"
#    exit 1
#fi
#
#mkdir -p $MPICH_ROOT/tests/presta1.2
#cp allred com globalop laten $MPICH_ROOT/tests/presta1.2/
#

# MPICH  after install
for file in `grep -r -l -I $INSTALL_ROOT $INSTALL_PATH/*|grep -v :0 \
  |grep -v \\\.a |awk -F : '{print $1}'` ; do
  perl -pi -e "s,$INSTALL_ROOT,,g" $file
done
