#!/bin/bash  
function usage {
    echo 'build_mvapich_env.sh [--help] [--arch <_IA32_/_IA64_/_EM64T_/_X86_64>] [--prefix <PREFIX>] [--build_root <BUILD_ROOT>] [--install_root <INSTALL_ROOT>] [--spec_file <SPEC_FILE>] [--patch_list <PATCH_LIST>] --driver_home <DRIVERPATH>'
    exit 1
}

# Find the directory where this script resides
basedir=`cd ${0%*/*};pwd`
install_root=/var/tmp/IBED
prefix=/usr/local/ibgd
arch_name=""
fflags=""
mpich_spec=mpich-osu.spec
patch_list=patch.lst
compfiledir=compfiles
base_dir=`dirname $0`
build_root=$(rpm --eval '%{_topdir}')/BUILD

# Handle the case there is no makedepend...
export PATH=${PATH}:${basedir}

while [ "$1" ]; do
 	case "$1" in
		--arch)
                        arch_name=$2
                        shift 2
                        ;;
		--install_root)
                        install_root=$2
                        shift 2
                        ;;
		--build_root)
                        build_root=$2
                        shift 2
                        ;;
		--prefix)
                        prefix=$2
                        shift 2
                        ;;
		--spec_file)
                        mpich_spec=$2
                        shift 2
                        ;;
		--patch_list)
                        patch_list=$2
                        shift 2
                        ;;
		--compfile|--comp)
		    	compfile=$2
			shift 2
			;;
		--driver_home)    
			driver_home=$2
			shift 2
			;;
		--help)
                        usage
                        shift
                        ;;
 		--)
                        shift
                        break
                        ;;
 		*)
                        echo "Wrong parameter error!"
                        usage
                        ;;
   esac
done

if [ ! -f ${base_dir}/BUILD_ID ]; then
    echo "BUILD_ID file does not exist"
    exit 1
fi
source ${base_dir}/BUILD_ID

case  $compfile in
	gcc)
		compiler=gcc
		compfile=$compiler
		comp_ver=
		;;
	pgi)
		compiler=pgi
		compfile=$compiler
		comp_ver=
		;;
	pathscale)
		compiler=pathscale
		compfile=$compiler
		comp_ver=
		;;
	intel)
		compiler=intel
		compfile=$compiler
		comp_ver=
		;;
	*)
		# detect full path to this file
		compfile=`fullname $compfile`
		source $compfile
		;;
esac

printf "\nOpening tarball mvapich-${mvapich_rev}.tar.gz\n"
cd $build_root
tar xzf $basedir/mvapich-${mvapich_rev}.tar.gz
if [ $? -ne 0 ];then
	echo "Failed to open tar file."
	exit 1
fi
if [ ! -d $build_root/mvapich-${mvapich_rev} ]; then
    echo Failed opening mvapich-${mvapich_rev}.tar.gz under $build_root - exiting...       
    exit 1
fi

printf "\nCopying patch files to $build_root and applying patches\n"
if [ ! -f $basedir/$patch_list ]; then
    echo $patch_list file not found - exiting...       
    exit 1
fi

cd mvapich-${mvapich_rev}
patch_level=`cat $basedir/$patch_list | grep -v "^#" |sort |tail -1| awk -F"-" '{print $4}' | awk -F"." '{print $1}'` 
echo "PATCH_VERSION $patch_level" >> MLX_VERSION
if [ "$patch_level" != "" ]; then
	patch_level=".p$patch_level"
fi
	
for patch_file in `cat $basedir/$patch_list`; do
    file_name=`basename $patch_file .gz`
    gzip -cdf $basedir/$patch_file > $file_name
    echo "Applying patch $file_name"
    patch -p0 < $file_name
done

printf "\nCopying install-mvapich.sh\n"
cp -f $basedir/install-mvapich.sh .
cp -r $basedir/$compfiledir .

# We don't have tests in IBED
#printf "\nPreparing tests\n"
## PALLAS test
#tar -zxf $basedir/PMB2.2.1.tar.gz
## osu-tests test
#tar -zxf $basedir/osu-tests.tar.gz
## presta test
#tar -zxf $basedir/presta1.2.tar.gz

# Set environment variables

# Support for cross-compilation. If no --arch specified in command line,
# current system architecture is considered

if [ -z $arch_name ]; then 
   if [ ! -z "`uname -m | grep 86 | grep -v 86_64`" ]; then
      # echo "x86"
      arch_name="_IA32_"
   elif [ ! -z "`uname -m | grep 64 | grep -v 86_64 | grep -v ppc64`" ]; then
      # echo "ia64"
      arch_name="_IA64_"
   elif [ ! -z "`uname -m | grep ppc64`" ]; then
      # echo "ppc64"
      arch_name="_PPC64_"
   elif [ ! -z "`uname -m | grep 86_64`" ]; then
      if [ ! -z "`cat /proc/cpuinfo | grep vendor | grep Intel`" ]; then
         # echo "em64t"
         arch_name="_EM64T_"
      else
         # echo "x86_64"
         arch_name="_X86_64_"
      fi
   fi
fi
arch_name="-D$arch_name"


# Prepare "include" and "lib" paths

echo $arch_name | grep -v IA64 |grep -q 64 && BIT=64 &> /dev/null

if [ "$driver_home" == "" ]; then
driver_home=${install_root}/${prefix}/driver/infinihost
fi

MTHOME_INCLUDE=${driver_home}/include
MTHOME_LIB=${driver_home}/lib$BIT

if [ ! -d $MTHOME_LIB ] ;then
	echo "Can't locate $MTHOME_LIB"
	exit 1
fi

if [ ! -d $MTHOME_INCLUDE ] ;then
	echo "Can't locate $MTHOME_INCLUDE"
	exit 1
fi

mpi_install=${install_root}/${prefix}/mpi/${compiler}${comp_ver}

export MTHOME_INCLUDE
export MTHOME_LIB
export mpi_install
export install_root
export build_root
export prefix
export mpi_prefix
export compiler
export compfile
export comp_ver
export mvapich_rev
export build_id
export arch_name
export fflags
export patch_level
export FFLAGS="$FFLAGS ${fflags}" 
export BASE_FFLAGS="$BASE_FFLAGS ${fflags}"
export CFLAGS="$CFLAGS ${cflags}"
#export INSTALL_PATH=${mpi_install}/mvapich-${mvapich_rev}

printf "\nEnvirnoment variables:\n"
echo ----------------------
echo MTHOME_INCLUDE=$MTHOME_INCLUDE
echo MTHOME_LIB=$MTHOME_LIB
echo mpi_install=$mpi_install
echo install_root=$install_root
echo build_root=$build_root
echo prefix=$prefix
echo mpi_prefix=$mpi_prefix
echo compiler=$compiler
echo compfile=$compfile
echo comp_ver=$comp_ver
echo mvapich_rev=$mvapich_rev
echo build_id=$build_id
echo patch_level=$patch_level
echo arch_name=$arch_name
echo fflags=$fflags
echo FFLAGS=$FFLAGS
echo BASE_FFLAGS=$BASE_FFLAGS
echo CFLAGS=$CFLAGS
#echo INSTALL_PATH=$INSTALL_PATH

printf "\nPreparing install directory\n" 

# Check if OSU MPI already installed

if [ ! -d $mpi_install ] ;then
    if ! ( mkdir -p $mpi_install  &> /dev/null ); then
        echo "Can't create $mpi_install" 
        exit 1
    fi
fi
if [ -d $mpi_install/mvapich-${mvapich_rev} ]; then
    echo "Previous OSU MPI build was found in $mpi_install. Removing it"
    rm -rf $mpi_install/mvapich-${mvapich_rev}
fi

cd $basedir
printf "\nMVAPICH build envirnoment has been successfully set\n\n"
