%define name oiscsi
%define version 2.6
%define release 16
%define distribution SUSE
%define _build_name_fmt %%{ARCH}/%%{NAME}-%%{VERSION}-%%{RELEASE}-%%{DISTRIBUTION}-%%{ARCH}.rpm

Summary		: open-iscsi patch and modules.
Name		: %{name}
Version		: %{version}
Release		: %{release}
Vendor		: Voltaire Inc.
Source		: oiscsi-iser-2.6.16-rc6.tar.gz
Packager	: Yonatan Cohen <yonic@voltaire.com>
Provides	: open-iscsi
Group		: Storage 
License		: GPL
BuildRoot:      %{_tmppath}/%{name}-%{version}


%description
This package provides open iscsi modules with a patch for iser.

%define kversion $(uname -r)

%prep
rm -rf $RPM_BUILD_ROOT

%setup
case %{kversion} in
        2.6.16-rc6-git1-4-smp) 
                patch -d /lib/modules/%{kversion}/source/ -p1 < iscsi-04-libiscsi.patch
                patch -d /lib/modules/%{kversion}/source/ -p1 < iscsi-05-convert-tcp.patch
                patch -d /lib/modules/%{kversion}/source/ -p1 < iscsi-06-transport-ep-cb.patch
                ;;
        2.6.16.14-6-smp)
                ln -snf /lib/modules/2.6.16.14-6-smp/source/drivers/scsi/libiscsi.h   /lib/modules/2.6.16.14-6-smp/source/include/scsi/libiscsi.h 
                ;; 
        *)
                echo "There is no patch for %{kversion} kernel"
                exit 1
                ;;
esac


%build

if make -C /usr/src/linux SUBDIRS=/lib/modules/%{kversion}/source/drivers/scsi modules CONFIG_ISCSI_TCP=m CONFIG_SCSI_QLA_ISCSI=n; then
        echo " ISCSI drivers builded Ok"
	bail_out=0
else
        echo "Failed building Open ISCSI drivers, cleaning up ..."
	bail_out=1
fi

case %{kversion} in
        2.6.16-rc6-git1-4-smp) 
                patch -d /lib/modules/%{kversion}/source/ -R -p1 < iscsi-06-transport-ep-cb.patch
                patch -d /lib/modules/%{kversion}/source/ -R -p1 < iscsi-05-convert-tcp.patch
                patch -d /lib/modules/%{kversion}/source/ -R -p1 < iscsi-04-libiscsi.patch
                ;;
        2.6.16.14-6-smp)
                ln -snf /lib/modules/2.6.16.14-6-smp/source/drivers/scsi/libiscsi.h   /lib/modules/2.6.16.14-6-smp/source/include/scsi/libiscsi.h 
                ;; 
        *)
                echo "There is no patch for %{kversion} kernel"
                exit 1
                ;;
esac

if [ $bail_out = 1 ] ; then
        echo "Unable to build the updated Open ISCSI drivers"
        exit 1
fi


%install
[ "${RPM_BUILD_ROOT}" != "/" -a -d ${RPM_BUILD_ROOT} ] && rm -rf ${RPM_BUILD_ROOT}

%define MODULE_LIST iscsi_tcp.ko scsi_transport_iscsi.ko libiscsi.ko

2>&1 make -C /usr/src/linux SUBDIRS=/lib/modules/%{kversion}/source/drivers/scsi modules_install INSTALL_MOD_PATH=${RPM_BUILD_ROOT}/tmp |grep INSTALL

for i in %{MODULE_LIST} ; do
        found_file=$(find ${RPM_BUILD_ROOT}/tmp | grep $i)
        if ! [ -z "$found_file" ] ; then
		found_file_dir=$(dirname $found_file)
		found_file_dir=$(echo $found_file_dir|sed "s|${RPM_BUILD_ROOT}/tmp||")
		mkdir -p ${RPM_BUILD_ROOT}$found_file_dir
		install -m755 $found_file ${RPM_BUILD_ROOT}$found_file_dir
        fi
done

rm -rf ${RPM_BUILD_ROOT}/tmp

case %{kversion} in
        2.6.16-rc6-git1-4-smp) 
                install -D -m 755 iscsi-04-libiscsi.patch ${RPM_BUILD_ROOT}/lib/modules/%{kversion}/source/patches/iscsi-04-libiscsi.patch
                install -D -m 755 iscsi-05-convert-tcp.patch ${RPM_BUILD_ROOT}/lib/modules/%{kversion}/source/patches/iscsi-05-convert-tcp.patch
                install -D -m 755 iscsi-06-transport-ep-cb.patch ${RPM_BUILD_ROOT}/lib/modules/%{kversion}/source/patches/iscsi-06-transport-ep-cb.patch
                ;; 
        2.6.16.14-6-smp)
                ln -snf /lib/modules/2.6.16.14-6-smp/source/drivers/scsi/libiscsi.h   /lib/modules/2.6.16.14-6-smp/source/include/scsi/libiscsi.h 
                ;; 
        *)
                echo "There is no patch for %{kversion} kernel"
                exit 1
                ;;
esac


FILE_LIST=%{_tmppath}/oiscsi-file-list

find ${RPM_BUILD_ROOT} -type f| sed "s|${RPM_BUILD_ROOT}||" > ${FILE_LIST}

%clean
[ "${RPM_BUILD_ROOT}" != "/" -a -d ${RPM_BUILD_ROOT} ] && rm -rf ${RPM_BUILD_ROOT}

%pre
if [ ! -z $STACK_PREFIX ] ; then
	backup_dir=$STACK_PREFIX/backup
else
	backup_dir=/usr/local/ofed/backup
fi
KERNEL=$(uname -r)
echo "Backup /lib/modules/$KERNEL"



for i in %{MODULE_LIST} ; do 
        found_file=$(find /lib/modules/$KERNEL | grep $i)
        if ! [ -z "$found_file" ] ; then
		found_file_dir=$(dirname $found_file)
		mkdir -p $backup_dir/$found_file_dir
		mv $found_file $backup_dir/$found_file_dir
        fi
done

%post
echo "Patching kernel..."

case %{kversion} in
        2.6.16-rc6-git1-4-smp) 
                patch -d /lib/modules/%{kversion}/source/ -p1 < /lib/modules/%{kversion}/source/patches/iscsi-04-libiscsi.patch
                patch -d /lib/modules/%{kversion}/source/ -p1 < /lib/modules/%{kversion}/source/patches/iscsi-05-convert-tcp.patch
                patch -d /lib/modules/%{kversion}/source/ -p1 < /lib/modules/%{kversion}/source/patches/iscsi-06-transport-ep-cb.patch
                ;;
        2.6.16.14-6-smp)
                ln -snf /lib/modules/2.6.16.14-6-smp/source/drivers/scsi/libiscsi.h   /lib/modules/2.6.16.14-6-smp/source/include/scsi/libiscsi.h 
                ;; 
        *)
                echo "There is no patch for %{kversion} kernel"
                exit 1
                ;;
esac

depmod -a 
exit 0

%preun
STACK_PREFIX=$(test -x /etc/infiniband/info && /etc/infiniband/info |grep prefix|cut -f2 -d=)
if [ ! -z $STACK_PREFIX ] ; then
	backup_dir=$STACK_PREFIX/backup
else
	backup_dir=/usr/local/ofed/backup
fi
echo "Restoring /lib/modules/$(uname -r)"
for i in %{MODULE_LIST} ; do 
	cd $backup_dir
	found_file=$(find -name $i)
        if ! [ -z "$found_file" ] ; then
		found_file_dir=$(dirname $found_file|cut -f2- -d/)
		cp $found_file /$found_file_dir
        fi
done

echo "Fixing Kernel.."
case %{kversion} in
        2.6.16-rc6-git1-4-smp) 
                patch -d /lib/modules/%{kversion}/source/ -R -p1 < /lib/modules/%{kversion}/source/patches/iscsi-06-transport-ep-cb.patch
                patch -d /lib/modules/%{kversion}/source/ -R -p1 < /lib/modules/%{kversion}/source/patches/iscsi-05-convert-tcp.patch
                patch -d /lib/modules/%{kversion}/source/ -R -p1 < /lib/modules/%{kversion}/source/patches/iscsi-04-libiscsi.patch
                ;;
        2.6.16.14-6-smp)
                ln -snf /lib/modules/2.6.16.14-6-smp/source/drivers/scsi/libiscsi.h   /lib/modules/2.6.16.14-6-smp/source/include/scsi/libiscsi.h 
                ;; 
        *)
                echo "There is no patch for %{kversion} kernel"
                exit 1
                ;;
esac

%files -f %{_tmppath}/oiscsi-file-list

