#
# Copyright (c) 2006 Mellanox Technologies. All rights reserved.
#
# This Software is licensed under one of the following licenses:
#
# 1) under the terms of the "Common Public License 1.0" a copy of which is
#    available from the Open Source Initiative, see
#    http://www.opensource.org/licenses/cpl.php.
#
# 2) under the terms of the "The BSD License" a copy of which is
#    available from the Open Source Initiative, see
#    http://www.opensource.org/licenses/bsd-license.php.
#
# 3) under the terms of the "GNU General Public License (GPL) Version 2" a
#    copy of which is available from the Open Source Initiative, see
#    http://www.opensource.org/licenses/gpl-license.php.
#
# Licensee has the right to choose one of the above licenses.
#
# Redistributions of source code must retain the above copyright
# notice and one of the license notices.
#
# Redistributions in binary form must reproduce both the above copyright
# notice, one of the license notices in the documentation
# and/or other materials provided with the distribution.
#
#
#  $Id: ibutils.spec.in 7656 2006-06-04 09:38:34Z vlad $
#

# Disable debugging
%define debug_package %{nil}
%define __check_files %{nil}

# Disable brp-lib64-linux
%ifarch x86_64 ia64
%define __arch_install_post %{nil}
%endif

%{!?_prefix: %define _prefix /usr/local}

%{!?configure_options: %define configure_options %{nil}}

Summary: OpenIB Mellanox InfiniBand Diagnostic Tools
Name: %{?_name:%{_name}}%{!?_name:ibutils}
Version: 1.0
Release: 0
License: GPL/BSD
Url: http://openib.org/downloads/%{name}-%{version}.tar.gz
Group: System Environment/Libraries
Source: %{name}-%{version}.tar.gz
BuildRoot: %{?build_root:%{build_root}}%{!?build_root:/var/tmp/IBED}
Requires: opensm
Vendor: Mellanox Technologies Ltd.
%description 
ibutils provides IB network and path diagnostics.


%prep
%setup -n -q -n %{name}-%{version}


###
### install
###
%install
%configure %{configure_options}
# W/A for libtool issue: change libdir in all *.la files to point to ${RPM_BUILD_ROOT}/${libdir}
# This W/A should be removed in post install section
LA_FILES=$(find ${RPM_BUILD_ROOT}/%{_prefix} -type f -name '*.la')
for la_file in ${LA_FILES}
do
    case ${la_file##*/} in
        libibumad.la|libosmcomp.la|libopensm.la|libosmvendor.la)
        perl -ni -e "s@(libdir=).*@\$1'${RPM_BUILD_ROOT}%{_libdir}'@; print" ${la_file}
        perl -ni -e "s@ %{_libdir}@\ ${RPM_BUILD_ROOT}%{_libdir}@g; print" ${la_file}
        ;;
    esac
done

%{__make} %{?mflags}
%{__make} install DESTDIR=$RPM_BUILD_ROOT %{?mflags_install}
	
install -d $RPM_BUILD_ROOT/etc/profile.d
cat > $RPM_BUILD_ROOT/etc/profile.d/ibutils.sh << EOF
if ! echo \${PATH} | grep -q %{_prefix}/bin ; then
        PATH=\${PATH}:%{_prefix}/bin
fi
EOF
cat > $RPM_BUILD_ROOT/etc/profile.d/ibutils.csh << EOF
if ( "\${path}" !~ *%{_prefix}/bin* ) then
        set path = ( \$path %{_prefix}/bin )
endif
EOF

install -d $RPM_BUILD_ROOT/etc/ld.so.conf.d
echo "%{_libdir}" >> $RPM_BUILD_ROOT/etc/ld.so.conf.d/ibutils.conf

%clean
#Remove installed driver after rpm build finished
# Leave $RPM_BUILD_ROOT in order to build dependent packages
rm -rf $RPM_BUILD_DIR/%{name}-%{version}

###
### pre section
###
%pre
###
### post section
###
%post
if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
    /sbin/ldconfig
fi
###
### preun section
###
%preun
# if [ $1 = 0 ]; then  # 1 : Erase, not upgrade
# fi
 
###
### post uninstall section
###
%postun
#if [ $1 = 0 ]; then  # 1 : Erase, not upgrade
#    echo
#fi

###
### Files
###
%files
%defattr(-,root,root)
%{_prefix}/bin/ibis
%{_prefix}/bin/ibdmsh
%{_prefix}/bin/ibtopodiff
%{_prefix}/bin/ibnlparse
%{_prefix}/bin/ibdmtr
%{_prefix}/bin/ibdmchk
%{_prefix}/bin/ibdiagnet
%{_prefix}/bin/ibdiagpath
%{_prefix}/bin/mkSimNodeDir
%{_prefix}/bin/ibmssh
%{_prefix}/bin/ibmsquit
%{_prefix}/bin/RunSimTest
%{_prefix}/bin/IBMgtSim
%{_libdir}/libibdmcom.so*
# %{_libdir}/ibibdmcom.a
%{_libdir}/libibdm.so*
%{_libdir}/libibdm.a
%{_libdir}/libibmscli.so*
%{_libdir}/libibmscli.a
%{_libdir}/ibis1.0
%{_libdir}/ibdm1.0
%{_libdir}/ibdiagnet1.0
%{_libdir}/ibdiagpath1.0
%{_prefix}/include/ibdm
%{_prefix}/include/ibmgtsim
%{_mandir}/man1/ibdiagnet.1*
%{_mandir}/man1/ibdiagpath.1*
/etc/profile.d/ibutils.sh
/etc/profile.d/ibutils.csh
/etc/ld.so.conf.d/ibutils.conf
# END Files

%changelog
* Tue May 16 2006 Vladimir Sokolovsky <vlad@mellanox.co.il>
- Added ibutils sh, csh and conf to update environment
* Sun Apr  2 2006 Vladimir Sokolovsky <vlad@mellanox.co.il>
- Initial packaging for openib gen2 stack
