/*
 * Copyright (c) 2004, 2005 Voltaire, Inc. All rights reserved.
 * Copyright (c) 2002-2005 Mellanox Technologies LTD. All rights reserved.
 * Copyright (c) 1996-2003 Intel Corporation. All rights reserved.
 *
 * This software is available to you under a choice of one of two
 * licenses.  You may choose to be licensed under the terms of the GNU
 * General Public License (GPL) Version 2, available from the file
 * COPYING in the main directory of this source tree, or the
 * OpenIB.org BSD license below:
 *
 *     Redistribution and use in source and binary forms, with or
 *     without modification, are permitted provided that the following
 *     conditions are met:
 *
 *      - Redistributions of source code must retain the above
 *        copyright notice, this list of conditions and the following
 *        disclaimer.
 *
 *      - Redistributions in binary form must reproduce the above
 *        copyright notice, this list of conditions and the following
 *        disclaimer in the documentation and/or other materials
 *        provided with the distribution.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 * $Id: osm_ucast_updn.h 1743 2005-02-06 09:38:35Z shaharf $
 */


#ifndef _OSM_UCAST_UPDN_H_
#define _OSM_UCAST_UPDN_H_


/*
 * Abstract:
 * 	Implementation of Up Down Algorithm using ranking & Min Hop 
 *      Calculation functions
 *
 * Environment:
 * 	Linux User Mode
 *
 * $Revision: 1.0 $
 */
/* LS : This code is useless since we integrate it with opensm */
/*
#include <opensm/osm_opensm.h>
#include <opensm/osm_node.h>
#include <complib/cl_list.h>
#include <opensm/osm_subnet.h>
#include <osmsh/osmsh_ext_ifc.h> 
#include <opensm/osm_ucast_mgr.h>
*/

#ifdef __cplusplus
#  define BEGIN_C_DECLS extern "C" {
#  define END_C_DECLS   }
#else /* !__cplusplus */
#  define BEGIN_C_DECLS
#  define END_C_DECLS
#endif /* __cplusplus */

BEGIN_C_DECLS

/* //////////////////////////// */
/*  ENUM TypeDefs */
/* /////////////////////////// */

/*
* DESCRIPTION
*       This enum respresent available directions of arcs in the graph
* SYNOPSIS
*/
typedef enum _updn_switch_dir
  {
    UP = 0,
    DOWN

  } updn_switch_dir_t;

/*
 * TYPE DEFINITIONS
 *    UP 
 *      Current switch direction in propogating the subnet is up
 *    DOWN 
 *      Current switch direction in propogating the subnet is down
 *
 */


/*
* DESCRIPTION
*       This enum respresent available states in the UPDN algorithm
* SYNOPSIS
*/
typedef enum _updn_state
  {
    UPDN_INIT = 0,
    UPDN_RANK,
    UPDN_MIN_HOP_CALC,
  } updn_state_t;

/*
 * TYPE DEFINITIONS
 * UPDN_INIT - loading the package but still not performing anything
 * UPDN_RANK - post ranking algorithm
 * UPDN_MIN_HOP_CALC - post min hop table calculation
 */


/* ////////////////////////////////// */
/*  Struct TypeDefs */
/* ///////////////////////////////// */

/****s* UPDN: Rank element/updn_rank_t
* NAME
*	updn_rank_t
*
* DESCRIPTION
*	This object represents a rank type element in a list
*
*	The updn_rank_t object should be treated as opaque and should
*	be manipulated only through the provided functions.
*
* SYNOPSIS
*/

typedef struct _updn_rank
{
  cl_map_item_t map_item;
  uint8_t rank;
} updn_rank_t;

/*
* FIELDS
*	map_item
*		Linkage structure for cl_qmap.  MUST BE FIRST MEMBER!
*
*	rank
*		Rank value of this node
*
*/

/****s* UPDN: Histogram element/updn_hist_t
* NAME
*	updn_hist_t
*
* DESCRIPTION
*	This object represents a histogram type element in a list
*
*	The updn_hist_t object should be treated as opaque and should
*	be manipulated only through the provided functions.
*
* SYNOPSIS
*/

typedef struct _updn_hist
{
  cl_map_item_t map_item;
  uint32_t bar_value;
} updn_hist_t;

/*
* FIELDS
*	map_item
*		Linkage structure for cl_qmap.  MUST BE FIRST MEMBER!
*
*	bar_value
*		The number of occurences of the same hop value 
*
*/

typedef struct _updn_next_step
{
  updn_switch_dir_t state;
  osm_switch_t *p_sw;
} updn_next_step_t;

/*****s* updn: updn/updn_input_t
* NAME  updn_t
*       
*
* DESCRIPTION
*       updn input fields structure.
*
* SYNOPSIS
*/

typedef struct _updn_input
{
  uint32_t num_guids;
  uint64_t * guid_list;
} updn_input_t;

/*
* FIELDS
*       num_guids
*            number of guids given at the UI
*
*       guid_list
*            guids specified as an array (converted from a list given in the UI) 
*
*
* SEE ALSO
*      
*********/


/*****s* updn: updn/updn_t
* NAME  updn_t
*       
*
* DESCRIPTION
*       updn structure.
*
* SYNOPSIS
*/

typedef struct _updn
{
  updn_state_t   state;
  boolean_t      auto_detect_root_nodes;
  cl_qmap_t      guid_rank_tbl;
  updn_input_t   updn_ucast_reg_inputs;
  cl_list_t *    p_root_nodes;
} updn_t;

/*
* FIELDS
*       state
*            state of the updn algorithm which basically should pass through Init 
*            - Ranking - UpDn algorithm
*
*       guid_rank_tbl
*            guid 2 rank mapping vector , indexed by guid in network order
*
*
* SEE ALSO
*      
*********/


/* ////////////////////////////// */
/*  Function  */
/* ////////////////////////////// */

/***f** Osmsh: Updn/updn_construct
* NAME
*       updn_construct
*
* DESCRIPTION
*      Allocation of updn_t struct
*
* SYNOPSIS
*/

updn_t*
updn_construct(void);

/*
* PARAMETERS
*
*
* RETURN VALUE
*       Return a pointer to an updn struct. Null if fails to do so.
*
* NOTES
*       First step of the creation of updn_t
*/

/****s* Osmsh: Updn/updn_destroy
* NAME
*       updn_destroy
*
* DESCRIPTION
*      release of updn_t struct
*
* SYNOPSIS
*/

void
updn_destroy(
  IN updn_t* const p_updn );

/*
* PARAMETERS
*       p_updn
*               A pointer to the updn_t struct that is goining to be released
*
* RETURN VALUE
*      
* NOTES
*       Final step of the releasing of updn_t
*
* SEE ALSO
*       updn_construct
*********/

/****f* Osmsh: Updn/updn_init
* NAME
*       updn_init
*
* DESCRIPTION
*      Initialization of an updn_t struct
*
* SYNOPSIS
*/
cl_status_t
updn_init(
  IN updn_t* const p_updn );

/*
* PARAMETERS
*       p_updn
*               A pointer to the updn_t struct that is goining to be initilized
*
* RETURN VALUE
*       The status of the function.
*      
* NOTES
*       
* SEE ALSO
*       updn_construct
********/




/****** Osmsh: Updn/updn_subn_rank
* NAME
*	updn_subn_rank
*
* DESCRIPTION
*	This function ranks the subnet for credit loop free algorithm
*
* SYNOPSIS
*/

int
updn_subn_rank(
	      IN uint64_t  root_guid ,
	      IN uint8_t base_rank,
	      IN updn_t* p_updn);

/*
* PARAMETERS
*	p_subn
*		[in] Pointer to a Subnet object to construct.
*
*       base_rank
*		[in] The base ranking value (lowest value)
*
*	p_updn
*		[in] Pointer to updn structure which includes state & lid2rank table
*
* RETURN VALUE
*	This function returns 0 when rankning has succeded , otherwise 1.
******/


/****** Osmsh: UpDown/osm_subn_set_up_down_min_hop_table
* NAME
*	osm_subn_set_up_down_min_hop_table
*
* DESCRIPTION
*	This function set min hop table of all switches by BFS through each
*       port guid at the subnet using ranking done before.
*
* SYNOPSIS
*/

int
osm_subn_set_up_down_min_hop_table(
	      IN updn_t* p_updn);

/*
* PARAMETERS
*	p_updn
*		[in] Pointer to updn structure which includes state & lid2rank table
*
* RETURN VALUE
*	This function returns 0 when rankning has succeded , otherwise 1.
******/




/****** Osmsh: UpDown/osm_subn_calc_up_down_min_hop_table
* NAME
*	osm_subn_calc_up_down_min_hop_table
*
* DESCRIPTION
*	This function perform ranking and setting of all switches' min hop table
*        by UP DOWN algorithm
*
* SYNOPSIS
*/

int
osm_subn_calc_up_down_min_hop_table(
  IN uint32_t num_guids,
  IN uint64_t* guid_list,
  IN updn_t* p_updn);

/*
* PARAMETERS
*
*	guid_list
*		[in] Guid list from which to start ranking .
*
*	p_updn
*		[in] Pointer to updn structure which includes state & lid2rank table
* RETURN VALUE
*	This function returns 0 when rankning has succeded , otherwise 1.
******/

/****f* OpenSM: OpenSM/osm_updn_reg_calc_min_hop_table
* NAME
*	osm_updn_reg_calc_min_hop_table 
*
* DESCRIPTION
*       Registration function to ucast routing manager (instead of 
*       Min Hop Algorithm) 
*
* SYNOPSIS
*/
int
osm_updn_reg_calc_min_hop_table(
  IN updn_t * p_updn,
  IN osm_subn_opt_t* p_opt );
/*
* PARAMETERS
*
* RETURN VALUES
*	0 - on success , 1 - on failure
*
* NOTES
*
* SEE ALSO
* osm_subn_calc_up_down_min_hop_table
*********/

/****** Osmsh: UpDown/osm_updn_find_root_nodes_by_min_hop
* NAME
*	osm_updn_find_root_nodes_by_min_hop
*
* DESCRIPTION
*	This function perform auto identification of root nodes for UPDN ranking phase
*
* SYNOPSIS
*/
int
osm_updn_find_root_nodes_by_min_hop( OUT updn_t *  p_updn );

/*
* PARAMETERS
*	p_root_nodes_list
*       
*		[out] Pointer to the root nodes list found in the subnet
*
* RETURN VALUE
*	This function returns 0 when auto identification had succeeded
******/


END_C_DECLS

#endif /* _OSM_UCAST_UPDN_H_ */
