/*
 * Copyright (c) 2004, 2005 Voltaire, Inc. All rights reserved.
 * Copyright (c) 2002-2005 Mellanox Technologies LTD. All rights reserved.
 * Copyright (c) 1996-2003 Intel Corporation. All rights reserved.
 *
 * This software is available to you under a choice of one of two
 * licenses.  You may choose to be licensed under the terms of the GNU
 * General Public License (GPL) Version 2, available from the file
 * COPYING in the main directory of this source tree, or the
 * OpenIB.org BSD license below:
 *
 *     Redistribution and use in source and binary forms, with or
 *     without modification, are permitted provided that the following
 *     conditions are met:
 *
 *      - Redistributions of source code must retain the above
 *        copyright notice, this list of conditions and the following
 *        disclaimer.
 *
 *      - Redistributions in binary form must reproduce the above
 *        copyright notice, this list of conditions and the following
 *        disclaimer in the documentation and/or other materials
 *        provided with the distribution.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 * $Id: osm_slvl_map_rcv_ctrl.h 2757 2005-06-30 11:42:37Z halr $
 */


/*
 * Abstract:
 * 	Declaration of osm_pi_rcv_ctrl_t.
 *	This object represents a controller that receives the IBA NodeInfo
 *	attribute from a node.
 *	This object is part of the OpenSM family of objects.
 *
 * Environment:
 * 	Linux User Mode
 *
 * $Revision: 1.3 $
 */


#ifndef _OSM_SLVL_RCV_CTRL_H_
#define _OSM_SLVL_RCV_CTRL_H_


#include <complib/cl_dispatcher.h>
#include <opensm/osm_base.h>
#include <opensm/osm_madw.h>
#include <opensm/osm_log.h>
#include <opensm/osm_slvl_map_rcv.h>

#ifdef __cplusplus
#  define BEGIN_C_DECLS extern "C" {
#  define END_C_DECLS   }
#else /* !__cplusplus */
#  define BEGIN_C_DECLS
#  define END_C_DECLS
#endif /* __cplusplus */

BEGIN_C_DECLS

/****h* OpenSM/SltoVL Map Table Receive Controller
* NAME
*	Slvl Map Receive Controller
*
* DESCRIPTION
*	The Slvl Map Receive Controller object encapsulates
*	the information needed to get or set SLtoVL Map of a port.
*
*	The Slvl Map Receive Controller object is thread safe.
*
*	This object should be treated as opaque and should be
*	manipulated only through the provided functions.
*
* AUTHOR
*	Eitan Zahavi, Mellanox
*
*********/
/****s* OpenSM: Slvl Map Receive Controller/osm_slvl_rcv_ctrl_t
* NAME
*	osm_slvl_rcv_ctrl_t
*
* DESCRIPTION
*	Slvl Map Receive Controller structure.
*
*	This object should be treated as opaque and should
*	be manipulated only through the provided functions.
*
* SYNOPSIS
*/
typedef struct _osm_slvl_rcv_ctrl
{
	osm_slvl_rcv_t				*p_rcv;
	osm_log_t					*p_log;
	cl_dispatcher_t			*p_disp;
	cl_disp_reg_handle_t		h_disp;

} osm_slvl_rcv_ctrl_t;
/*
* FIELDS
*	p_rcv
*		Pointer to the Slvl Map Receiver object.
*
*	p_log
*		Pointer to the log object.
*
*	p_disp
*		Pointer to the Dispatcher.
*
*	h_disp
*		Handle returned from dispatcher registration.
*
* SEE ALSO
*	Slvl Map Receive Controller object
*	Slvl Map Receiver object
*********/

/****f* OpenSM: Slvl Map Receive Controller/osm_slvl_rcv_ctrl_construct
* NAME
*	osm_slvl_rcv_ctrl_construct
*
* DESCRIPTION
*	This function constructs a Slvl Map Receive Controller object.
*
* SYNOPSIS
*/
void osm_slvl_rcv_ctrl_construct(
	IN osm_slvl_rcv_ctrl_t* const p_ctrl );
/*
* PARAMETERS
*	p_ctrl
*		[in] Pointer to a Slvl Map Receive Controller
*		object to construct.
*
* RETURN VALUE
*	This function does not return a value.
*
* NOTES
*	Allows calling osm_slvl_rcv_ctrl_init, osm_slvl_rcv_ctrl_destroy,
*	and osm_slvl_rcv_ctrl_is_inited.
*
*	Calling osm_slvl_rcv_ctrl_construct is a prerequisite to calling any other
*	method except osm_slvl_rcv_ctrl_init.
*
* SEE ALSO
*	Slvl Map Receive Controller object, osm_slvl_rcv_ctrl_init,
*	osm_slvl_rcv_ctrl_destroy, osm_slvl_rcv_ctrl_is_inited
*********/

/****f* OpenSM: Slvl Map Receive Controller/osm_slvl_rcv_ctrl_destroy
* NAME
*	osm_slvl_rcv_ctrl_destroy
*
* DESCRIPTION
*	The osm_slvl_rcv_ctrl_destroy function destroys the object, releasing
*	all resources.
*
* SYNOPSIS
*/
void osm_slvl_rcv_ctrl_destroy(
	IN osm_slvl_rcv_ctrl_t* const p_ctrl );
/*
* PARAMETERS
*	p_ctrl
*		[in] Pointer to the object to destroy.
*
* RETURN VALUE
*	This function does not return a value.
*
* NOTES
*	Performs any necessary cleanup of the specified
*	Slvl Map Receive Controller object.
*	Further operations should not be attempted on the destroyed object.
*	This function should only be called after a call to
*	osm_slvl_rcv_ctrl_construct or osm_slvl_rcv_ctrl_init.
*
* SEE ALSO
*	Slvl Map Receive Controller object, osm_slvl_rcv_ctrl_construct,
*	osm_slvl_rcv_ctrl_init
*********/

/****f* OpenSM: Slvl Map Receive Controller/osm_slvl_rcv_ctrl_init
* NAME
*	osm_slvl_rcv_ctrl_init
*
* DESCRIPTION
*	The osm_slvl_rcv_ctrl_init function initializes a
*	Slvl Map Receive Controller object for use.
*
* SYNOPSIS
*/
ib_api_status_t osm_slvl_rcv_ctrl_init(
	IN osm_slvl_rcv_ctrl_t* const p_ctrl,
	IN osm_slvl_rcv_t* const p_rcv,
	IN osm_log_t* const p_log,
	IN cl_dispatcher_t* const p_disp );
/*
* PARAMETERS
*	p_ctrl
*		[in] Pointer to an osm_slvl_rcv_ctrl_t object to initialize.
*
*	p_rcv
*		[in] Pointer to an osm_slvl_rcv_t object.
*
*	p_log
*		[in] Pointer to the log object.
*
*	p_disp
*		[in] Pointer to the OpenSM central Dispatcher.
*
* RETURN VALUES
*	CL_SUCCESS if the Slvl Map Receive Controller object was initialized
*	successfully.
*
* NOTES
*	Allows calling other Slvl Map Receive Controller methods.
*
* SEE ALSO
*	Slvl Map Receive Controller object, osm_slvl_rcv_ctrl_construct,
*	osm_slvl_rcv_ctrl_destroy, osm_slvl_rcv_ctrl_is_inited
*********/

/****f* OpenSM: Slvl Map Receive Controller/osm_slvl_rcv_ctrl_is_inited
* NAME
*	osm_slvl_rcv_ctrl_is_inited
*
* DESCRIPTION
*	Indicates if the object has been initialized with osm_slvl_rcv_ctrl_init.
*
* SYNOPSIS
*/
boolean_t osm_slvl_rcv_ctrl_is_inited(
	IN const osm_slvl_rcv_ctrl_t* const p_ctrl );
/*
* PARAMETERS
*	p_ctrl
*		[in] Pointer to an osm_slvl_rcv_ctrl_t object.
*
* RETURN VALUES
*	TRUE if the object was initialized successfully,
*	FALSE otherwise.
*
* NOTES
*	The osm_slvl_rcv_ctrl_construct or osm_slvl_rcv_ctrl_init must be
*	called before using	this function.
*
* SEE ALSO
*	Slvl Map Receive Controller object, osm_slvl_rcv_ctrl_construct,
*	osm_slvl_rcv_ctrl_init
*********/

END_C_DECLS

#endif	/* _OSM_SLVL_RCV_CTRL_H_ */
