/*
 * Copyright (c) 2004, 2005 Voltaire, Inc. All rights reserved.
 * Copyright (c) 2002-2005 Mellanox Technologies LTD. All rights reserved.
 * Copyright (c) 1996-2003 Intel Corporation. All rights reserved.
 *
 * This software is available to you under a choice of one of two
 * licenses.  You may choose to be licensed under the terms of the GNU
 * General Public License (GPL) Version 2, available from the file
 * COPYING in the main directory of this source tree, or the
 * OpenIB.org BSD license below:
 *
 *     Redistribution and use in source and binary forms, with or
 *     without modification, are permitted provided that the following
 *     conditions are met:
 *
 *      - Redistributions of source code must retain the above
 *        copyright notice, this list of conditions and the following
 *        disclaimer.
 *
 *      - Redistributions in binary form must reproduce the above
 *        copyright notice, this list of conditions and the following
 *        disclaimer in the documentation and/or other materials
 *        provided with the distribution.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 * $Id: cl_types_osd.h 1743 2005-02-06 09:38:35Z shaharf $
 */



/*
 * Abstract:
 *	Defines sized datatypes for Linux Kernel and User mode
 *  exported sizes are int8_t, uint8_t, int16_t, uint16_t, int32_t, uint32_t
 *  int64_t, uint64_t. uintn_t is a polymorphic type, size is native size and
 *  also size of the pointer.
 *
 * Environment:
 *	Linux User and Kernel Mode
 *
 * $Revision: 1.7 $
 */


#ifndef _CL_TYPES_OSD_H_
#define _CL_TYPES_OSD_H_

#ifdef __cplusplus
#  define BEGIN_C_DECLS extern "C" {
#  define END_C_DECLS   }
#else /* !__cplusplus */
#  define BEGIN_C_DECLS
#  define END_C_DECLS
#endif /* __cplusplus */

BEGIN_C_DECLS

#if defined (_DEBUG_)
#ifdef __IA64__
#define cl_break() asm("   break 0")
#else	/* __IA64__ */
#define cl_break() asm("   int $3")
#endif	/* __IA64__ */
#else	/* _DEBUG_ */
#define cl_break
#endif

#ifdef __KERNEL__
#include <linux/config.h>

/*
 * Linux Kernel Mode
 */

#if defined (_DEBUG_) && defined (CONFIG_X86_REMOTE_DEBUG)
#define CONFIG_GDB
#endif

#if defined(CONFIG_MODVERSIONS) && !defined(MODVERSIONS)
#define MODVERSIONS		/* turn it on */
#endif

#ifdef MODVERSIONS
#include <linux/modversions.h>
#endif

#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/types.h>
#include <linux/string.h>
#include <linux/init.h>

#ifndef LINUX_VERSION_CODE
#include <linux/version.h>
#endif

#if defined (_DEBUG_)

#if defined (CONFIG_GDB)
extern int gdb_initialized;

#define CL_ASSERT( __exp__ )										\
{																\
	if( !(__exp__) )											\
	{															\
		if (!gdb_initialized)									\
		{														\
			panic( "Assertion failed: %s, file %s, line %d\n",	\
					#__exp__, __FILE__, __LINE__ );				\
		}														\
		else													\
		{														\
			printk( "Assertion failed: %s, file %s, line %d\n",	\
					#__exp__, __FILE__, __LINE__ );				\
			printk ("Entering GDB...\n");						\
			cl_break();											\
		}														\
	}															\
}
#elif defined (CONFIG_KDB) /* not CONFIG_GDB */
#include <linux/kdb.h>
#undef cl_break
#define cl_break()	KDB_ENTER()

#define CL_ASSERT( __exp__ )										\
{																\
	if( !(__exp__) )											\
	{															\
			printk( "Assertion failed: %s, file %s, line %d\n",	\
					#__exp__, __FILE__, __LINE__ );				\
			printk ("Entering KDB...\n");						\
			cl_break();											\
	}															\
}
#else /* not CONFIG_GDB and not CONFIG_KDB */
#undef cl_break
#define cl_break()

#define CL_ASSERT( __exp__ )									\
{															\
	if( !(__exp__) )										\
	{														\
		panic( "Assertion failed: %s, file %s, line %d\n",	\
				#__exp__, __FILE__, __LINE__ );				\
	}														\
}
#endif /* CONFIG_GDB */

#else /* not _DEBUG_ */
#undef cl_break
#define cl_break()
#define CL_ASSERT( __exp__ )
#endif	/* _DEBUG_ */

#define cl_panic	panic

#else	/* __KERNEL__ */

/*
 * Linux User Mode
 */
#include <inttypes.h>
#include <assert.h>
#include <string.h>


#if defined (_DEBUG_)
#define CL_ASSERT	assert
#else	/* _DEBUG_ */
#define CL_ASSERT( __exp__ )
#endif	/* _DEBUG_ */

#endif /* __KERNEL__ */

/*
 * Types not explicitly defined are native to the platform.
 */
typedef unsigned long		uintn_t;
typedef long				intn_t;
typedef int					boolean_t;
typedef volatile int32_t	atomic32_t;

#ifndef NULL
#define NULL	(void*)0
#endif

#define UNUSED_PARAM( P )

END_C_DECLS

#endif	/* _CL_TYPES_OSD_H_ */
