/*
 * Copyright (c) 2004, 2005 Voltaire, Inc. All rights reserved.
 * Copyright (c) 2002-2005 Mellanox Technologies LTD. All rights reserved.
 * Copyright (c) 1996-2003 Intel Corporation. All rights reserved.
 *
 * This software is available to you under a choice of one of two
 * licenses.  You may choose to be licensed under the terms of the GNU
 * General Public License (GPL) Version 2, available from the file
 * COPYING in the main directory of this source tree, or the
 * OpenIB.org BSD license below:
 *
 *     Redistribution and use in source and binary forms, with or
 *     without modification, are permitted provided that the following
 *     conditions are met:
 *
 *      - Redistributions of source code must retain the above
 *        copyright notice, this list of conditions and the following
 *        disclaimer.
 *
 *      - Redistributions in binary form must reproduce the above
 *        copyright notice, this list of conditions and the following
 *        disclaimer in the documentation and/or other materials
 *        provided with the distribution.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 * $Id: cl_spinlock_osd.h 1743 2005-02-06 09:38:35Z shaharf $
 */



/*
 * Abstract:
 *	Implementation of spin lock object.
 *
 * Environment:
 *	Linux Kernel Mode
 *
 * $Revision: 1.4 $
 */


#ifndef _CL_SPINLOCK_OSD_H_
#define _CL_SPINLOCK_OSD_H_

#ifdef __cplusplus
#  define BEGIN_C_DECLS extern "C" {
#  define END_C_DECLS   }
#else /* !__cplusplus */
#  define BEGIN_C_DECLS
#  define END_C_DECLS
#endif /* __cplusplus */

BEGIN_C_DECLS

#include <complib/cl_types.h>


#ifdef __KERNEL__

/* Linux Kernel Mode. */
#include <linux/spinlock.h>
#include <asm/system.h>
#include <asm/atomic.h>

typedef enum
{
	SPIN_LVL_INVALID,
	SPIN_LVL_TASKLET,
	SPIN_LVL_INTERRUPT
} cl_spin_level_t;

/*
 * Spinlock object definition.
 */
typedef struct _cl_spinlock_t
{
	spinlock_t			lock;
	unsigned long		flags;
	cl_state_t			state;
	cl_spin_level_t		level;
#ifdef _DEBUG_
	boolean_t			locked;
	struct task_struct	*owner;
	int					cpuid;
#endif

} cl_spinlock_t;

#else	/* __KERNEL__ */

/* Linux User Mode. */
#include <pthread.h>			/* usr/include/ */

typedef struct _cl_spinlock_t
{
	pthread_mutex_t		mutex;
	cl_state_t			state;

} cl_spinlock_t;

#endif	/* __KERNEL__ */

END_C_DECLS

#endif /* _CL_SPINLOCK_OSD_H_ */
