/*
 * Copyright (c) 2004, 2005 Voltaire, Inc. All rights reserved.
 * Copyright (c) 2002-2005 Mellanox Technologies LTD. All rights reserved.
 * Copyright (c) 1996-2003 Intel Corporation. All rights reserved.
 *
 * This software is available to you under a choice of one of two
 * licenses.  You may choose to be licensed under the terms of the GNU
 * General Public License (GPL) Version 2, available from the file
 * COPYING in the main directory of this source tree, or the
 * OpenIB.org BSD license below:
 *
 *     Redistribution and use in source and binary forms, with or
 *     without modification, are permitted provided that the following
 *     conditions are met:
 *
 *      - Redistributions of source code must retain the above
 *        copyright notice, this list of conditions and the following
 *        disclaimer.
 *
 *      - Redistributions in binary form must reproduce the above
 *        copyright notice, this list of conditions and the following
 *        disclaimer in the documentation and/or other materials
 *        provided with the distribution.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 * $Id: cl_thread_osd.h 1743 2005-02-06 09:38:35Z shaharf $
 */



/*
 * Abstract:
 *	Declaration of thread abstraction and thread related operations.
 *
 * Environment:
 *	Linux Kernel Mode
 *
 * $Revision: 1.4 $
 */


#ifndef _CL_THREAD_OSD_H_
#define _CL_THREAD_OSD_H_

#ifdef __cplusplus
#  define BEGIN_C_DECLS extern "C" {
#  define END_C_DECLS   }
#else /* !__cplusplus */
#  define BEGIN_C_DECLS
#  define END_C_DECLS
#endif /* __cplusplus */

BEGIN_C_DECLS

#include <complib/cl_types.h>
#include <complib/cl_event.h>

#ifdef __KERNEL__

/* Linux Kernel Mode. */
#include <linux/sched.h>
#include <linux/interrupt.h>

/* bit position 0 for thread wait flag */
#define THREAD_WAKEUP		(0)

/* Milli Secs per tick, since there are  HZ ticks per second */
#define MISECS_PER_TICK		(1000/HZ)

/* Linux kernel mode thread object structure definition. */
typedef struct _cl_thread_osd_t
{
	char				name[16];
	wait_queue_head_t	wqueue;
	struct task_struct	*task;

	cl_event_t			kill_event;
	cl_state_t			state;

} cl_thread_osd_t;


static inline boolean_t
cl_is_blockable ( void )
{
	return ( (in_interrupt()) ? FALSE : TRUE );
}

#else	/* __KERNEL__ */

/* Linux User Mode. */
#include <pthread.h>

/* Linux user mode thread object structure definition. */
typedef struct _cl_thread_osd_t
{
	pthread_t			id;
	cl_state_t			state;

} cl_thread_osd_t;

static inline boolean_t
cl_is_blockable ( void )
{
	return TRUE;
}

#endif	/* __KERNEL__ */

END_C_DECLS

#endif	/* _CL_THREAD_OSD_H_ */
