/*
 * Copyright (c) 2004, 2005 Voltaire, Inc. All rights reserved.
 * Copyright (c) 2002-2005 Mellanox Technologies LTD. All rights reserved.
 * Copyright (c) 1996-2003 Intel Corporation. All rights reserved.
 *
 * This software is available to you under a choice of one of two
 * licenses.  You may choose to be licensed under the terms of the GNU
 * General Public License (GPL) Version 2, available from the file
 * COPYING in the main directory of this source tree, or the
 * OpenIB.org BSD license below:
 *
 *     Redistribution and use in source and binary forms, with or
 *     without modification, are permitted provided that the following
 *     conditions are met:
 *
 *      - Redistributions of source code must retain the above
 *        copyright notice, this list of conditions and the following
 *        disclaimer.
 *
 *      - Redistributions in binary form must reproduce the above
 *        copyright notice, this list of conditions and the following
 *        disclaimer in the documentation and/or other materials
 *        provided with the distribution.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 * $Id: cl_syshelper.h 1743 2005-02-06 09:38:35Z shaharf $
 */



/*
 * Abstract:
 *	This header file defines data structures and APIs for the system helper
 *	module of the component library.
 *
 * Environment:
 *	Linux Kernel and User Mode.
 *
 * $Revision: 1.7 $
 */


#ifndef _CL_SYSHELPER_H_
#define _CL_SYSHELPER_H_

/****h* Component Library/System Helper
* NAME
*	System Helper
*
* DESCRIPTION
*	Provides ioctl support and handle validation for wait objects.
*
********/

#ifdef	__KERNEL__

#include <linux/ioctl.h>
#include <linux/mm.h>

#endif	//__KERNEL__

#include <complib/cl_types.h>
#include <complib/cl_list.h>
#include <complib/cl_qlist.h>
#include <complib/cl_event.h>
#include <complib/cl_qmap.h>
#include <complib/cl_passivelock.h>
#include <complib/cl_spinlock.h>

#ifdef __cplusplus
#  define BEGIN_C_DECLS extern "C" {
#  define END_C_DECLS   }
#else /* !__cplusplus */
#  define BEGIN_C_DECLS
#  define END_C_DECLS
#endif /* __cplusplus */

BEGIN_C_DECLS

#define SYSHELP_DEVICE_NAME	"/dev/cl_dev"
#define	SYSDEV_KEY	'#'

#ifdef	__KERNEL__

/****f* Component Library: System Helper/__cl_syshelper_init
* NAME
*	__cl_syshelper_init
*
* DESCRIPTION
*	Initializes the system helper data structures and prepares it
*	for use.
*
* SYNOPSIS
*/
cl_status_t
__cl_syshelper_init(void);

/*
* PARAMETERS
*	None.
*
* RETURN VALUES
*	CL_SUCCESS
*		The initialization completed successfully.
*	CL_ERROR
*		Could not create the device.
*
* NOTES
*
* SEE ALSO
*	__cl_syshelper_exit
********/

/****f* Component Library: System Helper/__cl_syshelper_exit
* NAME
*	__cl_syshelper_exit
*
* DESCRIPTION
*	Releases the resources used by syshelper and destroys the device.
*
* SYNOPSIS
*/
void
__cl_syshelper_exit(void);

/*
* PARAMETERS
*	None
*
* RETURN VALUES
*	None.
*
* NOTES
*
* SEE ALSO
*	__cl_syshelper_init
*********/

#else		// __KERNEL__

/*
 * User mode only
 */

/****f* Component Library: System Helper/__cl_user_syshelper_init
* NAME
*	__cl_user_syshelper_init
*
* DESCRIPTION
*	Initialize the system helper in user mode.
*
* SYNOPSIS
*/
cl_status_t
__cl_user_syshelper_init(void);
/*
* PARAMETERS
*	None.
*
* RETURN VALUES
*	CL_SUCCESS
*		The initialization completed successfully.
*
* NOTES
*
* SEE ALSO
*****/

/****f* Component Library: System Helper/__cl_user_syshelper_exit
* NAME
*	__cl_user_syshelper_exit
*
* DESCRIPTION
*	Cleanup the system helper in user mode.
*
* SYNOPSIS
*/
void
__cl_user_syshelper_exit(void);
/*
* PARAMETERS
*	None.
*
* RETURN VALUES
*	None.
*
* NOTES
*
* SEE ALSO
******/

#endif		// __KERNEL__

/*
 * Shared between user and kernel mode.
 */

/****d* Component Library: System Helper/cl_syshelper_ops_t
* NAME
*	syshelper_ops_t
*
* DESCRIPTION
*
* SYNOPSIS
*/
typedef enum cl_syshelper_ops
{
	create_wait_obj = 1,
	waiton_wait_obj,
	trigger_wait_obj,
	reset_wait_obj,
	syshelp_ioctl_max		/* always at the end of the list */

} cl_syshelper_ops_t;
/**********/

/*
 * Various Opration Allowable on the System Helper
 */
#define	CREATE_WAIT_OBJ		\
					IOCTL_CMD(SYSDEV_KEY, create_wait_obj)
#define	WAITON_WAIT_OBJ		\
					IOCTL_CMD(SYSDEV_KEY, waiton_wait_obj)
#define	TRIGGER_WAIT_OBJ	\
					IOCTL_CMD(SYSDEV_KEY, trigger_wait_obj)
#define	RESET_WAIT_OBJ		\
					IOCTL_CMD(SYSDEV_KEY, reset_wait_obj)
END_C_DECLS

#endif	//_CL_SYSHELPER_H_
