/*
 * Copyright (c) 2004, 2005 Voltaire, Inc. All rights reserved.
 * Copyright (c) 2002-2005 Mellanox Technologies LTD. All rights reserved.
 * Copyright (c) 1996-2003 Intel Corporation. All rights reserved.
 *
 * This software is available to you under a choice of one of two
 * licenses.  You may choose to be licensed under the terms of the GNU
 * General Public License (GPL) Version 2, available from the file
 * COPYING in the main directory of this source tree, or the
 * OpenIB.org BSD license below:
 *
 *     Redistribution and use in source and binary forms, with or
 *     without modification, are permitted provided that the following
 *     conditions are met:
 *
 *      - Redistributions of source code must retain the above
 *        copyright notice, this list of conditions and the following
 *        disclaimer.
 *
 *      - Redistributions in binary form must reproduce the above
 *        copyright notice, this list of conditions and the following
 *        disclaimer in the documentation and/or other materials
 *        provided with the distribution.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 * $Id: cl_signal_osd.h 4924 2006-01-11 14:12:01Z halr $
 */

/*
 * Abstract:
 *	Declaration of Signal Handler Registration
 *
 * Environment:
 *	All
 *
 * $Revision: 1.3 $
 */

#ifndef _CL_SIG_HDL_H_
#define _CL_SIG_HDL_H_

#include <signal.h>

#ifdef __cplusplus
#  define BEGIN_C_DECLS extern "C" {
#  define END_C_DECLS   }
#else /* !__cplusplus */
#  define BEGIN_C_DECLS
#  define END_C_DECLS
#endif /* __cplusplus */

BEGIN_C_DECLS

/****h* Component Library/Signal Handler
* NAME
*   Signal Handler Registration
*
* DESCRIPTION
*	The Signal Handler Registration allows to register a callback on the case of incoming signal
*
* SEE ALSO
*********/

typedef void (*cl_sig_hdl)(
   IN int sig);

/* Prototypes */

/****f* Component Library: Signal Handler/cl_reg_sig_hdl
* NAME
*	cl_reg_sig_hdl
*
* DESCRIPTION
*	Register the handler for the given signal
*
* SYNOPSIS
*/

static inline void 
cl_reg_sig_hdl(int sig, cl_sig_hdl pfn_sig_hdl);

/****f* Component Library: Signal Handler/cl_mask_sigint
* NAME
*	cl_sig_mask_sigint
*
* DESCRIPTION
*	Mask the kill signal
*
* SYNOPSIS
*/

static inline void 
cl_sig_mask_sigint(void);

/****f* Component Library: Signal Handler/cl_reg_sig_hdl
* NAME
*	cl_reg_sig_hdl
*
* DESCRIPTION
*	Register the handler for the given signal
*
* SYNOPSIS
*/
static inline void 
cl_reg_sig_hdl(int sig, cl_sig_hdl pfn_sig_hdl) {
 #ifdef __WIN__
	signal(sig,pfn_sig_hdl);
 #else	
	struct sigaction sigact;
	sigact.sa_handler = pfn_sig_hdl;
	sigemptyset(&sigact.sa_mask);
	sigaddset(&sigact.sa_mask, sig);
	sigact.sa_flags = 0;
	sigaction(sig, &sigact, NULL);
 #endif
}
/*
*********/

/****f* Component Library: Signal Handler/cl_mask_sigint
* NAME
*	cl_sig_mask_sigint
*
* DESCRIPTION
*	Mask the kill signal
*
* SYNOPSIS
*/
static inline void 
cl_sig_mask_sigint(void)
{
 #ifdef __WIN__
  /* we do not mask kill */
 #else	
 #ifndef OSM_VENDOR_INTF_OPENIB 
   sigset_t sigs;
      
   sigemptyset(&sigs);
   sigaddset(&sigs, SIGINT);
   pthread_sigmask(SIG_BLOCK, &sigs, NULL);
 #endif /* OSM_VENDOR_INTF_OPENIB */
 #endif /* __WIN__ */
}
/*
*********/

END_C_DECLS

#endif /* _CL_SIG_HDL_H_ */
