/*
 * Copyright (c) 2004, 2005 Voltaire, Inc. All rights reserved.
 * Copyright (c) 2002-2005 Mellanox Technologies LTD. All rights reserved.
 * Copyright (c) 1996-2003 Intel Corporation. All rights reserved.
 *
 * This software is available to you under a choice of one of two
 * licenses.  You may choose to be licensed under the terms of the GNU
 * General Public License (GPL) Version 2, available from the file
 * COPYING in the main directory of this source tree, or the
 * OpenIB.org BSD license below:
 *
 *     Redistribution and use in source and binary forms, with or
 *     without modification, are permitted provided that the following
 *     conditions are met:
 *
 *      - Redistributions of source code must retain the above
 *        copyright notice, this list of conditions and the following
 *        disclaimer.
 *
 *      - Redistributions in binary form must reproduce the above
 *        copyright notice, this list of conditions and the following
 *        disclaimer in the documentation and/or other materials
 *        provided with the distribution.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 * $Id: cl_debug_osd.h 1743 2005-02-06 09:38:35Z shaharf $
 */



/*
 * Abstract:
 *	Debug Macros.
 *
 * Environment:
 *	Linux Kernel Mode
 *
 * $Revision: 1.7 $
 */


#ifndef _CL_DEBUG_OSD_H_
#define _CL_DEBUG_OSD_H_


#include <complib/cl_types.h>
#include <bits/wordsize.h>

#ifdef __cplusplus
#  define BEGIN_C_DECLS extern "C" {
#  define END_C_DECLS   }
#else /* !__cplusplus */
#  define BEGIN_C_DECLS
#  define END_C_DECLS
#endif /* __cplusplus */

BEGIN_C_DECLS

#if !defined(__MODULE__)
#define __MODULE__			""
#define __MOD_DELIMITER__	""
#else	/* !defined(__MODULE__) */
#define __MOD_DELIMITER__	":"
#endif	/* !defined(__MODULE__) */

/*
 * Define specifiers for print functions based on the platform
 */
#ifdef __IA64__
#define PRIdSIZE_T	"ld"
#else
#define PRIdSIZE_T	"d"
#endif 

#ifdef __KERNEL__

#include <linux/sched.h>
#include <linux/smp.h>
#include <linux/interrupt.h>


/* Linux Kernel Mode */
#if __WORDSIZE == 64
#define __PRI64_PREFIX	"l"
#else
#define __PRI64_PREFIX	"L"
#endif


#define PRId64		__PRI64_PREFIX"d"
#define PRIo64		__PRI64_PREFIX"o"
#define PRIu64		__PRI64_PREFIX"u"
#define PRIx64		__PRI64_PREFIX"x"

void cl_printk( char *message, ... );	/* see cl_debug.c */


#ifndef	PRINTK_LVL
#define PRINTK_LVL KERN_INFO
#endif

#if defined (_DEBUG_)

#if defined (CONFIG_GDB)
#define cl_msg_out		printk
#define cl_dbg_out		printk
#else
#define cl_msg_out	cl_printk
#define cl_dbg_out	cl_printk
#endif

#else /* not _DEBUG_ */
#define cl_msg_out		cl_printk
#define cl_dbg_out		foo
#endif	/* _DEBUG_ */


/*
 * The following macros are used internally by the CL_ENTER, CL_TRACE,
 * CL_TRACE_EXIT, and CL_EXIT macros.
 */

#if defined (CONFIG_SMP)

#define _CL_DBG_ENTER	\
	("~%d:%s%s%s() [\n", smp_processor_id(), __MODULE__, \
	__MOD_DELIMITER__, __func__)

#define _CL_DBG_EXIT	\
	("~%d:%s%s%s() ]\n", smp_processor_id(), __MODULE__, \
	__MOD_DELIMITER__, __func__)

#define _CL_DBG_INFO	\
	("~%d:%s%s%s(): ", smp_processor_id(), __MODULE__, \
	__MOD_DELIMITER__, __func__)

#define _CL_DBG_ERROR	\
	("~%d:%s%s%s() !ERROR!: ", smp_processor_id(), __MODULE__, \
	__MOD_DELIMITER__, __func__)

#else

#define _CL_DBG_ENTER	\
	("%s%s%s() [\n", __MODULE__, __MOD_DELIMITER__, __func__)

#define _CL_DBG_EXIT	\
	("%s%s%s() ]\n", __MODULE__, __MOD_DELIMITER__, __func__)

#define _CL_DBG_INFO	\
	("%s%s%s(): ", __MODULE__, __MOD_DELIMITER__, __func__)

#define _CL_DBG_ERROR	\
	("%s%s%s() !ERROR!: ", __MODULE__, __MOD_DELIMITER__, __func__)

#endif

#ifdef CONFIG_X86
#define CL_CHK_STK												\
{																\
	uint32_t __CL_ESP__;										\
	__asm__ __volatile__("movl %%esp,%0" : "=r" (__CL_ESP__));	\
	if (((uint32_t)current + sizeof(struct task_struct) +		\
		(in_interrupt() ? 300: 1024)) > __CL_ESP__)				\
	{															\
		cl_msg_out("stack corruption detected!!!\n");			\
		cl_msg_out("::::::::esp(0x%x) top(0x%x)::::::::\n",__CL_ESP__,\
			((uint32_t)current + sizeof(struct task_struct) +	\
			(in_interrupt() ? 300: 1024)));						\
		CL_ASSERT (0);											\
	}															\
}
#else
#define CL_CHK_STK	/* We do not do checks for 64 for now... */
#endif


#else	/* __KERNEL__ */

/* Linux User Mode */
#include <inttypes.h>
#include <stdio.h>

#define cl_msg_out	printf

#if defined( _DEBUG_ )
#define cl_dbg_out	printf
#else
#define cl_dbg_out	foo
#endif	/* _DEBUG_ */


/*
 * The following macros are used internally by the CL_ENTER, CL_TRACE,
 * CL_TRACE_EXIT, and CL_EXIT macros.
 */
#define _CL_DBG_ENTER	\
	("%s%s%s() [\n", __MODULE__, __MOD_DELIMITER__, __func__)

#define _CL_DBG_EXIT	\
	("%s%s%s() ]\n", __MODULE__, __MOD_DELIMITER__, __func__)

#define _CL_DBG_INFO	\
	("%s%s%s(): ", __MODULE__, __MOD_DELIMITER__, __func__)

#define _CL_DBG_ERROR	\
	("%s%s%s() !ERROR!: ", __MODULE__, __MOD_DELIMITER__, __func__)

#define CL_CHK_STK

#endif	/* __KERNEL__ */

END_C_DECLS

#endif	/* _CL_DEBUG_OSD_H_ */
