/* A Bison parser, made by GNU Bison 1.875.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Using locations.  */
#define YYLSP_NEEDED 0



/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     USE = 258,
     CLIENT = 259,
     SERVER = 260,
     TCP = 261,
     SDP = 262,
     BOTH = 263,
     INT = 264,
     LOG = 265,
     DEST = 266,
     STDERR = 267,
     SYSLOG = 268,
     FILENAME = 269,
     NAME = 270,
     LEVEL = 271,
     LINE = 272
   };
#endif
#define USE 258
#define CLIENT 259
#define SERVER 260
#define TCP 261
#define SDP 262
#define BOTH 263
#define INT 264
#define LOG 265
#define DEST 266
#define STDERR 267
#define SYSLOG 268
#define FILENAME 269
#define NAME 270
#define LEVEL 271
#define LINE 272




/* Copy the first part of user declarations.  */
#line 39 "/home/eitan/SW/SVN/gen2_libsdp/libsdp/src/config_parser.y"


#define	yymaxdepth libsdp_maxdepth
#define	yyparse	libsdp_parse
#define	yylex	libsdp_lex
#define	yyerror	libsdp_error
#define	yylval	libsdp_lval
#define	yychar	libsdp_char
#define	yydebug	libsdp_debug
#define	yypact	libsdp_pact
#define	yyr1	libsdp_r1
#define	yyr2	libsdp_r2
#define	yydef	libsdp_def
#define	yychk	libsdp_chk
#define	yypgo	libsdp_pgo
#define	yyact	libsdp_act
#define	yyexca	libsdp_exca
#define  yyerrflag libsdp_errflag
#define  yynerrs	libsdp_nerrs
#define	yyps	libsdp_ps
#define	yypv	libsdp_pv
#define	yys	libsdp_s
#define	yy_yys	libsdp_yys
#define	yystate	libsdp_state
#define	yytmp	libsdp_tmp
#define	yyv	libsdp_v
#define	yy_yyv	libsdp_yyv
#define	yyval	libsdp_val
#define	yylloc	libsdp_lloc
#define yyreds	libsdp_reds
#define yytoks	libsdp_toks
#define yylhs	libsdp_yylhs
#define yylen	libsdp_yylen
#define yydefred libsdp_yydefred
#define yydgoto	libsdp_yydgoto
#define yysindex libsdp_yysindex
#define yyrindex libsdp_yyrindex
#define yygindex libsdp_yygindex
#define yytable	 libsdp_yytable
#define yycheck	 libsdp_yycheck
#define yyname   libsdp_yyname
#define yyrule   libsdp_yyrule

/* header section */
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "libsdp.h"
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#define YYERROR_VERBOSE 1

extern int yyerror(char *msg);
extern int yylex(void);
static int parse_err = 0;

struct use_family_rule *__sdp_clients_family_rules_head = NULL;
struct use_family_rule *__sdp_clients_family_rules_tail = NULL;
struct use_family_rule *__sdp_servers_family_rules_head = NULL;
struct use_family_rule *__sdp_servers_family_rules_tail = NULL;

/* some globals to store intermidiate parser state */
static struct use_family_rule __sdp_rule;
static int current_role = 0;

int __sdp_config_empty(
                       void
                       )
{
  return ( (__sdp_clients_family_rules_head == NULL) &&
           (__sdp_servers_family_rules_head == NULL) );
}

/* define the address by 4 integers */
static void __sdp_set_ipv4_addr(short a0, short a1, short a2, short a3)
{
  char buf[16];
  sprintf(buf,"%d.%d.%d.%d", a0, a1, a2, a3);
  if (!inet_aton(buf, &( __sdp_rule.ipv4 )))
  {
    parse_err = 1;
    yyerror("provided address is not legal");
  }
}

static void __sdp_set_prog_name_expr(char *prog_name_expr)
{
  __sdp_rule.prog_name_expr = strdup(prog_name_expr);
  if (!__sdp_rule.prog_name_expr) {
    yyerror("fail to allocate program name expression");    
  }
}

static char *__sdp_get_role_str(int role)
{
  if (role == 1) return("server");
  if (role == 2) return("client");
  return("unknown role");
}

extern int __sdp_min_level;

/* dump the current state in readable format */
static void  __sdp_dump_config_state() {
  char buf[1024];
  sprintf(buf, "CONIFG: use %s %s %s", 
          __sdp_get_family_str(__sdp_rule.target_family), 
          __sdp_get_role_str( current_role ),
          __sdp_rule.prog_name_expr);
  if (__sdp_rule.match_by_addr) {
    if ( __sdp_rule.prefixlen != 32 )
      sprintf(buf+strlen(buf), " %s/%d", 
              inet_ntoa( __sdp_rule.ipv4 ), __sdp_rule.prefixlen);
    else
      sprintf(buf+strlen(buf), " %s", inet_ntoa( __sdp_rule.ipv4 ));
  } else {
    sprintf(buf+strlen(buf), " *");
  }
  if (__sdp_rule.match_by_port) {
    sprintf(buf+strlen(buf), ":%d",__sdp_rule.sport);
    if (__sdp_rule.eport > __sdp_rule.sport) 
      sprintf(buf+strlen(buf), "-%d",__sdp_rule.eport);
  }
  else
    sprintf(buf+strlen(buf), ":*");
  sprintf(buf+strlen(buf), "\n");
  __sdp_log(1, buf);
}

/* use the above state for making a new rule */
static void __sdp_add_rule() {
  struct use_family_rule **p_tail, **p_head, *rule;

  if (__sdp_min_level <= 1) __sdp_dump_config_state();
  if ( current_role == 1 ) {
    p_tail = &__sdp_servers_family_rules_tail;
    p_head = &__sdp_servers_family_rules_head;
  } else if ( current_role == 2 ) {
    p_tail = &__sdp_clients_family_rules_tail;
    p_head = &__sdp_clients_family_rules_head;
  } else {
    yyerror("ignoring unknown role");
    parse_err = 1;
    return;
  }

  rule = (struct use_family_rule *)malloc(sizeof(*rule));
  if (!rule) {
    yyerror("fail to allocate new rule");
    parse_err = 1;
    return;
  }

  memset(rule, 0, sizeof(*rule));
  *rule = __sdp_rule;
  rule->prev = *p_tail;
  if (!(*p_head)) {
    *p_head = rule;
  } else {
    (*p_tail)->next = rule;
  } /* if */
  *p_tail = rule;
}



/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 1
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 1
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 208 "/home/eitan/SW/SVN/gen2_libsdp/libsdp/src/config_parser.y"
typedef union YYSTYPE {
  int        ival;
  char      *sval;
} YYSTYPE;
/* Line 191 of yacc.c.  */
#line 282 "y.tab.c"
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */
#line 233 "/home/eitan/SW/SVN/gen2_libsdp/libsdp/src/config_parser.y"

  long __sdp_config_line_num;


/* Line 214 of yacc.c.  */
#line 297 "y.tab.c"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# if YYSTACK_USE_ALLOCA
#  define YYSTACK_ALLOC alloca
# else
#  ifndef YYSTACK_USE_ALLOCA
#   if defined (alloca) || defined (_ALLOCA_H)
#    define YYSTACK_ALLOC alloca
#   else
#    ifdef __GNUC__
#     define YYSTACK_ALLOC __builtin_alloca
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC malloc
#  define YYSTACK_FREE free
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE))				\
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  7
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   36

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  23
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  17
/* YYNRULES -- Number of rules. */
#define YYNRULES  33
/* YYNRULES -- Number of states. */
#define YYNSTATES  53

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   272

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned char yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,    19,     2,     2,    22,    21,    20,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,    18,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned char yyprhs[] =
{
       0,     0,     3,     5,     8,     9,    11,    14,    15,    18,
      20,    22,    26,    27,    30,    33,    36,    39,    43,    46,
      55,    57,    59,    61,    63,    65,    67,    69,    71,    75,
      77,    85,    87,    91
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const yysigned_char yyrhs[] =
{
      26,     0,    -1,    17,    -1,    24,    17,    -1,    -1,    24,
      -1,    25,    27,    -1,    -1,    27,    28,    -1,    29,    -1,
      33,    -1,    10,    30,    24,    -1,    -1,    30,    31,    -1,
      30,    32,    -1,    11,    12,    -1,    11,    13,    -1,    11,
      14,    15,    -1,    16,     9,    -1,     3,    34,    35,    36,
      37,    18,    39,    24,    -1,     6,    -1,     7,    -1,     8,
      -1,     5,    -1,     4,    -1,    15,    -1,    19,    -1,    38,
      -1,    38,    20,     9,    -1,    19,    -1,     9,    21,     9,
      21,     9,    21,     9,    -1,     9,    -1,     9,    22,     9,
      -1,    19,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short yyrline[] =
{
       0,   239,   239,   240,   242,   243,   246,   249,   250,   254,
     255,   259,   262,   263,   264,   268,   269,   270,   274,   278,
     282,   283,   284,   288,   289,   293,   294,   298,   299,   300,
     304,   308,   309,   310
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "\"use\"", "\"client or connect\"", 
  "\"server or listen\"", "\"tcp\"", "\"sdp\"", "\"both\"", 
  "\"integer value\"", "\"log statement\"", "\"destination\"", 
  "\"stderr\"", "\"syslog\"", "\"file\"", "\"a name\"", "\"min-level\"", 
  "\"new line\"", "':'", "'*'", "'/'", "'.'", "'-'", "$accept", "NL", 
  "ONL", "config", "statements", "statement", "log_statement", "log_opts", 
  "log_dest", "verbosity", "socket_statement", "family", "role", 
  "program", "address", "ipv4", "ports", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,    58,    42,
      47,    46,    45
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned char yyr1[] =
{
       0,    23,    24,    24,    25,    25,    26,    27,    27,    28,
      28,    29,    30,    30,    30,    31,    31,    31,    32,    33,
      34,    34,    34,    35,    35,    36,    36,    37,    37,    37,
      38,    39,    39,    39
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     1,     2,     0,     1,     2,     0,     2,     1,
       1,     3,     0,     2,     2,     2,     2,     3,     2,     8,
       1,     1,     1,     1,     1,     1,     1,     1,     3,     1,
       7,     1,     3,     1
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned char yydefact[] =
{
       4,     2,     5,     7,     0,     3,     6,     1,     0,    12,
       8,     9,    10,    20,    21,    22,     0,     0,    24,    23,
       0,     0,     0,    11,    13,    14,    25,    26,     0,    15,
      16,     0,    18,     0,    29,     0,    27,    17,     0,     0,
       0,     0,    31,    33,     0,    28,     0,     0,    19,     0,
      32,     0,    30
};

/* YYDEFGOTO[NTERM-NUM]. */
static const yysigned_char yydefgoto[] =
{
      -1,     2,     3,     4,     6,    10,    11,    17,    24,    25,
      12,    16,    20,    28,    35,    36,    44
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -18
static const yysigned_char yypact[] =
{
     -13,   -18,     4,   -18,    22,   -18,     0,   -18,     9,   -18,
     -18,   -18,   -18,   -18,   -18,   -18,     2,    -3,   -18,   -18,
     -10,     6,    14,     4,   -18,   -18,   -18,   -18,    -8,   -18,
     -18,    10,   -18,     3,   -18,     8,    11,   -18,    19,    -7,
      20,    12,    13,   -18,   -13,   -18,    21,    23,     4,    15,
     -18,    25,   -18
};

/* YYPGOTO[NTERM-NUM].  */
static const yysigned_char yypgoto[] =
{
     -18,   -17,   -18,   -18,   -18,   -18,   -18,   -18,   -18,   -18,
     -18,   -18,   -18,   -18,   -18,   -18,   -18
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -1
static const unsigned char yytable[] =
{
      23,    33,    42,     8,     1,    26,    18,    19,    21,    27,
       9,    34,    43,    22,     1,    13,    14,    15,    29,    30,
      31,     5,     7,    32,    38,    37,    39,    48,    41,    45,
      49,    40,    50,    46,    52,    47,    51
};

static const unsigned char yycheck[] =
{
      17,     9,     9,     3,    17,    15,     4,     5,    11,    19,
      10,    19,    19,    16,    17,     6,     7,     8,    12,    13,
      14,    17,     0,     9,    21,    15,    18,    44,     9,     9,
       9,    20,     9,    21,     9,    22,    21
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const unsigned char yystos[] =
{
       0,    17,    24,    25,    26,    17,    27,     0,     3,    10,
      28,    29,    33,     6,     7,     8,    34,    30,     4,     5,
      35,    11,    16,    24,    31,    32,    15,    19,    36,    12,
      13,    14,     9,     9,    19,    37,    38,    15,    21,    18,
      20,     9,     9,    19,    39,     9,    21,    22,    24,     9,
       9,    21,     9
};

#if ! defined (YYSIZE_T) && defined (__SIZE_TYPE__)
# define YYSIZE_T __SIZE_TYPE__
#endif
#if ! defined (YYSIZE_T) && defined (size_t)
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T)
# if defined (__STDC__) || defined (__cplusplus)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# endif
#endif
#if ! defined (YYSIZE_T)
# define YYSIZE_T unsigned int
#endif

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrlab1

/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { 								\
      yyerror ("syntax error: cannot back up");\
      YYERROR;							\
    }								\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

/* YYLLOC_DEFAULT -- Compute the default location (before the actions
   are run).  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)         \
  Current.first_line   = Rhs[1].first_line;      \
  Current.first_column = Rhs[1].first_column;    \
  Current.last_line    = Rhs[N].last_line;       \
  Current.last_column  = Rhs[N].last_column;
#endif

/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (YYLEX_PARAM)
#else
# define YYLEX yylex ()
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (0)

# define YYDSYMPRINT(Args)			\
do {						\
  if (yydebug)					\
    yysymprint Args;				\
} while (0)

# define YYDSYMPRINTF(Title, Token, Value, Location)		\
do {								\
  if (yydebug)							\
    {								\
      YYFPRINTF (stderr, "%s ", Title);				\
      yysymprint (stderr, 					\
                  Token, Value);	\
      YYFPRINTF (stderr, "\n");					\
    }								\
} while (0)

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (cinluded).                                                   |
`------------------------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_stack_print (short *bottom, short *top)
#else
static void
yy_stack_print (bottom, top)
    short *bottom;
    short *top;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (/* Nothing. */; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_reduce_print (int yyrule)
#else
static void
yy_reduce_print (yyrule)
    int yyrule;
#endif
{
  int yyi;
  unsigned int yylineno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %u), ",
             yyrule - 1, yylineno);
  /* Print the symbols being reduced, and their result.  */
  for (yyi = yyprhs[yyrule]; 0 <= yyrhs[yyi]; yyi++)
    YYFPRINTF (stderr, "%s ", yytname [yyrhs[yyi]]);
  YYFPRINTF (stderr, "-> %s\n", yytname [yyr1[yyrule]]);
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (Rule);		\
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YYDSYMPRINT(Args)
# define YYDSYMPRINTF(Title, Token, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   SIZE_MAX < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#if YYMAXDEPTH == 0
# undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined (__GLIBC__) && defined (_STRING_H)
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
#   if defined (__STDC__) || defined (__cplusplus)
yystrlen (const char *yystr)
#   else
yystrlen (yystr)
     const char *yystr;
#   endif
{
  register const char *yys = yystr;

  while (*yys++ != '\0')
    continue;

  return yys - yystr - 1;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined (__GLIBC__) && defined (_STRING_H) && defined (_GNU_SOURCE)
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
#   if defined (__STDC__) || defined (__cplusplus)
yystpcpy (char *yydest, const char *yysrc)
#   else
yystpcpy (yydest, yysrc)
     char *yydest;
     const char *yysrc;
#   endif
{
  register char *yyd = yydest;
  register const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

#endif /* !YYERROR_VERBOSE */



#if YYDEBUG
/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yysymprint (FILE *yyoutput, int yytype, YYSTYPE *yyvaluep)
#else
static void
yysymprint (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  if (yytype < YYNTOKENS)
    {
      YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
# ifdef YYPRINT
      YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
    }
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  switch (yytype)
    {
      default:
        break;
    }
  YYFPRINTF (yyoutput, ")");
}

#endif /* ! YYDEBUG */
/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yydestruct (int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yytype, yyvaluep)
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  switch (yytype)
    {

      default:
        break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM);
# else
int yyparse ();
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */



/* The lookahead symbol.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;



/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM)
# else
int yyparse (YYPARSE_PARAM)
  void *YYPARSE_PARAM;
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{
  
  register int yystate;
  register int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken = 0;

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  short	yyssa[YYINITDEPTH];
  short *yyss = yyssa;
  register short *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  register YYSTYPE *yyvsp;



#define YYPOPSTACK   (yyvsp--, yyssp--)

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;


  /* When reducing, the number of symbols on the RHS of the reduced
     rule.  */
  int yylen;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed. so pushing a state here evens the stacks.
     */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack. Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	short *yyss1 = yyss;


	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow ("parser stack overflow",
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),

		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyoverflowlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyoverflowlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	short *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyoverflowlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);

#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;


      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YYDSYMPRINTF ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */
  YYDPRINTF ((stderr, "Shifting token %s, ", yytname[yytoken]));

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;


  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  yystate = yyn;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 15:
#line 268 "/home/eitan/SW/SVN/gen2_libsdp/libsdp/src/config_parser.y"
    { __sdp_log_set_log_stderr(); }
    break;

  case 16:
#line 269 "/home/eitan/SW/SVN/gen2_libsdp/libsdp/src/config_parser.y"
    { __sdp_log_set_log_syslog(); }
    break;

  case 17:
#line 270 "/home/eitan/SW/SVN/gen2_libsdp/libsdp/src/config_parser.y"
    { __sdp_log_set_log_file(yyvsp[0].sval); }
    break;

  case 18:
#line 274 "/home/eitan/SW/SVN/gen2_libsdp/libsdp/src/config_parser.y"
    { __sdp_log_set_min_level(yyvsp[0].ival); }
    break;

  case 19:
#line 278 "/home/eitan/SW/SVN/gen2_libsdp/libsdp/src/config_parser.y"
    { __sdp_add_rule(); }
    break;

  case 20:
#line 282 "/home/eitan/SW/SVN/gen2_libsdp/libsdp/src/config_parser.y"
    { __sdp_rule.target_family = USE_TCP; }
    break;

  case 21:
#line 283 "/home/eitan/SW/SVN/gen2_libsdp/libsdp/src/config_parser.y"
    { __sdp_rule.target_family = USE_SDP; }
    break;

  case 22:
#line 284 "/home/eitan/SW/SVN/gen2_libsdp/libsdp/src/config_parser.y"
    { __sdp_rule.target_family = USE_BOTH; }
    break;

  case 23:
#line 288 "/home/eitan/SW/SVN/gen2_libsdp/libsdp/src/config_parser.y"
    { current_role = 1; }
    break;

  case 24:
#line 289 "/home/eitan/SW/SVN/gen2_libsdp/libsdp/src/config_parser.y"
    { current_role = 2; }
    break;

  case 25:
#line 293 "/home/eitan/SW/SVN/gen2_libsdp/libsdp/src/config_parser.y"
    { __sdp_set_prog_name_expr(yyvsp[0].sval); }
    break;

  case 26:
#line 294 "/home/eitan/SW/SVN/gen2_libsdp/libsdp/src/config_parser.y"
    { __sdp_set_prog_name_expr("*"); }
    break;

  case 27:
#line 298 "/home/eitan/SW/SVN/gen2_libsdp/libsdp/src/config_parser.y"
    { __sdp_rule.match_by_addr = 1; __sdp_rule.prefixlen = 32; }
    break;

  case 28:
#line 299 "/home/eitan/SW/SVN/gen2_libsdp/libsdp/src/config_parser.y"
    { __sdp_rule.match_by_addr = 1; __sdp_rule.prefixlen = yyvsp[0].ival; }
    break;

  case 29:
#line 300 "/home/eitan/SW/SVN/gen2_libsdp/libsdp/src/config_parser.y"
    { __sdp_rule.match_by_addr = 0; __sdp_rule.prefixlen = 32; }
    break;

  case 30:
#line 304 "/home/eitan/SW/SVN/gen2_libsdp/libsdp/src/config_parser.y"
    { __sdp_set_ipv4_addr(yyvsp[-6].ival,yyvsp[-4].ival,yyvsp[-2].ival,yyvsp[0].ival); }
    break;

  case 31:
#line 308 "/home/eitan/SW/SVN/gen2_libsdp/libsdp/src/config_parser.y"
    { __sdp_rule.match_by_port = 1; __sdp_rule.sport= yyvsp[0].ival; __sdp_rule.eport= yyvsp[0].ival; }
    break;

  case 32:
#line 309 "/home/eitan/SW/SVN/gen2_libsdp/libsdp/src/config_parser.y"
    { __sdp_rule.match_by_port = 1; __sdp_rule.sport= yyvsp[-2].ival; __sdp_rule.eport= yyvsp[0].ival; }
    break;

  case 33:
#line 310 "/home/eitan/SW/SVN/gen2_libsdp/libsdp/src/config_parser.y"
    { __sdp_rule.match_by_port = 0; __sdp_rule.sport= 0 ; __sdp_rule.eport= 0; }
    break;


    }

/* Line 991 of yacc.c.  */
#line 1306 "y.tab.c"

  yyvsp -= yylen;
  yyssp -= yylen;


  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;


  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (YYPACT_NINF < yyn && yyn < YYLAST)
	{
	  YYSIZE_T yysize = 0;
	  int yytype = YYTRANSLATE (yychar);
	  char *yymsg;
	  int yyx, yycount;

	  yycount = 0;
	  /* Start YYX at -YYN if negative to avoid negative indexes in
	     YYCHECK.  */
	  for (yyx = yyn < 0 ? -yyn : 0;
	       yyx < (int) (sizeof (yytname) / sizeof (char *)); yyx++)
	    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
	      yysize += yystrlen (yytname[yyx]) + 15, yycount++;
	  yysize += yystrlen ("syntax error, unexpected ") + 1;
	  yysize += yystrlen (yytname[yytype]);
	  yymsg = (char *) YYSTACK_ALLOC (yysize);
	  if (yymsg != 0)
	    {
	      char *yyp = yystpcpy (yymsg, "syntax error, unexpected ");
	      yyp = yystpcpy (yyp, yytname[yytype]);

	      if (yycount < 5)
		{
		  yycount = 0;
		  for (yyx = yyn < 0 ? -yyn : 0;
		       yyx < (int) (sizeof (yytname) / sizeof (char *));
		       yyx++)
		    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
		      {
			const char *yyq = ! yycount ? ", expecting " : " or ";
			yyp = yystpcpy (yyp, yyq);
			yyp = yystpcpy (yyp, yytname[yyx]);
			yycount++;
		      }
		}
	      yyerror (yymsg);
	      YYSTACK_FREE (yymsg);
	    }
	  else
	    yyerror ("syntax error; also virtual memory exhausted");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror ("syntax error");
    }



  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
	 error, discard it.  */

      /* Return failure if at end of input.  */
      if (yychar == YYEOF)
        {
	  /* Pop the error token.  */
          YYPOPSTACK;
	  /* Pop the rest of the stack.  */
	  while (yyss < yyssp)
	    {
	      YYDSYMPRINTF ("Error: popping", yystos[*yyssp], yyvsp, yylsp);
	      yydestruct (yystos[*yyssp], yyvsp);
	      YYPOPSTACK;
	    }
	  YYABORT;
        }

      YYDSYMPRINTF ("Error: discarding", yytoken, &yylval, &yylloc);
      yydestruct (yytoken, &yylval);
      yychar = YYEMPTY;

    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab2;


/*----------------------------------------------------.
| yyerrlab1 -- error raised explicitly by an action.  |
`----------------------------------------------------*/
yyerrlab1:

  /* Suppress GCC warning that yyerrlab1 is unused when no action
     invokes YYERROR.  */
#if defined (__GNUC_MINOR__) && 2093 <= (__GNUC__ * 1000 + __GNUC_MINOR__) \
    && !defined __cplusplus
  __attribute__ ((__unused__))
#endif


  goto yyerrlab2;


/*---------------------------------------------------------------.
| yyerrlab2 -- pop states until the error token can be shifted.  |
`---------------------------------------------------------------*/
yyerrlab2:
  yyerrstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (yyn != YYPACT_NINF)
	{
	  yyn += YYTERROR;
	  if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
	    {
	      yyn = yytable[yyn];
	      if (0 < yyn)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
	YYABORT;

      YYDSYMPRINTF ("Error: popping", yystos[*yyssp], yyvsp, yylsp);
      yydestruct (yystos[yystate], yyvsp);
      yyvsp--;
      yystate = *--yyssp;

      YY_STACK_PRINT (yyss, yyssp);
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  YYDPRINTF ((stderr, "Shifting error token, "));

  *++yyvsp = yylval;


  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#ifndef yyoverflow
/*----------------------------------------------.
| yyoverflowlab -- parser overflow comes here.  |
`----------------------------------------------*/
yyoverflowlab:
  yyerror ("parser stack overflow");
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
  return yyresult;
}


#line 313 "/home/eitan/SW/SVN/gen2_libsdp/libsdp/src/config_parser.y"


int yyerror(char *msg)
{
  __sdp_log(9, "Error (line:%ld) : %s \n", __sdp_config_line_num, msg);
  parse_err = 1;
  return 1;
}

#include <unistd.h>
#include <errno.h>

/* parse apollo route dump file */
int __sdp_parse_config (const char *fileName) {
  extern FILE * yyin;
   
  /* open the file */
  if (access(fileName, R_OK)) {
	 printf("libsdp Error: No access to open File:%s %s\n", 
           fileName, strerror(errno));
	 return(1);
  }

  yyin = fopen(fileName,"r");
  if (!yyin) {
	 printf("libsdp Error: Fail to open File:%s\n", fileName);
	 return(1);
  }
  parse_err = 0;
  __sdp_config_line_num = 1;
  /* parse it */
  yyparse();

  fclose(yyin);
  return(parse_err);
}



