/*
 * Copyright (C) Jan 2006 Mellanox Technologies Ltd. All rights reserved.
 *
 * This software is available to you under a choice of one of two
 * licenses.  You may choose to be licensed under the terms of the GNU
 * General Public License (GPL) Version 2, available from the file
 * COPYING in the main directory of this source tree, or the
 * OpenIB.org BSD license below:
 *
 *     Redistribution and use in source and binary forms, with or
 *     without modification, are permitted provided that the following
 *     conditions are met:
 *
 *      - Redistributions of source code must retain the above
 *        copyright notice, this list of conditions and the following
 *        disclaimer.
 *
 *      - Redistributions in binary form must reproduce the above
 *        copyright notice, this list of conditions and the following
 *        disclaimer in the documentation and/or other materials
 *        provided with the distribution.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 *  Special.cpp - Special structs manipulation class
 *
 *  Version: $Id: Special.cpp 2752 2006-01-19 14:40:17Z mst $
 *
 */
#include <stdio.h>

#include "Special.h"
#include "Param.h"

namespace std {}; using namespace std;

////////////////////////////////////////////////////////////////////////
bool Special::add(Param* par, const u_int32_t geo)
{
    vector<u_int8_t>& d = data[par->tag_id];
    u_int32_t         o = par->tag_offs;
    int               l = 0;

    // Calculate actual data length
    switch (par->repr)
    {
    case Param::ASCII:
        l = (par->slength + 3) & ~0x03;
        break;
    case Param::INT64:
    case Param::UNS64:
        l = sizeof(u_int64_t);
        break;
    case Param::INT:
    case Param::UNS:
    case Param::ENUM:
    case Param::BOOL:
        l = sizeof(u_int32_t);
        break;
    }

    // Prepare place
    if (o+l > d.size())
        d.resize(o+l, 0);

    // Insert new data
    switch (par->repr)
    {
    case Param::ASCII:
    {
        vector<char> strv(l, '\0');
        char* str = &strv[0];
        strncpy(str, par->get(geo).c_str(), l);

#if __BYTE_ORDER ==  __BIG_ENDIAN
        copy(&str[0], &str[l], &d[o]);
#elif __BYTE_ORDER == __LITTLE_ENDIAN
        for (int i=0; i<l; i++)
        {
            unsigned in_dword = 3 - i%4;
            d[(i & ~0x03) + in_dword] = str[i];
        }
#else
#error Wrong enianess
#endif

        break;
    }
    case Param::INT64:
    case Param::UNS64:
    {
        u_int64_t v = par->get64(geo);
        u_int8_t  *pw = (u_int8_t*)&v;

        // Tricky - we need two dwords in CPU order. But
        // order of these dwords in u_int64_t must be BE
        u_int32_t v1 = v >> 32;
        u_int32_t v2 = v & 0xffffffff;
        memcpy(&v, &v1, sizeof(u_int32_t));
        memcpy(((char *)&v)+sizeof(u_int32_t), &v2, sizeof(u_int32_t));

        copy(pw, pw+sizeof(u_int64_t), &d[o]);
        break;
    }
    case Param::INT:
    case Param::UNS:
    case Param::ENUM:
    case Param::BOOL:
    {
        u_int32_t v = par->get32(geo);
        u_int8_t  *pw = (u_int8_t*)&v;
        copy(pw, pw+sizeof(u_int32_t), &d[o]);
        break;
    }
    }
    return true;
} // Special::add
