#include "MicExpr.h"
#include <stdio.h>

namespace std {}; using namespace std;

int MicExpr::ResolveName(char *name, u_int64_t *val)
{
    int rc = 0; // Default - OK

    if (_plist->refparams.find(name) != _plist->refparams.end())
    {
        *val = _plist->refparams[name]->get64();
	if (_plist->refparams[name]->err()) 
	{
	    errmsg(_plist->refparams[name]->err());
	    rc = 1;
	}
    }
    else
        rc = 1;

    return rc;
} // MicExpr::ResolveName

bool MicExpr::eval_all() 
{
    for (list<Group*>::iterator git = _plist->grlist.begin() ; git != _plist->grlist.end() ; ++git)
    {
	for (list<Param*>::iterator pit = (*git)->prlist.begin() ; pit != (*git)->prlist.end() ; ++pit)
	{ 
	    // Expr
	    Param* p = (*pit);

	    if (p->expr != "") {
		u_int64_t val;
		char sval[30];
		const char* e =       p->expr.c_str();

                //
                // If a param is set externaly, skip its expr calculation and take
                // user assignment (feature req 33869)
                //

                if (p->values[Param::GEO_DEF].ext_val) {
                    if (_parser_debug) {
                        printf("-D- Expr: Param %s, expr calculation skipped. Parameter set by user (%s:%d) to value %s\n",
                               p->name.c_str(), 
                               p->values[Param::GEO_DEF].where_f.c_str(),
                               p->values[Param::GEO_DEF].where_l,
                               p->get().c_str());
                    }

                    continue;
                }



		char* nce = const_cast<char*>(e); // disgusting, but that's life - expr() needed pointer to pointer - 
				                  // can't be const, though not changed by expr() func.


		expr(&nce, &val);
		
		if (*nce)
		{
		    return errmsg( "Expression evaluation error: %s\n"
				   "  Expression is: \"%s\"\n"
				   "  Unevaluated part is: \"%s\"",
				   err(),
				   p->expr.c_str(),
				   nce);
		}
		
		if (_parser_debug && (p->get64() != val)) {
		    printf("Expr: Param %s, expr \"%s\" , changed val:\n"
			   "      From: %10"U64L"d\n"
			   "      To  : %10"U64L"d\n", 
			   p->name.c_str(), p->expr.c_str(), p->get64(), val);
		}
		
		// Change the val to string in order to use assign func.
		sprintf(sval, "%"U64L"d" , val);
		if (! p->assign(sval)) {
		    return errmsg(p->err());
		}
	    }
	}
    }
    return true;
}
