/*
 * Copyright (C) Jan 2006 Mellanox Technologies Ltd. All rights reserved.
 *
 * This software is available to you under a choice of one of two
 * licenses.  You may choose to be licensed under the terms of the GNU
 * General Public License (GPL) Version 2, available from the file
 * COPYING in the main directory of this source tree, or the
 * OpenIB.org BSD license below:
 *
 *     Redistribution and use in source and binary forms, with or
 *     without modification, are permitted provided that the following
 *     conditions are met:
 *
 *      - Redistributions of source code must retain the above
 *        copyright notice, this list of conditions and the following
 *        disclaimer.
 *
 *      - Redistributions in binary form must reproduce the above
 *        copyright notice, this list of conditions and the following
 *        disclaimer in the documentation and/or other materials
 *        provided with the distribution.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 *  Attributes.h - Attributes list class definitions
 *
 *  Very small map class, without removing
 *
 *  Version: $Id: Attributes.h 2752 2006-01-19 14:40:17Z mst $
 *
 */

#ifndef ATTRIBUTES_H
#define ATTRIBUTES_H

#include <vector>
#include <algorithm>

template <class K, class D>
class Attributes
{
public:
    enum {npos = -1};
    Attributes() { }

    Attributes& operator=(const  Attributes &old)
    {
        if (this != &old)
        {
            _keys = old._keys;
            _values = old._values;
        }
        return *this;
    }

    int index(const K& key) const
    {
        typedef std::vector<K> vv;
        typename vv::const_iterator it = find(_keys.begin(), _keys.end(), key);
        if (it == _keys.end())
            return npos;
        return it - _keys.begin();
    }
    int  size() const                       { return _values.size();     }
    int  length() const                     { return size();             }
    int  count() const                      { return size();             }
    bool contains(const K& key) const       { return index(key) != npos; }
    K    key(int index) const               { return _keys[index];       }
    D    value(int index) const             { return _values[index];     }
    void set_value(int index, const D& d)   { _values[index] = d;        }
    D&   get(const K& key)                  { return operator[](key);    }
    void insert(const K& key, const D& val) { value(key) = val;          }

    void clear()
    {
        _keys.clear();
        _values.clear();
    }
    D& operator[](const K& key)
    {
        int i = index(key);
        if (i == npos)
        {
            D new_value;
            _push_back(key, new_value);
            return _values[size()-1];
        }
        else
            return _values[i];
    }

private:
    void _push_back(const K& key, const D& value)
    {
        _keys.push_back(key);
        _values.push_back(value);
    }

    std::vector<K> _keys;
    std::vector<D> _values;
};

#endif
