# Copyright (c) 2002-2005, Network Appliance, Inc. All rights reserved.
#
# This Software is licensed under one of the following licenses:
#
# 1) under the terms of the "Common Public License 1.0" a copy of which is
#    in the file LICENSE.txt in the root directory. The license is also
#    available from the Open Source Initiative, see
#    http://www.opensource.org/licenses/cpl.php.
#
# 2) under the terms of the "The BSD License" a copy of which is in the file
#    LICENSE2.txt in the root directory. The license is also available from
#    the Open Source Initiative, see
#    http://www.opensource.org/licenses/bsd-license.php.
#
# 3) under the terms of the "GNU General Public License (GPL) Version 2" a 
#    copy of which is in the file LICENSE3.txt in the root directory. The 
#    license is also available from the Open Source Initiative, see
#    http://www.opensource.org/licenses/gpl-license.php.
#
# Licensee has the right to choose one of the above licenses.
#
# Redistributions of source code must retain the above copyright
# notice and one of the license notices.
#
# Redistributions in binary form must reproduce both the above copyright
# notice, one of the license notices in the documentation
# and/or other materials provided with the distribution.
#
#
# uDAT and uDAPL 1.2 Registry RPM SPEC file
#
# $Id: $

%define ver      1.2.0
%define RELEASE 1.2
%define rel     %{?CUSTOM_RELEASE} %{!?CUSTOM_RELEASE:%RELEASE}

Summary: Userspace DAT and DAPL API.
Name: libdat
Version: %ver
Release: %rel
License: Dual GPL/BSD/CPL
Group: System Environment/Libraries
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
Source: http://openib.org/downloads/%{name}-%{version}.tar.gz
Url: http://openib.org/
BuildRequires: libibverbs-devel librdmacm-devel

%description
Along with the OpenIB kernel drivers, libdat and libdapl provides a userspace
RDMA API that supports DAT 1.2 specification

%package devel
Summary: Development files for the libdat and libdapl libraries
Group: System Environment/Libraries
Requires: %{name} = %{version}-%{release}

%description devel
Static libraries and header files for the libdat and libdapl library.

%prep
%setup -q -n %{name}-%{ver}

%build
%configure
make

%install
make DESTDIR=${RPM_BUILD_ROOT} install
# remove unpackaged files from the buildroot
rm -f $RPM_BUILD_ROOT%{_libdir}/*.la

%clean
rm -rf $RPM_BUILD_ROOT

%post -p /sbin/ldconfig
%postun -p /sbin/ldconfig

%files
%defattr(-,root,root)
%{_libdir}/libda*.so.*
%config(noreplace) %{_sysconfdir}/dat.conf
%doc AUTHORS COPYING README LICENSE*.txt

%files devel
%defattr(-,root,root,-)
%{_libdir}/libda*.so
%{_libdir}/*.a
%{_includedir}/dat/dat.h
%{_includedir}/dat/dat_error.h
%{_includedir}/dat/dat_platform_specific.h
%{_includedir}/dat/dat_redirection.h
%{_includedir}/dat/dat_registry.h
%{_includedir}/dat/dat_vendor_specific.h
%{_includedir}/dat/udat_config.h
%{_includedir}/dat/udat.h
%{_includedir}/dat/udat_redirection.h
%{_includedir}/dat/udat_vendor_specific.h
