# $Id: openib.spec 7904 2006-06-12 08:54:09Z vlad $

%define build_root %(if [ ! -z "${build_root}" ]; then echo -n ${build_root}; else echo -n "/var/tmp/OFED"; fi)
%define STACK_PREFIX %(if [ ! -z "${STACK_PREFIX}" ]; then echo -n ${STACK_PREFIX}; else echo -n "/usr/local/ofed"; fi)
%define PACKAGES %(if [ ! -z "${PACKAGES}" ]; then echo -n ${PACKAGES}; else echo -n ""; fi)
%define WITH_PACKAGES %(if [ ! -z "${WITH_PACKAGES}" ]; then echo -n "${WITH_PACKAGES}"; else echo -n ""; fi)
%define MEMTRACK %(if [ ! -z "${MEMTRACK}" ]; then echo -n ${MEMTRACK}; else echo -n 0; fi)
%define KVERSION %(if [ ! -z "${KVERSION}" ]; then echo -n ${KVERSION}; else echo -n $(uname -r); fi)
%define BUILD_MODULES %(if [ ! -z "${BUILD_MODULES}" ]; then echo -n ${BUILD_MODULES}; else echo -n 1; fi)
%define TMPDIR /tmp/openib
%define VERSION XXXXXX
%define NAME YYYYYY
%define RELVER ZZZZZZ
%define krelver %(echo -n %{KVERSION} | tr -s '-' '_')
%define modprobe_update %(if [ ! -z "${modprobe_update}" ]; then echo -n ${modprobe_update}; else echo -n 1; fi)

# Select packages to build
%define build_kernel_ib %{BUILD_MODULES}
%define build_kernel_ib_devel %{BUILD_MODULES}

%define include_ipoib_conf %(if [ ! -z "${include_ipoib_conf}" ]; then echo -n ${include_ipoib_conf}; else echo -n 1; fi)

# Kernel module packages to be included into kernel-ib
%define build_mthca %(if ( echo %{PACKAGES} | grep -w ib_mthca > /dev/null ); then echo -n '1'; else echo -n '0'; fi)
%define build_ipath %(if ( echo %{PACKAGES} | grep -w ib_ipath > /dev/null ); then echo -n '1'; else echo -n '0'; fi)
%define build_ipoib %(if ( echo %{PACKAGES} | grep -w ib_ipoib > /dev/null ); then echo -n '1'; else echo -n '0'; fi)
%define build_sdp %(if ( echo %{PACKAGES} | grep -w ib_sdp > /dev/null ); then echo -n '1'; else echo -n '0'; fi)
%define build_srp %(if ( echo %{PACKAGES} | grep -w ib_srp > /dev/null ); then echo -n '1'; else echo -n '0'; fi)
%define build_srp_target %(if ( echo %{PACKAGES} | grep -w ib_srp_target > /dev/null ); then echo -n '1'; else echo -n '0'; fi)
%define build_iser %(if ( echo %{PACKAGES} | grep -w ib_iser > /dev/null ); then echo -n '1'; else echo -n '0'; fi)
%define build_rds %(if ( echo %{PACKAGES} | grep -w ib_rds > /dev/null ); then echo -n '1'; else echo -n '0'; fi)

%define build_srptools %(if ( echo "%{WITH_PACKAGES}" | grep -E "with-srptools|with-all-libs" > /dev/null ); then echo -n '1'; else echo -n '0'; fi)
%define build_tvflash %(if ( echo "%{WITH_PACKAGES}" | grep -E "with-tvflash" > /dev/null ) && ( rpm -q pciutils-devel > /dev/null 2>&1 ); then echo -n '1'; else echo -n '0'; fi)
%define build_libsdp %(if ( echo "%{WITH_PACKAGES}" | grep -E "with-libsdp|with-all-libs" > /dev/null ); then echo -n '1'; else echo -n '0'; fi)

%define build_opensm %(if ( echo "%{WITH_PACKAGES}" | grep -E "with-opensm|with-all-libs" > /dev/null ); then echo -n '1'; else echo -n '0'; fi)
%define build_opensm_devel %{build_opensm}
%define build_diags %(if ( echo "%{WITH_PACKAGES}" | grep -E "with-openib-diags|with-all-libs" > /dev/null ); then echo -n '1'; else echo -n '0'; fi)

%define build_perftest %(if ( echo "%{WITH_PACKAGES}" | grep -E "with-perftest|with-all-libs" > /dev/null ); then echo -n '1'; else echo -n '0'; fi)
%define build_mstflint %(if ( echo "%{WITH_PACKAGES}" | grep -E "with-mstflint|with-all-libs" > /dev/null ); then echo -n '1'; else echo -n '0'; fi)

%define build_libibverbs %(if ( echo "%{WITH_PACKAGES}" | grep -E "with-libibverbs|with-all-libs" > /dev/null ); then echo -n '1'; else echo -n '0'; fi)
%define build_libibverbs_devel %{build_libibverbs}
%define build_libibverbs_utils %{build_libibverbs}

%define build_libmthca %(if ( echo "%{WITH_PACKAGES}" | grep -E "with-libmthca|with-all-libs" > /dev/null ); then echo -n '1'; else echo -n '0'; fi)
%define build_libmthca_devel %{build_libmthca}

%define build_libipathverbs %(if ( echo "%{WITH_PACKAGES}" | grep -E "with-libipathverbs|with-all-libs" > /dev/null ); then echo -n '1'; else echo -n '0'; fi)
%define build_libipathverbs_devel %{build_libipathverbs}

%define build_libehca %(if ( echo "%{WITH_PACKAGES}" | grep -E "with-libehca|with-all-libs" > /dev/null ); then echo -n '1'; else echo -n '0'; fi)
%define build_libehca_devel %{build_libehca}

%define build_libibcm %(if ( echo "%{WITH_PACKAGES}" | grep -E "with-libibcm|with-all-libs" > /dev/null ); then echo -n '1'; else echo -n '0'; fi)
%define build_libibcm_devel %{build_libibcm}

%define build_libibcommon %(if ( echo "%{WITH_PACKAGES}" | grep -E "with-libibcommon|with-all-libs" > /dev/null ); then echo -n '1'; else echo -n '0'; fi)
%define build_libibcommon_devel %{build_libibcommon}

%define build_libibmad %(if ( echo "%{WITH_PACKAGES}" | grep -E "with-libibmad|with-all-libs" > /dev/null ); then echo -n '1'; else echo -n '0'; fi)
%define build_libibmad_devel %{build_libibmad}

%define build_libibumad %(if ( echo "%{WITH_PACKAGES}" | grep -E "with-libibumad|with-all-libs" > /dev/null ); then echo -n '1'; else echo -n '0'; fi)
%define build_libibumad_devel %{build_libibumad}

%define build_librdmacm %(if ( echo "%{WITH_PACKAGES}" | grep -E "with-librdmacm|with-all-libs" > /dev/null ); then echo -n '1'; else echo -n '0'; fi)
%define build_librdmacm_devel %{build_librdmacm}
%define build_librdmacm_utils %{build_librdmacm}

%define build_dapl %(if ( echo "%{WITH_PACKAGES}" | grep -E "with-dapl|with-all-libs" > /dev/null ); then echo -n '1'; else echo -n '0'; fi)
%define build_dapl_devel %{build_dapl}

# %if %{build_sdp}
# %define WITH_UL_PACKAGES %(if ( echo -n "%{WITH_PACKAGES}" | grep -E "with-sdp|with-all-libs" > /dev/null ); then echo -n "%{WITH_PACKAGES}"; else echo -n "%{WITH_PACKAGES} --with-libsdp"; fi)
# %else
%define WITH_UL_PACKAGES %(echo -n "%{WITH_PACKAGES}")
# %endif

%define LIB_MOD_DIR /lib/modules/%{KVERSION}/kernel/drivers/infiniband
%define NETWORK_CONF_DIR %(if [ ! -z "${NETWORK_CONF_DIR}" ]; then echo -n ${NETWORK_CONF_DIR}; else echo -n "/etc/infiniband"; fi)
%define IB_CONF_DIR /etc/infiniband

%define LIB_DIR32 %{STACK_PREFIX}/lib
%define LIB_DIR64 %{STACK_PREFIX}/lib64

%ifarch %{ix86} ia64
%define LIB_DIR %{LIB_DIR32}
%else
%define LIB_DIR %{LIB_DIR64}
%endif

%define K_SRC /lib/modules/%{KVERSION}/build
%define KSRC %(if [ ! -z ${KSRC} ]; then echo ${KSRC}; else echo %{K_SRC}; fi)

%define KERNEL_SOURCES /lib/modules/%{KVERSION}/source

%define KERNEL_24 %(if [ $(uname -r | cut -c -3) == "2.4" ]; then echo -n 1; else echo -n 0; fi)
%define KERNEL_26 %(if [ $(uname -r | cut -c -3) == "2.6" ]; then echo -n 1; else echo -n 0; fi)

# Do not include srp.h if it exist in the kernel
%define include_srp_h %(if [ -e %{KERNEL_SOURCES}/include/scsi/srp.h ]; then echo -n 0; else echo -n 1; fi )
%define include_rdma %(if [ -d %{KERNEL_SOURCES}/include/rdma ]; then echo -n 1; else echo -n 0; fi )

# Disable debugging
%define debug_package %{nil}
%define __check_files %{nil}

# Disable brp-lib64-linux
%ifarch x86_64 ia64
%define __arch_install_post %{nil}
%endif

%define librdmacm_ver 0.9.0
%define libibcm_ver 0.9.0

Summary: Infiniband HCA Driver
Prereq: /sbin/ldconfig
Name: %{NAME}
Version: %{VERSION}
Release: 0
License: GPL/BSD
Url: http://openib.org/
Group: System Environment/Base
Source: %{NAME}-%{RELVER}.tgz
BuildRoot: %{build_root}
Vendor: OpenFabrics
%description 
InfiniBand "verbs", Access Layer  and ULPs

BuildRequires: sysfsutils-devel

%package -n kernel-ib
Version: %{VERSION}
Release: %{krelver}
Summary: Infiniband Driver and ULPs kernel modules
Group: System Environment/Libraries
%description -n kernel-ib
Core, HW and ULPs kernel modules

%package -n kernel-ib-devel
Version: %{VERSION}
Release: %{krelver}
Summary: Infiniband Driver and ULPs kernel modules sources
Group: System Environment/Libraries
%description -n kernel-ib-devel
Core, HW and ULPs kernel modules sources

%package -n libibverbs
Version: 1.0.3
Release: 0
Summary: A library for direct userspace use of InfiniBand
Group: System Environment/Libraries
%description -n libibverbs
libibverbs is a library that allows userspace processes to use
InfiniBand "verbs" as described in the InfiniBand Architecture
Specification.  This includes direct hardware access for fast path
operations.

%package -n libibverbs-devel
Version: 1.0.3
Release: 0
Summary: Development files for the libibverbs library
Group: System Environment/Libraries
# Requires: %{name} = %{version}-%{release} sysfsutils-devel
%description -n libibverbs-devel
Static libraries and header files for the libibverbs verbs library.

%package -n libibverbs-utils
Version: 1.0.3
Release: 0
Summary: Examples for the libibverbs library
Group: System Environment/Libraries
# Requires: %{name} = %{version}-%{release}
%description -n libibverbs-utils
Useful libibverbs1 example programs such as ibv_devinfo, which
displays information about InfiniBand devices.

%package -n libibcm
Version: 0.9.0
Release: 0
Summary: Userspace InfiniBand Connection Manager.
Group: System Environment/Libraries
%description -n libibcm
Along with the OpenIB kernel drivers, libibcm provides a userspace
InfiniBand Connection Managment API.

%package -n libibcm-devel
Version: 0.9.0
Release: 0
Summary: Development files for the libibcm library
Group: System Environment/Libraries
%description -n libibcm-devel
Development files for the libibcm library.

%package -n libmthca
Version: 1.0.2
Release: 0
Summary: Mellanox InfiniBand HCA Userspace Driver
Group: System Environment/Libraries
%description -n libmthca
libmthca provides a device-specific userspace driver for Mellanox HCAs
(MT23108 InfiniHost and MT25208 InfiniHost III Ex) for use with the
libibverbs library.

%package -n libmthca-devel
Version: 1.0.2
Release: 0
Summary: Development files for the libmthca driver
Group: System Environment/Libraries
# Requires: %{name} = %{version}-%{release}
%description -n libmthca-devel
Static version of libmthca that may be linked directly to an
application, which may be useful for debugging.

%package -n libipathverbs
Version: 1.0
Release: 0
Summary: PathScale InfiniPath HCA Userspace Driver
Group: System Environment/Libraries
%description -n libipathverbs
libipathverbs provides a device-specific userspace driver for PathScale HCAs.

%package -n libipathverbs-devel
Version: 1.0
Release: 0
Summary: Development files for the libipathverbs driver
Group: System Environment/Libraries
%description -n libipathverbs-devel
Static version of libipathverbs that may be linked directly to an
application, which may be useful for debugging.

#%package -n libehca
#Version: @libehca_version@
#Release: @libehca_release@
#Summary: IBM eServer eHCA Infiniband device driver for Linux on POWER
#Group: System Environment/Libraries
#%description -n libehca

%package -n libsdp
Version: 1.0.0
Release: 0
Summary: LD_PRELOAD-able library for using SDP
Group: System Environment/Libraries
%description -n libsdp
libsdp can be LD_PRELOAD-ed to have a sockets application use
InfiniBand Sockets Direct Protocol (SDP) instead of TCP, transparently
and without recompiling the application.

%package -n srptools
Version: 0.0.4
Release: 0
Summary: Tools for SRP/IB
Group: Applications/System
%description -n srptools
In conjunction with the kernel ib_srp driver, srptools allows you to
discover and use SCSI devices via the SCSI RDMA Protocol over InfiniBand.

%package -n tvflash
Version: 0.9.0
Release: 0
# BuildRequires: pciutils-devel
Summary: Tool to manage Mellanox HCA firmware flash memory
Group: Applications/System
%description -n tvflash
tvflash is used to query and update the firmware flash memory attached
to Mellanox InfiniBand HCAs.

%package -n libibcommon
Version: 1.0
Release: 0
Summary: OpenIB InfiniBand Management and Diagnostic Tools
Group: System Environment/Libraries
%description -n libibcommon
libibcommon provides common utility functions for the IB diagnostic and
management tools.

%package -n libibcommon-devel
Version: 1.0
Release: 0
Summary: Development files for the libibcommon library
Group: System Environment/Libraries
%description -n libibcommon-devel
Development files for the libibcommon library

%package -n libibmad
Version: 1.0
Release: 0
Summary: OpenIB InfiniBand Management and Diagnostic Tools
Group: System Environment/Libraries
%description -n libibmad
libibmad provides low layer IB functions for use by the IB diagnostic
and management programs. These include MAD, SA, SMP, and other basic
IB functions.

%package -n libibmad-devel
Version: 1.0
Release: 0
Summary: Development files for the libibmad library.
Group: System Environment/Libraries
%description -n libibmad-devel
Development files for the libibmad library.

%package -n libibumad
Version: 1.0
Release: 0
Summary: OpenIB InfiniBand Management and Diagnostic Tools
Group: System Environment/Libraries
%description -n libibumad
libibumad provides the user MAD library functions which sit on top of
the user MAD modules in the kernel. These are used by the IB diagnostic
and management tools, including OpenSM.

%package -n libibumad-devel
Version: 1.0
Release: 0
Summary: Development files for the libibumad library.
Group: System Environment/Libraries
%description -n libibumad-devel
Development files for the libibumad library.

%package -n openib-diags
Version: 1.0
Release: 0
Summary: OpenIB InfiniBand Diagnostic Tools
Group: System Environment/Libraries
%description -n openib-diags
diags provides IB diagnostic programs and scripts needed to diagnose
an IB subnet.

%package -n opensm
Version: 1.2.0
Release: 0
Summary: InfiniBand subnet manager and administration
Group: System Environment/Libraries
%description -n opensm
OpenSM provides an implementation for an InfiniBand Subnet Manager and
Administration. Such a software entity is required to run for in order
to initialize the InfiniBand hardware (at least one per each
InfiniBand subnet).

%package -n opensm-devel
Version: 1.2.0
Release: 0
Summary: Development files for OpenSM
Group: System Environment/Libraries
%description -n opensm-devel
Static libraries and header files for OpenSM.

%package -n perftest
Version: 1.0
Release: 0
Summary: IB Performance tests
Group: System Environment/Libraries
%description -n perftest
gen2 uverbs microbenchmarks

%package -n mstflint
Version: 1.0
Release: 0
Summary: Burning Firmware Application
Group:  Applications/System
%description -n mstflint
This package contains a burning tool for Mellanox manufactured HCA cards.
It also provides access to the relevant source code.

%package -n librdmacm
Version: 0.9.0
Release: 0
Summary: RDMA cm library.
Group:  System Environment/Libraries
%description -n librdmacm
RDMA cm library.

%package -n librdmacm-devel
Version: 0.9.0
Release: 0
Summary: Development files for the librdmacm library
Group:  System Environment/Libraries
%description -n librdmacm-devel
Development files for the librdmacm library.

%package -n librdmacm-utils
Version: 0.9.0
Release: 0
Summary: Utilities for the librdmacm library
Group:  System Environment/Base
%description -n librdmacm-utils
Utilities for the librdmacm library.

%package -n dapl
Version: 1.2.0
Release: 0
Summary: Userspace DAT and DAPL API.
Group:  System Environment/Libraries
%description -n dapl
Along with the OpenIB kernel drivers, libdat and libdapl provides a userspace
RDMA API that supports DAT 1.2 specification

%package -n dapl-devel
Version: 1.2.0
Release: 0
Summary: Development files for the libdat and libdapl libraries
Group:  System Environment/Libraries
%description -n dapl-devel
Static libraries and header files for the libdat and libdapl library.


#################################################################################################################################


%prep
%setup -n %{NAME}-%{RELVER}

###
### install
###
%install
rm -rf $RPM_BUILD_ROOT
	
cd $RPM_BUILD_DIR/%{NAME}-%{RELVER}
INSTALL_PARAMS=""
%if %{MEMTRACK}
	INSTALL_PARAMS="--memtrack"
%endif

./install.sh --batch --build_only --prefix %{STACK_PREFIX} --tmpdir $RPM_BUILD_ROOT/%{TMPDIR} -kver %{KVERSION} --ksrc %{KSRC} --packages %{PACKAGES} -- %{WITH_UL_PACKAGES} --build_root $RPM_BUILD_ROOT ${INSTALL_PARAMS}
	
    # Fix kernel modules path in case that modules were installed under 'extra' directory
	install -d $RPM_BUILD_ROOT/%{STACK_PREFIX}/include
	install -d $RPM_BUILD_ROOT/%{STACK_PREFIX}/etc
	install -d $RPM_BUILD_ROOT%{LIB_MOD_DIR}/core
	install -d $RPM_BUILD_ROOT%{LIB_MOD_DIR}/debug
	install -d $RPM_BUILD_ROOT%{LIB_MOD_DIR}/hw/mthca
	install -d $RPM_BUILD_ROOT%{LIB_MOD_DIR}/hw/ipath
	install -d $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ulp
	install -d $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ulp/ipoib
	install -d $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ulp/sdp
	install -d $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ulp/srp
	install -d $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ulp/iser
	install -d $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ulp/rds


	# Core modules	
	test -e $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ib_addr.ko && mv $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ib_addr.ko $RPM_BUILD_ROOT%{LIB_MOD_DIR}/core
	test -e $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ib_at.ko && mv $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ib_at.ko $RPM_BUILD_ROOT%{LIB_MOD_DIR}/core
	test -e $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ib_cm.ko && mv $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ib_cm.ko $RPM_BUILD_ROOT%{LIB_MOD_DIR}/core
	test -e $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ib_core.ko && mv $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ib_core.ko $RPM_BUILD_ROOT%{LIB_MOD_DIR}/core
	test -e $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ib_mad.ko && mv $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ib_mad.ko $RPM_BUILD_ROOT%{LIB_MOD_DIR}/core
	test -e $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ib_ping.ko && mv $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ib_ping.ko $RPM_BUILD_ROOT%{LIB_MOD_DIR}/core
	test -e $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ib_sa.ko && mv $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ib_sa.ko $RPM_BUILD_ROOT%{LIB_MOD_DIR}/core
	test -e $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ib_uat.ko && mv $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ib_uat.ko $RPM_BUILD_ROOT%{LIB_MOD_DIR}/core
	test -e $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ib_ucm.ko && mv $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ib_ucm.ko $RPM_BUILD_ROOT%{LIB_MOD_DIR}/core
	test -e $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ib_umad.ko && mv $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ib_umad.ko $RPM_BUILD_ROOT%{LIB_MOD_DIR}/core
	test -e $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ib_uverbs.ko && mv $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ib_uverbs.ko $RPM_BUILD_ROOT%{LIB_MOD_DIR}/core
	test -e $RPM_BUILD_ROOT%{LIB_MOD_DIR}/rdma_cm.ko && mv $RPM_BUILD_ROOT%{LIB_MOD_DIR}/rdma_cm.ko $RPM_BUILD_ROOT%{LIB_MOD_DIR}/core
	test -e $RPM_BUILD_ROOT%{LIB_MOD_DIR}/rdma_ucm.ko && mv $RPM_BUILD_ROOT%{LIB_MOD_DIR}/rdma_ucm.ko $RPM_BUILD_ROOT%{LIB_MOD_DIR}/core
    test -e $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ib_local_sa.ko && mv $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ib_local_sa.ko $RPM_BUILD_ROOT%{LIB_MOD_DIR}/core
	test -e $RPM_BUILD_ROOT%{LIB_MOD_DIR}/findex.ko && mv $RPM_BUILD_ROOT%{LIB_MOD_DIR}/findex.ko $RPM_BUILD_ROOT%{LIB_MOD_DIR}/core
	test -e $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ib_multicast.ko && mv $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ib_multicast.ko $RPM_BUILD_ROOT%{LIB_MOD_DIR}/core

	# MEMTRACK module
	test -e $RPM_BUILD_ROOT%{LIB_MOD_DIR}/memtrack.ko && mv $RPM_BUILD_ROOT%{LIB_MOD_DIR}/memtrack.ko $RPM_BUILD_ROOT%{LIB_MOD_DIR}/debug

	# HW modules
	test -e $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ib_mthca.ko && mv $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ib_mthca.ko $RPM_BUILD_ROOT%{LIB_MOD_DIR}/hw/mthca

	test -e $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ib_ipath.ko && mv $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ib_ipath.ko $RPM_BUILD_ROOT%{LIB_MOD_DIR}/hw/ipath
	test -e $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ipath_core.ko && mv $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ipath_core.ko $RPM_BUILD_ROOT%{LIB_MOD_DIR}/hw/ipath

	# ULP modules
	test -e $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ib_ipoib.ko && 
		mv $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ib_ipoib.ko $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ulp/ipoib

	test -e $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ib_sdp.ko && 
		mv $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ib_sdp.ko $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ulp/sdp

	test -e $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ib_iser.ko && 
		mv $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ib_iser.ko $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ulp/iser

	test -e $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ib_rds.ko && 
		mv $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ib_rds.ko $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ulp/rds

	test -e $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ib_srp.ko && 
		mv $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ib_srp.ko $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ulp/srp

    # Handle libsdp 32 bit
    touch libsdp-files
%ifarch x86_64 ppc64
        # Remove 32 bit libsdp_sys libraries from 'prefix'/lib directory
        /bin/rm -f $RPM_BUILD_ROOT%{LIB_DIR32}/libsdp_sys*so*
        if ( /bin/ls $RPM_BUILD_ROOT%{LIB_DIR32}/libsdp*so* > /dev/null 2>&1 ); then
            /bin/ls -1 $RPM_BUILD_ROOT%{LIB_DIR32}/libsdp*so* | sed -e "s@$RPM_BUILD_ROOT@@g" > libsdp-files
        fi
%endif

%if %{build_libibcm}
    cd $RPM_BUILD_ROOT%{LIB_DIR}
    if [ -f libibcm.so ]; then
        mv libibcm.so libibcm.so.%{libibcm_ver}
        ln -s libibcm.so.%{libibcm_ver} libibcm.so
    fi
%endif

%if %{build_librdmacm}
    cd $RPM_BUILD_ROOT%{LIB_DIR}
    if [ -f librdmacm.so ]; then
        mv librdmacm.so librdmacm.so.%{librdmacm_ver}
        ln -s librdmacm.so.%{librdmacm_ver} librdmacm.so
    fi
%endif

# Copy infiniband configuration
install -d $RPM_BUILD_ROOT/%{IB_CONF_DIR}
install -m 0644 $RPM_BUILD_DIR/%{NAME}-%{RELVER}/openib.conf $RPM_BUILD_ROOT/%{IB_CONF_DIR}

%if %{build_libibverbs}
install -d $RPM_BUILD_ROOT/etc/ld.so.conf.d
echo %{LIB_DIR} > $RPM_BUILD_ROOT/etc/ld.so.conf.d/ofed.conf
%ifarch x86_64 ppc64
echo %{LIB_DIR32} >> $RPM_BUILD_ROOT/etc/ld.so.conf.d/ofed.conf
%endif
%endif

%if %{build_libibverbs_utils}
install -d $RPM_BUILD_ROOT/etc/profile.d
cat > $RPM_BUILD_ROOT/etc/profile.d/ofed.sh << EOF
if ! echo \${PATH} | grep -q %{STACK_PREFIX}/bin ; then
        PATH=\${PATH}:%{STACK_PREFIX}/bin
fi
EOF
cat > $RPM_BUILD_ROOT/etc/profile.d/ofed.csh << EOF
if ( "\${path}" !~ *%{STACK_PREFIX}/bin* ) then
        set path = ( \$path %{STACK_PREFIX}/bin )
endif
EOF
%endif

%if %{build_dapl}
# udapl configuration file
perl -ni -e  "s@/usr/lib@%{LIB_DIR}@;print" $RPM_BUILD_ROOT/%{STACK_PREFIX}/etc/dat.conf
install -m 0644 $RPM_BUILD_ROOT/%{STACK_PREFIX}/etc/dat.conf $RPM_BUILD_ROOT/etc/dat.conf
rm -f $RPM_BUILD_ROOT/%{STACK_PREFIX}/etc/dat.conf
%endif

%if %{build_ipoib}
	install -d $RPM_BUILD_ROOT/%{NETWORK_CONF_DIR}
	DEVICES="ib0 ib1"
	
	for DEVICE in $DEVICES
	do
		if [ -f /etc/SuSE-release ]; then        
	
			echo BOOTPROTO=\'dhcp\' 	>> $RPM_BUILD_ROOT/%{NETWORK_CONF_DIR}/ifcfg-${DEVICE}
			echo REMOTE_IPADDR=\'\' 	>> $RPM_BUILD_ROOT/%{NETWORK_CONF_DIR}/ifcfg-${DEVICE}
			echo STARTMODE=\'onboot\' 	>> $RPM_BUILD_ROOT/%{NETWORK_CONF_DIR}/ifcfg-${DEVICE}
			echo WIRELESS=\'no\' 		>> $RPM_BUILD_ROOT/%{NETWORK_CONF_DIR}/ifcfg-${DEVICE}
	
		else
	
			echo DEVICE=${DEVICE} 	    >> $RPM_BUILD_ROOT/%{NETWORK_CONF_DIR}/ifcfg-${DEVICE}
			echo BOOTPROTO=dhcp 	    >> $RPM_BUILD_ROOT/%{NETWORK_CONF_DIR}/ifcfg-${DEVICE}
			echo ONBOOT=yes		        >> $RPM_BUILD_ROOT/%{NETWORK_CONF_DIR}/ifcfg-${DEVICE}
	
		fi
	done
%endif

# Install openib service script
install -d $RPM_BUILD_ROOT/etc/init.d
install -m 0755 $RPM_BUILD_DIR/%{NAME}-%{RELVER}/openibd $RPM_BUILD_ROOT/etc/init.d

%if %{build_opensm}
install -m 0644 $RPM_BUILD_DIR/%{NAME}-%{RELVER}/opensm.conf $RPM_BUILD_ROOT/etc/opensm.conf
install -m 0755 $RPM_BUILD_DIR/%{NAME}-%{RELVER}/opensmd $RPM_BUILD_ROOT/etc/init.d/opensmd

# Add sldd.sh (W/A for handover issue)

install -m 0755 $RPM_BUILD_DIR/%{NAME}-%{RELVER}/sldd.sh $RPM_BUILD_ROOT/%{STACK_PREFIX}/bin/sldd.sh
sed -i -e "s@/usr/bin/opensm@%{STACK_PREFIX}/bin/opensm@g" $RPM_BUILD_ROOT/etc/init.d/opensmd
sed -i -e "s@/usr/bin/sldd.sh@%{STACK_PREFIX}/bin/sldd.sh@g" $RPM_BUILD_ROOT/etc/init.d/opensmd
%endif

install -d $RPM_BUILD_ROOT/etc/udev/rules.d
install -m 0644 $RPM_BUILD_DIR/%{NAME}-%{RELVER}/90-ib.rules $RPM_BUILD_ROOT/etc/udev/rules.d
perl -ni -e "s@(STACK_PREFIX=).*@\$1%{STACK_PREFIX}@; print" $RPM_BUILD_ROOT/etc/init.d/openibd
	
%clean
#Remove installed driver after rpm build finished
# Leave $RPM_BUILD_ROOT in order to build dependent packages
rm -rf $RPM_BUILD_DIR/%{NAME}-%{RELVER}

###
### pre section
###

%pre -n kernel-ib
# Backup original infiniband kernel modules
# under 'prefix'/backup directory

if [ -d %{LIB_MOD_DIR} ]; then
	mkdir -p %{STACK_PREFIX}/backup
	if [ ! -f %{STACK_PREFIX}/backup/infiniband_ko-%{KVERSION}.tgz ]; then
		/bin/rm -f %{STACK_PREFIX}/backup/infko_tmp.tgz
		tar czfP %{STACK_PREFIX}/backup/infko_tmp.tgz %{LIB_MOD_DIR}
		mv %{STACK_PREFIX}/backup/infko_tmp.tgz %{STACK_PREFIX}/backup/infiniband_ko-%{KVERSION}.tgz
	fi
	/bin/rm -rf %{LIB_MOD_DIR}
fi
# END of pre -n kernel-ib


%pre -n kernel-ib-devel
#########################################################################
#               Backup Gen2 original sources and include files          #
#########################################################################

if [ -d %{KERNEL_SOURCES}/drivers/infiniband ]; then
	mkdir -p %{STACK_PREFIX}/backup
	if [ ! -f %{STACK_PREFIX}/backup/infiniband-%{KVERSION}.tgz ]; then
		/bin/rm -f %{STACK_PREFIX}/backup/inf_tmp.tgz
		tar czfP %{STACK_PREFIX}/backup/inf_tmp.tgz %{KERNEL_SOURCES}/drivers/infiniband
		mv %{STACK_PREFIX}/backup/inf_tmp.tgz %{STACK_PREFIX}/backup/infiniband-%{KVERSION}.tgz
	fi
	/bin/rm -rf %{KERNEL_SOURCES}/drivers/infiniband
fi

%if %{include_rdma}
# Backup original include/rdma directory and copy the new one
if [ -d %{KERNEL_SOURCES}/include/rdma ]; then
	mkdir -p %{STACK_PREFIX}/backup
	if [ ! -f %{STACK_PREFIX}/backup/rdma-%{KVERSION}.tgz ]; then
		/bin/rm -f %{STACK_PREFIX}/backup/rdma_tmp.tgz
		tar czfP %{STACK_PREFIX}/backup/rdma_tmp.tgz %{KERNEL_SOURCES}/include/rdma
		mv %{STACK_PREFIX}/backup/rdma_tmp.tgz %{STACK_PREFIX}/backup/rdma-%{KVERSION}.tgz
	fi
	/bin/rm -rf %{KERNEL_SOURCES}/include/rdma
	mkdir -p %{KERNEL_SOURCES}/include
fi
%endif

%if %{include_srp_h}
# Backup original scsi/srp.h file and copy the new one
if [ -f %{KERNEL_SOURCES}/include/scsi/srp.h ]; then
	mkdir -p %{STACK_PREFIX}/backup
	if [ ! -f %{STACK_PREFIX}/backup/srp-%{KVERSION}.h ]; then
		mv %{KERNEL_SOURCES}/include/scsi/srp.h %{STACK_PREFIX}/backup/srp-%{KVERSION}.h
	fi
	mkdir -p %{KERNEL_SOURCES}/include/scsi
fi
%endif
# END of pre -n kernel-ib-devel

#########################################################################
#                       Backup Done                                     #
#########################################################################

%pre -n libibverbs
%pre -n libibverbs-devel
%pre -n libibverbs-utils
%pre -n libibcm
%pre -n libmthca
%pre -n libmthca-devel
%pre -n libipathverbs
%pre -n libipathverbs-devel
%pre -n libsdp
%pre -n srptools
%pre -n tvflash
%pre -n libibcommon
%pre -n libibcommon-devel
%pre -n libibmad
%pre -n libibumad
%pre -n openib-diags
%pre -n opensm
%pre -n perftest
%pre -n mstflint
%pre -n librdmacm
%pre -n dapl
%pre -n dapl-devel

###
### post section
###

%post -n kernel-ib
if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
count_ib_ports()
{
    local cnt=0
    local tmp_cnt=0
    
    tmp_cnt=$(/sbin/lspci -n | grep "15b3:6282" | wc -l | tr -d '[:space:]') # Arbel mode
    cnt=$[ $cnt + 2*${tmp_cnt} ]
    
    tmp_cnt=$(/sbin/lspci -n | grep -E "15b3:5e8c|15b3:6274" | wc -l | tr -d '[:space:]') # Sinai
    cnt=$[ $cnt + ${tmp_cnt} ]

    tmp_cnt=$(/sbin/lspci -n | grep -E "15b3:5a44|15b3:6278" | wc -l | tr -d '[:space:]') # Tavor mode
    cnt=$[ $cnt + 2*${tmp_cnt} ]
    
    return $cnt
}

count_ib_ports
ports_num=$?

# Set default number of ports to 2 if no HCAs found
if [ $ports_num -eq 0 ]; then
    ports_num=2
fi    
#############################################################################################################
#                                       Modules configuration                                               #
#############################################################################################################

if [ "$(echo %{KVERSION} | cut -c -3)" == "2.6" ]; then # 3 : Kernel 2.6

# Update /etc/modprobe.conf
# Remove previous configuration if exist
perl -ni -e 'if (/\#\# BEGIN OpenIB \#\#$/) { $filter = 1 }' -e 'if (!$filter) { print }' -e 'if (/\#\# END OpenIB \#\#$/){ $filter = 0 }' /etc/modprobe.conf

# if [ "x$(uname -m)" == "xx86_64" ] && cat /proc/cpuinfo | grep 'Intel' > /dev/null ; then # 4 : EM64T arch - enable MSI-X
#         disable_msix=0
# else # 4
#         disable_msix=1
# fi # 4 - closed


%if %{modprobe_update}
%if %{build_ipoib}
for (( i=0 ; i < $ports_num ; i++ ))
do
cat >> /etc/modprobe.conf << EOF
alias ib${i} ib_ipoib
EOF
done
%endif

%if %{build_sdp}
cat >> /etc/modprobe.conf << EOF
alias net-pf-27 ib_sdp
EOF
%endif
%endif
          
    /sbin/depmod -r -ae %{KVERSION}

fi # 3 : closed

#############################################################################################################


if [[ -f /etc/redhat-release || -f /etc/rocks-release ]]; then        
perl -i -ne 'if (m@^#!/bin/bash@) {
        print q@#!/bin/bash
#
# Bring up/down openib
#
# chkconfig: 2345 15 85
# description: Activates/Deactivates InfiniBand Driver to \
#              start at boot time.
#
### BEGIN INIT INFO
# Provides:       openibd
### END INIT INFO
@;
                 } else {
                     print;
                 }' /etc/init.d/openibd

        /sbin/chkconfig --del openibd 
        /sbin/chkconfig --add openibd 
fi

if [ -f /etc/SuSE-release ]; then
        perl -i -ne 'if (m@^#!/bin/bash@) {
        print q@#!/bin/bash
### BEGIN INIT INFO
# Provides:       openibd
# Required-Start: $local_fs $network
# Required-Stop: opensmd
# Default-Start:  2 3 5
# Default-Stop: 0 1 2 6
# Description:    Activates/Deactivates InfiniBand Driver to \
#                 start at boot time.
### END INIT INFO
@;
                 } else {
                     print;
                 }' /etc/init.d/openibd

        /sbin/insserv openibd
fi

%if %{build_kernel_ib}
	echo >> %{IB_CONF_DIR}/openib.conf
	echo "# Load UCM module" >> %{IB_CONF_DIR}/openib.conf
	echo "UCM_LOAD=no" >> %{IB_CONF_DIR}/openib.conf
	echo >> %{IB_CONF_DIR}/openib.conf
	echo "# Load RDMA_CM module" >> %{IB_CONF_DIR}/openib.conf
	echo "RDMA_CM_LOAD=no" >> %{IB_CONF_DIR}/openib.conf
	echo >> %{IB_CONF_DIR}/openib.conf
	echo "# Load RDMA_UCM module" >> %{IB_CONF_DIR}/openib.conf
	echo "RDMA_UCM_LOAD=no" >> %{IB_CONF_DIR}/openib.conf
%endif

%if %{build_mthca}
       echo >> %{IB_CONF_DIR}/openib.conf                                                
       echo "# Load MTHCA" >> %{IB_CONF_DIR}/openib.conf
       echo "MTHCA_LOAD=yes" >> %{IB_CONF_DIR}/openib.conf
%endif

%if %{build_ipath}
       echo >> %{IB_CONF_DIR}/openib.conf                                                
       echo "# Load IPATH" >> %{IB_CONF_DIR}/openib.conf
       echo "IPATH_LOAD=yes" >> %{IB_CONF_DIR}/openib.conf
%endif

%if %{build_ipoib}
       echo >> %{IB_CONF_DIR}/openib.conf                                                
       echo "# Load IPoIB" >> %{IB_CONF_DIR}/openib.conf
       echo "IPOIB_LOAD=yes" >> %{IB_CONF_DIR}/openib.conf
%endif

%if %{build_sdp}
       echo >> %{IB_CONF_DIR}/openib.conf                                                
       echo "# Load SDP module" >> %{IB_CONF_DIR}/openib.conf
       echo "SDP_LOAD=no" >> %{IB_CONF_DIR}/openib.conf
%endif

%if %{build_srp}
       echo >> %{IB_CONF_DIR}/openib.conf                                                
       echo "# Load SRP module" >> %{IB_CONF_DIR}/openib.conf
       echo "SRP_LOAD=no" >> %{IB_CONF_DIR}/openib.conf
%endif

%if %{build_iser}
       echo >> %{IB_CONF_DIR}/openib.conf                                                
       echo "# Load ISER module" >> %{IB_CONF_DIR}/openib.conf
       echo "ISER_LOAD=no" >> %{IB_CONF_DIR}/openib.conf
%endif

%if %{build_rds}
       echo >> %{IB_CONF_DIR}/openib.conf                                                
       echo "# Load RDS module" >> %{IB_CONF_DIR}/openib.conf
       echo "RDS_LOAD=no" >> %{IB_CONF_DIR}/openib.conf
%endif

## # Change IPoIB configuration
## 
## if [ -f /etc/redhat-release ]; then
##     DISTRIBUTION="RedHat"
## elif [ -f /etc/rocks-release ]; then
##     DISTRIBUTION="Rocks"
## elif [ -f /etc/SuSE-release ]; then
##     DISTRIBUTION="SuSE"
## else
##     DISTRIBUTION=`ls /etc/*-release | head -n 1 | xargs -iXXX basename XXX -release 2> /dev/null`
## fi
## 
## INTERFACES=`/sbin/ifconfig | grep eth | awk '{print$1}' | sort -n | tr -s '\n' '\ '`
## for INTERFACE in $INTERFACES
## do
## 	ADDRS=`/sbin/ifconfig $INTERFACE | grep "inet addr"`
##   	if [[ -n $ADDRS ]]; then
## 	      LAN_INTERFACE=$INTERFACE
## 	      break
## 	fi
## done
## 
## LAN_INTERFACE=${LAN_INTERFACE:-eth0}
## 
## count_ib_ports()
## {
##     local cnt=0
##     local tmp_cnt=0
##     
##     tmp_cnt=$(/sbin/lspci -n | grep "15b3:6282" | wc -l | tr -d '[:space:]') # Arbel mode
##     cnt=$[ $cnt + 2*${tmp_cnt} ]
##     
##     tmp_cnt=$(/sbin/lspci -n | grep -E "15b3:5e8c|15b3:6274" | wc -l | tr -d '[:space:]') # Sinai
##     cnt=$[ $cnt + ${tmp_cnt} ]
## 
##     tmp_cnt=$(/sbin/lspci -n | grep -E "15b3:5a44|15b3:6278" | wc -l | tr -d '[:space:]') # Tavor mode
##     cnt=$[ $cnt + 2*${tmp_cnt} ]
##     
##     return $cnt
## }
## 
## count_ib_ports
## ports_num=$?
## 
## DEVICES=""
## 
## for (( i=0 ; i < $ports_num ; i++ ))
## do
##     DEVICES="$DEVICES ib${i}"
## done    
## 
## [ "$DEVICES" == "" ] && DEVICES="ib0 ib1"
## 
## high_IP=`/sbin/ifconfig | sed -e "/\($LAN_INTERFACE\).*/{ N; s/.*inet addr:\([0-9]*\).*/\1/; }" | grep ^[0-9] | head -1`
## if [ "${high_IP}" == "" ]; then
## 	high_IP=10
## fi	
## let high_IP++
## low_IP=`/sbin/ifconfig | sed -e "/\($LAN_INTERFACE\).*/{ N; s/.*inet addr:[0-9]*\.\([0-9]*\.[0-9]*\.[0-9]*\).*/\1/; }" | grep ^[0-9] | head -1`
## if [ "${low_IP}" == "" ]; then
## 	low_IP=0.0.1
## fi
## IPADDR=${high_IP}.${low_IP}
## 
## NETMASK=`/sbin/ifconfig | sed -e "/\($LAN_INTERFACE\).*/{ N; s/.*Mask:\([0-9]*\.[0-9]*\.[0-9]*\.[0-9]*\).*/\1/; }" | grep ^[0-9] | head -1`
## if [ "${NETMASK}" == "" ]; then
## 	NETMASK=255.0.0.0
## fi
## 	
## low_Bcast=`/sbin/ifconfig | sed -e "/\($LAN_INTERFACE\).*/{ N; s/.*Bcast:[0-9]*\.\([0-9]*\.[0-9]*\.[0-9]*\).*/\1/; }" | grep ^[0-9] | head -1`
## if [ "${low_Bcast}" == "" ]; then
## 	low_Bcast=0.255.255
## fi	
## BROADCAST=${high_IP}.${low_Bcast}
## ONBOOT=1
## 
## 
## IP_A=`echo ${IPADDR} | cut -d '.' -f 1 | tr -d '[:space:]'`
## IP_B=`echo ${IPADDR} | cut -d '.' -f 2 | tr -d '[:space:]'`
## IP_C=`echo ${IPADDR} | cut -d '.' -f 3 | tr -d '[:space:]'`
## IP_D=`echo ${IPADDR} | cut -d '.' -f 4 | tr -d '[:space:]'`
## 
## NM_A=`echo ${NETMASK} | cut -d '.' -f 1 | tr -d '[:space:]'`
## NM_B=`echo ${NETMASK} | cut -d '.' -f 2 | tr -d '[:space:]'`
## NM_C=`echo ${NETMASK} | cut -d '.' -f 3 | tr -d '[:space:]'`
## NM_D=`echo ${NETMASK} | cut -d '.' -f 4 | tr -d '[:space:]'`
## 
## NW_A=$[ $IP_A & $NM_A ]
## NW_B=$[ $IP_B & $NM_B ]
## NW_C=$[ $IP_C & $NM_C ]
## NW_D=$[ $IP_D & $NM_D ]
## 
## NETWORK=${NW_A}.${NW_B}.${NW_C}.${NW_D}
## 
## IP_BCD=${IPADDR#*.}
## 
## 
## NET_BCD=${NETWORK#*.}
## BR_BCD=${BROADCAST#*.}
## 
## for DEVICE in $DEVICES
## do
## target=%{NETWORK_CONF_DIR}/ifcfg-${DEVICE}
## cat $NULL > $target
## 
## if [ "$DISTRIBUTION" == "SuSE" ]; then
## cat >> $target << EOF
## BOOTPROTO='static'
## IPADDR='${IP_A}.${IP_BCD}'
## NETMASK='${NETMASK}'
## NETWORK='${IP_A}.${NET_BCD}'
## BROADCAST='${IP_A}.${BR_BCD}'
## REMOTE_IPADDR=''
## STARTMODE='onboot'
## WIRELESS='no'
## EOF
## else
## cat >> $target << EOF
## DEVICE=$DEVICE
## BOOTPROTO=static
## IPADDR=${IP_A}.${IP_BCD}
## NETMASK=${NETMASK}
## NETWORK=${IP_A}.${NET_BCD}
## BROADCAST=${IP_A}.${BR_BCD}
## ONBOOT=yes
## EOF
## fi
## 
##     let IP_A++
## 
## done
## ### END of IPoIB configuration

fi # 1 : closed
# END of post -n kernel-ib

%post -n kernel-ib-devel
# if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
#     echo
# fi
# END of post -n kernel-ib-devel

%post -n libibverbs
if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
        
    # Update /etc/ld.so.conf
    perl -ni -e "print unless (m@%{LIB_DIR}\b@)" /etc/ld.so.conf
    echo "%{LIB_DIR}" >> /etc/ld.so.conf
    
    /sbin/ldconfig

fi
# END of post -n libibverbs

%post -n libibverbs-devel
if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
        
    # Update /etc/ld.so.conf
    perl -ni -e "print unless (m@%{LIB_DIR}\b@)" /etc/ld.so.conf
    echo "%{LIB_DIR}" >> /etc/ld.so.conf
    
    /sbin/ldconfig

fi
# END of post -n libibverbs-devel

%post -n libibverbs-utils
if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
        
    # Update /etc/ld.so.conf
    perl -ni -e "print unless (m@%{LIB_DIR}\b@)" /etc/ld.so.conf
    echo "%{LIB_DIR}" >> /etc/ld.so.conf
    
    /sbin/ldconfig

fi
# END of post -n libibverbs-utils

%post -n libibcm
if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
        
    # Update /etc/ld.so.conf
    perl -ni -e "print unless (m@%{LIB_DIR}\b@)" /etc/ld.so.conf
    echo "%{LIB_DIR}" >> /etc/ld.so.conf
    
    /sbin/ldconfig

fi

%post -n libmthca
if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
        
    # Update /etc/ld.so.conf
    perl -ni -e "print unless (m@%{LIB_DIR}\b@)" /etc/ld.so.conf
    echo "%{LIB_DIR}" >> /etc/ld.so.conf
    
    /sbin/ldconfig

fi

%post -n libmthca-devel
if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
        
    # Update /etc/ld.so.conf
    perl -ni -e "print unless (m@%{LIB_DIR}\b@)" /etc/ld.so.conf
    echo "%{LIB_DIR}" >> /etc/ld.so.conf
    
    /sbin/ldconfig

fi

%post -n libipathverbs
if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
        
    # Update /etc/ld.so.conf
    perl -ni -e "print unless (m@%{LIB_DIR}\b@)" /etc/ld.so.conf
    echo "%{LIB_DIR}" >> /etc/ld.so.conf
    
    /sbin/ldconfig

fi

%post -n libipathverbs-devel
if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
        
    # Update /etc/ld.so.conf
    perl -ni -e "print unless (m@%{LIB_DIR}\b@)" /etc/ld.so.conf
    echo "%{LIB_DIR}" >> /etc/ld.so.conf
    
    /sbin/ldconfig

fi

%post -n libsdp
if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
    perl -ni -e "print unless (m@%{LIB_DIR}\b@)" /etc/ld.so.conf
    echo "%{LIB_DIR}" >> /etc/ld.so.conf

    if [ `uname -m` == "x86_64" ] || [ `uname -m` == "ppc64" ]; then
	# Update /etc/ld.so.conf
	perl -ni -e "print unless (m@%{LIB_DIR32}\b@)" /etc/ld.so.conf
	echo "%{LIB_DIR32}" >> /etc/ld.so.conf
    fi
    /sbin/ldconfig
fi

%post -n srptools
# if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
#     echo
# fi
# 
%post -n tvflash
# if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
#     echo
# fi

%post -n libibcommon
if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
        
    # Update /etc/ld.so.conf
    perl -ni -e "print unless (m@%{LIB_DIR}\b@)" /etc/ld.so.conf
    echo "%{LIB_DIR}" >> /etc/ld.so.conf
    
    /sbin/ldconfig

fi

%post -n libibcommon-devel
if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
        
    # Update /etc/ld.so.conf
    perl -ni -e "print unless (m@%{LIB_DIR}\b@)" /etc/ld.so.conf
    echo "%{LIB_DIR}" >> /etc/ld.so.conf
    
    /sbin/ldconfig

fi

%post -n libibmad
if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
        
    # Update /etc/ld.so.conf
    perl -ni -e "print unless (m@%{LIB_DIR}\b@)" /etc/ld.so.conf
    echo "%{LIB_DIR}" >> /etc/ld.so.conf
    
    /sbin/ldconfig

fi

%post -n libibmad-devel
if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
        
    # Update /etc/ld.so.conf
    perl -ni -e "print unless (m@%{LIB_DIR}\b@)" /etc/ld.so.conf
    echo "%{LIB_DIR}" >> /etc/ld.so.conf
    
    /sbin/ldconfig

fi

%post -n libibumad
if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
        
    # Update /etc/ld.so.conf
    perl -ni -e "print unless (m@%{LIB_DIR}\b@)" /etc/ld.so.conf
    echo "%{LIB_DIR}" >> /etc/ld.so.conf
    
    /sbin/ldconfig

fi

%post -n libibumad-devel
if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
        
    # Update /etc/ld.so.conf
    perl -ni -e "print unless (m@%{LIB_DIR}\b@)" /etc/ld.so.conf
    echo "%{LIB_DIR}" >> /etc/ld.so.conf
    
    /sbin/ldconfig

fi

%post -n openib-diags
# if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
# fi

%post -n opensm
if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
if [[ -f /etc/redhat-release || -f /etc/rocks-release ]]; then
        perl -i -ne 'if (m@^#!/bin/bash@) {
        print q@#!/bin/bash
#
# Bring up/down opensm
#
# chkconfig: 235 40 80
# description: Activates/Deactivates all OpenSM to \
#              start at boot time.
#
### BEGIN INIT INFO
# Provides:       opensmd
### END INIT INFO
@;
                 } else {
                     print;
                 }' /etc/init.d/opensmd

        /sbin/chkconfig --del opensmd
        /sbin/chkconfig --add opensmd
fi

if [ -f /etc/SuSE-release ]; then
        perl -i -ne 'if (m@^#!/bin/bash@) {
        print q@#!/bin/bash
### BEGIN INIT INFO
# Provides:       opensmd
# Required-Start: $network openibd
# Required-Stop:
# Default-Start:  2 3 5
# Default-Stop: 0 1 2 6
# Description:    Activates/Deactivates OpenSM to \
#                 start at boot time.
### END INIT INFO
@;
                 } else {
                     print;
                 }' /etc/init.d/opensmd

        /sbin/insserv opensmd
fi

        
    # Update /etc/ld.so.conf
    perl -ni -e "print unless (m@%{LIB_DIR}\b@)" /etc/ld.so.conf
    echo "%{LIB_DIR}" >> /etc/ld.so.conf
    
    /sbin/ldconfig


fi # 1 : Closed

%post -n perftest
# if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
# fi

%post -n mstflint
# if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
# fi

%post -n librdmacm
if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
        
    # Update /etc/ld.so.conf
    perl -ni -e "print unless (m@%{LIB_DIR}\b@)" /etc/ld.so.conf
    echo "%{LIB_DIR}" >> /etc/ld.so.conf
    
    /sbin/ldconfig

fi

%post -n dapl
if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
        
    # Update /etc/ld.so.conf
    perl -ni -e "print unless (m@%{LIB_DIR}\b@)" /etc/ld.so.conf
    echo "%{LIB_DIR}" >> /etc/ld.so.conf
    
    /sbin/ldconfig

fi

%post -n dapl-devel
if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
        
    # Update /etc/ld.so.conf
    perl -ni -e "print unless (m@%{LIB_DIR}\b@)" /etc/ld.so.conf
    echo "%{LIB_DIR}" >> /etc/ld.so.conf
    
    /sbin/ldconfig

fi

###
### preun section
###

%preun -n kernel-ib
if [ $1 = 0 ]; then  # 1 : Erase, not upgrade
          if [[ -f /etc/redhat-release || -f /etc/rocks-release ]]; then        
               /sbin/chkconfig --del openibd 
          fi
          if [ -f /etc/SuSE-release ]; then
               /sbin/insserv -r openibd
          fi
fi

%preun -n kernel-ib-devel
if [ $1 = 0 ]; then  # 1 : Erase, not upgrade
    echo
fi

%preun -n libibverbs
if [ $1 = 0 ]; then  # 1 : Erase, not upgrade
    # Update /etc/ld.so.conf
    if [ ! -d %{LIB_DIR} ]; then
        perl -ni -e "print unless (m@%{LIB_DIR}\b@)" /etc/ld.so.conf
        /sbin/ldconfig        
    fi
fi

# %preun -n libibverbs-devel
# if [ $1 = 0 ]; then  # 1 : Erase, not upgrade
#     echo
# fi
# 
%preun -n libibverbs-utils
# if [ $1 = 0 ]; then  # 1 : Erase, not upgrade
# fi
# 
%preun -n libibcm
# if [ $1 = 0 ]; then  # 1 : Erase, not upgrade
#     echo
# fi

%preun -n libmthca
# if [ $1 = 0 ]; then  # 1 : Erase, not upgrade
#     echo
# fi

%preun -n libmthca-devel
# if [ $1 = 0 ]; then  # 1 : Erase, not upgrade
#     echo
# fi

%preun -n libipathverbs
# if [ $1 = 0 ]; then  # 1 : Erase, not upgrade
#     echo
# fi

%preun -n libipathverbs-devel
# if [ $1 = 0 ]; then  # 1 : Erase, not upgrade
#     echo
# fi

%preun -n libsdp
# if [ $1 = 0 ]; then  # 1 : Erase, not upgrade
#     echo
# fi

%preun -n srptools
# if [ $1 = 0 ]; then  # 1 : Erase, not upgrade
#     echo
# fi

%preun -n tvflash
# if [ $1 = 0 ]; then  # 1 : Erase, not upgrade
#     echo
# fi

%preun -n libibcommon
# if [ $1 = 0 ]; then  # 1 : Erase, not upgrade
#     echo
# fi

%preun -n libibcommon-devel
# if [ $1 = 0 ]; then  # 1 : Erase, not upgrade
#     echo
# fi

%preun -n libibmad
# if [ $1 = 0 ]; then  # 1 : Erase, not upgrade
#     echo
# fi

%preun -n libibumad
# if [ $1 = 0 ]; then  # 1 : Erase, not upgrade
#     echo
# fi

%preun -n openib-diags
# if [ $1 = 0 ]; then  # 1 : Erase, not upgrade
# fi

%preun -n opensm
if [ $1 = 0 ]; then  # 1 : Erase, not upgrade
    if [[ -f /etc/redhat-release || -f /etc/rocks-release ]]; then
         /sbin/chkconfig --del opensmd
    fi
    if [ -f /etc/SuSE-release ]; then
         /sbin/insserv -r opensmd
    fi
fi

%preun -n perftest
# if [ $1 = 0 ]; then  # 1 : Erase, not upgrade
# fi

%preun -n mstflint
# if [ $1 = 0 ]; then  # 1 : Erase, not upgrade
# fi

%preun -n librdmacm
# if [ $1 = 0 ]; then  # 1 : Erase, not upgrade
#     echo
# fi

%preun -n dapl
# if [ $1 = 0 ]; then  # 1 : Erase, not upgrade
#     echo
# fi

%preun -n dapl-devel
# if [ $1 = 0 ]; then  # 1 : Erase, not upgrade
#     echo
# fi


###
### post uninstall section
###
%postun -n kernel-ib
if [ $1 = 0 ]; then  # 1 : Erase, not upgrade
    if [ -f %{STACK_PREFIX}/backup/infiniband_ko-%{KVERSION}.tgz ]; then
    	/bin/rm -rf %{LIB_MOD_DIR}
    	tar xzfP %{STACK_PREFIX}/backup/infiniband_ko-%{KVERSION}.tgz
    	/bin/rm -f %{STACK_PREFIX}/backup/infiniband_ko-%{KVERSION}.tgz
        /sbin/depmod -r -ae %{KVERSION}
    fi
    
    if [ `uname -r | cut -c -3` == "2.6" ]; then
    	# Clean /etc/modprobe.conf   
	# Remove previous configuration if exist
	perl -ni -e "print unless (/ib_ipoib/)" /etc/modprobe.conf
	perl -ni -e "print unless (/ib_sdp/)" /etc/modprobe.conf
	perl -ni -e 'if (/\#\# BEGIN OpenIB \#\#$/) { $filter = 1 }' -e 'if (!$filter) { print }' -e 'if (/\#\# END OpenIB \#\#$/){ $filter = 0 }' /etc/modprobe.conf
    	/sbin/depmod -r -ae %{KVERSION}
    fi
fi

%postun -n kernel-ib-devel
if [ $1 = 0 ]; then  # 1 : Erase, not upgrade
#########################################################################
#              Restore Gen2 original sources and include files          #
#########################################################################

    if [ -f %{STACK_PREFIX}/backup/infiniband-%{KVERSION}.tgz ]; then
    	rm -rf %{KERNEL_SOURCES}/drivers/infiniband
    	tar xzfP %{STACK_PREFIX}/backup/infiniband-%{KVERSION}.tgz
    	/bin/rm -f %{STACK_PREFIX}/backup/infiniband-%{KVERSION}.tgz
    fi
    
    
    if [ -f %{STACK_PREFIX}/backup/rdma-%{KVERSION}.tgz ]; then
    	rm -rf %{KERNEL_SOURCES}/include/rdma
    	tar xzfP %{STACK_PREFIX}/backup/rdma-%{KVERSION}.tgz
    	/bin/rm -f %{STACK_PREFIX}/backup/rdma-%{KVERSION}.tgz
    fi
    
    if [ -f %{STACK_PREFIX}/backup/srp-%{KVERSION}.h ]; then
    	rm -rf %{KERNEL_SOURCES}/include/scsi/srp.h
    	mv %{STACK_PREFIX}/backup/srp-%{KVERSION}.h %{KERNEL_SOURCES}/include/scsi/srp.h
    fi

#########################################################################
#                           Restore Done                                #
#########################################################################
fi

%postun -n libibverbs
#if [ $1 = 0 ]; then  # 1 : Erase, not upgrade
#    echo
#fi

%postun -n libibverbs-devel
#if [ $1 = 0 ]; then  # 1 : Erase, not upgrade
#    echo
#fi

%postun -n libibverbs-utils
#if [ $1 = 0 ]; then  # 1 : Erase, not upgrade
#    echo
#fi

%postun -n libibcm
#if [ $1 = 0 ]; then  # 1 : Erase, not upgrade
#    echo
#fi

%postun -n libmthca
#if [ $1 = 0 ]; then  # 1 : Erase, not upgrade
#    echo
#fi

%postun -n libmthca-devel
#if [ $1 = 0 ]; then  # 1 : Erase, not upgrade
#    echo
#fi

%postun -n libipathverbs
#if [ $1 = 0 ]; then  # 1 : Erase, not upgrade
#    echo
#fi

%postun -n libipathverbs-devel
#if [ $1 = 0 ]; then  # 1 : Erase, not upgrade
#    echo
#fi

%postun -n libsdp
#if [ $1 = 0 ]; then  # 1 : Erase, not upgrade
#    echo
#fi

%postun -n srptools
#if [ $1 = 0 ]; then  # 1 : Erase, not upgrade
#    echo
#fi

%postun -n tvflash
#if [ $1 = 0 ]; then  # 1 : Erase, not upgrade
#    echo
#fi

%postun -n libibcommon
#if [ $1 = 0 ]; then  # 1 : Erase, not upgrade
#    echo
#fi

%postun -n libibcommon-devel
#if [ $1 = 0 ]; then  # 1 : Erase, not upgrade
#    echo
#fi

%postun -n libibmad
#if [ $1 = 0 ]; then  # 1 : Erase, not upgrade
#    echo
#fi

%postun -n libibumad
#if [ $1 = 0 ]; then  # 1 : Erase, not upgrade
#    echo
#fi

%postun -n openib-diags
#if [ $1 = 0 ]; then  # 1 : Erase, not upgrade
#    echo
#fi

%postun -n opensm
#if [ $1 = 0 ]; then  # 1 : Erase, not upgrade
#    echo
#fi

%postun -n perftest
#if [ $1 = 0 ]; then  # 1 : Erase, not upgrade
#    echo
#fi

%postun -n mstflint
#if [ $1 = 0 ]; then  # 1 : Erase, not upgrade
#    echo
#fi

%postun -n librdmacm
#if [ $1 = 0 ]; then  # 1 : Erase, not upgrade
#    echo
#fi

%postun -n dapl
#if [ $1 = 0 ]; then  # 1 : Erase, not upgrade
#    echo
#fi

%postun -n dapl-devel
#if [ $1 = 0 ]; then  # 1 : Erase, not upgrade
#    echo
#fi


###
### Files
###
%if %{build_kernel_ib}
%files -n kernel-ib
%defattr(-,root,root,-)
%dir %{LIB_MOD_DIR}
%{LIB_MOD_DIR}/core
%if %{build_mthca}
%{LIB_MOD_DIR}/hw/mthca
%endif
%if %{build_ipath}
%{LIB_MOD_DIR}/hw/ipath
%endif
%if %{MEMTRACK}
%{LIB_MOD_DIR}/debug/memtrack.ko
%endif
%if %{build_ipoib} && %{include_ipoib_conf}
%dir %{NETWORK_CONF_DIR}
%config(noreplace) %{NETWORK_CONF_DIR}/ifcfg-ib*[0-9]
%endif
%dir %{IB_CONF_DIR}
%config(noreplace) %{IB_CONF_DIR}/openib.conf
%{IB_CONF_DIR}/info
/etc/init.d/openibd
/etc/udev/rules.d/90-ib.rules
%if %{build_ipoib}
%{LIB_MOD_DIR}/ulp/ipoib
%endif
%if %{build_sdp}
%{LIB_MOD_DIR}/ulp/sdp
%endif
%if %{build_srp}
%{LIB_MOD_DIR}/ulp/srp
%endif
%if %{build_iser}
%{LIB_MOD_DIR}/ulp/iser
%endif
%if %{build_rds}
%{LIB_MOD_DIR}/ulp/rds
%endif

%endif

%if %{build_kernel_ib_devel}
%files -n kernel-ib-devel
%defattr(-,root,root,-)
%dir %{KERNEL_SOURCES}/drivers/infiniband
%{KERNEL_SOURCES}/drivers/infiniband/include
%{KERNEL_SOURCES}/drivers/infiniband/core
%{KERNEL_SOURCES}/drivers/infiniband/hw
%{KERNEL_SOURCES}/drivers/infiniband/Makefile
%{KERNEL_SOURCES}/drivers/infiniband/Kconfig
%if %{include_rdma}
%{KERNEL_SOURCES}/include/rdma
%endif
%{KERNEL_SOURCES}/drivers/infiniband/ulp/ipoib
%{KERNEL_SOURCES}/drivers/infiniband/ulp/sdp
%{KERNEL_SOURCES}/drivers/infiniband/ulp/srp
%if %{include_srp_h}
%{KERNEL_SOURCES}/include/scsi/srp.h
%endif
%endif

%if %{build_libibverbs}
%files -n libibverbs
%defattr(-,root,root,-)
%{LIB_DIR}/libibverbs*.so.*
/etc/ld.so.conf.d/ofed.conf
%endif

%if %{build_libibverbs_devel}
%files -n libibverbs-devel
%defattr(-,root,root,-)
%{LIB_DIR}/libibverbs*.a
%{LIB_DIR}/libibverbs*.so
%{STACK_PREFIX}/include/infiniband/arch.h         
%{STACK_PREFIX}/include/infiniband/driver.h       
%{STACK_PREFIX}/include/infiniband/kern-abi.h     
%{STACK_PREFIX}/include/infiniband/marshall.h     
%{STACK_PREFIX}/include/infiniband/opcode.h       
%{STACK_PREFIX}/include/infiniband/sa.h           
%{STACK_PREFIX}/include/infiniband/sa-kern-abi.h  
%{STACK_PREFIX}/include/infiniband/verbs.h
#%{_includedir}/*
%endif

%if %{build_libibverbs_utils}
%files -n libibverbs-utils
%defattr(-,root,root,-)
# %{_bindir}/*
%{STACK_PREFIX}/bin/ibv_*
%{STACK_PREFIX}/man/man1/ibv_*
/etc/profile.d/ofed.sh
/etc/profile.d/ofed.csh
%endif

%if %{build_libibcm}
%files -n libibcm
%defattr(-,root,root,-)
%{LIB_DIR}/libibcm*.so.*
%endif

%if %{build_libibcm_devel}
%files -n libibcm-devel
%defattr(-,root,root,-)
%{LIB_DIR}/libibcm*.so
%{STACK_PREFIX}/include/infiniband/cm_abi.h
%{STACK_PREFIX}/include/infiniband/cm.h
%endif

%if %{build_libmthca}
%files -n libmthca
%defattr(-,root,root,-)
%{LIB_DIR}/infiniband/mthca.so
# %doc AUTHORS COPYING ChangeLog README
%endif

%if %{build_libmthca_devel}
%files -n libmthca-devel
%defattr(-,root,root,-)
%{LIB_DIR}/infiniband/mthca.a
%endif

%if %{build_libipathverbs}
%files -n libipathverbs
%defattr(-,root,root,-)
%{LIB_DIR}/infiniband/ipathverbs.so
# %doc AUTHORS COPYING ChangeLog README
%endif

%if %{build_libipathverbs_devel}
%files -n libipathverbs-devel
%defattr(-,root,root,-)
%{LIB_DIR}/infiniband/ipathverbs.a
%endif

%if %{build_libsdp}
%files -n libsdp -f libsdp-files
%defattr(-,root,root)
%{LIB_DIR}/libsdp*.so*
#%config(noreplace) %{_sysconfdir}/libsdp.conf
%config(noreplace) %{STACK_PREFIX}/etc/libsdp.conf
%endif

%if %{build_srptools}
%files -n srptools
%defattr(-,root,root)
%{STACK_PREFIX}/sbin/ibsrpdm
%endif

%if %{build_tvflash}
%files -n tvflash
%defattr(-,root,root)
%{STACK_PREFIX}/sbin/tvflash
%endif

%if %{build_libibcommon}
%files -n libibcommon
%defattr(-,root,root)
%{LIB_DIR}/libibcommon*.so.*
%endif

%if %{build_libibcommon_devel}
%files -n libibcommon-devel
%defattr(-,root,root)
%{LIB_DIR}/libibcommon.a
%{LIB_DIR}/libibcommon*.so
%{STACK_PREFIX}/include/infiniband/common.h
%endif

%if %{build_libibmad}                     
%files -n libibmad
%defattr(-,root,root)
%{LIB_DIR}/libibmad*.so.*
%endif

%if %{build_libibmad_devel}
%files -n libibmad-devel
%defattr(-,root,root)
%{LIB_DIR}/libibmad.a
%{LIB_DIR}/libibmad.so
%{STACK_PREFIX}/include/infiniband/mad.h
%endif

%if %{build_libibumad}                
%files -n libibumad
%defattr(-,root,root)
%{LIB_DIR}/libibumad*.so.*
%endif

%if %{build_libibumad_devel}
%files -n libibumad-devel
%defattr(-,root,root)
%{LIB_DIR}/libibumad.so
%{LIB_DIR}/libibumad.a
%{STACK_PREFIX}/include/infiniband/umad.h
%endif

%if %{build_diags}
%files -n openib-diags
%defattr(-,root,root)
%{STACK_PREFIX}/bin/ibaddr 
%{STACK_PREFIX}/bin/ibnetdiscover 
%{STACK_PREFIX}/bin/ibping 
%{STACK_PREFIX}/bin/ibroute 
%{STACK_PREFIX}/bin/ibstat 
%{STACK_PREFIX}/bin/ibsysstat 
%{STACK_PREFIX}/bin/ibtracert 
%{STACK_PREFIX}/bin/perfquery 
%{STACK_PREFIX}/bin/sminfo 
%{STACK_PREFIX}/bin/smpquery 
# %{STACK_PREFIX}/bin/saquery 
%{STACK_PREFIX}/bin/smpdump
%{STACK_PREFIX}/bin/ibchecknet
%{STACK_PREFIX}/bin/ibchecknode
%{STACK_PREFIX}/bin/ibcheckerrors
%{STACK_PREFIX}/bin/ibcheckport
%{STACK_PREFIX}/bin/ibhosts
%{STACK_PREFIX}/bin/ibstatus 
%{STACK_PREFIX}/bin/ibswitches
%{STACK_PREFIX}/bin/discover.pl
%{STACK_PREFIX}/bin/ibcheckerrs
%{STACK_PREFIX}/bin/ibcheckportstate
%{STACK_PREFIX}/bin/ibcheckportwidth
%{STACK_PREFIX}/bin/ibcheckstate
%{STACK_PREFIX}/bin/ibcheckwidth
%{STACK_PREFIX}/bin/ibclearcounters
%{STACK_PREFIX}/bin/ibclearerrors
%{STACK_PREFIX}/bin/ibnodes
%{STACK_PREFIX}/bin/ibportstate
%endif

%if %{build_opensm}
%files -n opensm
%defattr(-,root,root)
%{STACK_PREFIX}/bin/opensm
%{STACK_PREFIX}/bin/osmtest
%{STACK_PREFIX}/bin/sldd.sh
%config(noreplace) /etc/opensm.conf
/etc/init.d/opensmd
# %{LIB_DIR}/libosmvendor*.so*
# %{LIB_DIR}/libosmcomp*.so*
%{LIB_DIR}/libosm*so.*
%{LIB_DIR}/libopensm.*so.*
%endif

%if %{build_opensm_devel}
%files -n opensm-devel
%defattr(-,root,root)
%{STACK_PREFIX}/include/infiniband/vendor
%{STACK_PREFIX}/include/infiniband/opensm
%{STACK_PREFIX}/include/infiniband/complib
%{STACK_PREFIX}/include/infiniband/iba
%{LIB_DIR}/libosm*so
%{LIB_DIR}/libopensm.*so
%{LIB_DIR}/libosm*.a
%{LIB_DIR}/libopensm.a
%endif

%if %{build_perftest}
%files -n perftest
%defattr(-,root,root)
%{STACK_PREFIX}/bin/ib_rdma_lat
%{STACK_PREFIX}/bin/ib_rdma_bw
%{STACK_PREFIX}/bin/ib_write_lat
%{STACK_PREFIX}/bin/ib_write_bw
%{STACK_PREFIX}/bin/ib_send_lat
%{STACK_PREFIX}/bin/ib_send_bw
%{STACK_PREFIX}/bin/ib_read_lat
%{STACK_PREFIX}/bin/ib_read_bw
%{STACK_PREFIX}/bin/runme
%{STACK_PREFIX}/bin/ib_write_bw_postlist
%{STACK_PREFIX}/bin/ib_clock_test
%endif

%if %{build_mstflint}
%files -n mstflint
%defattr(-,root,root)
%{STACK_PREFIX}/bin/mread
%{STACK_PREFIX}/bin/mwrite
%{STACK_PREFIX}/bin/mstflint
%endif

%if %{build_librdmacm}
%files -n librdmacm
%defattr(-,root,root)
%{LIB_DIR}/librdmacm*.so.*
%endif

%if %{build_librdmacm_devel}
%files -n librdmacm-devel
%defattr(-,root,root)
%{LIB_DIR}/librdmacm*.so
%{STACK_PREFIX}/include/rdma/rdma_cma_abi.h
%{STACK_PREFIX}/include/rdma/rdma_cma.h
%endif

%if %{build_librdmacm_utils}
%files -n librdmacm-utils
%defattr(-,root,root)
%{STACK_PREFIX}/bin/rping
%{STACK_PREFIX}/bin/ucmatose
%endif

%if %{build_dapl}
%files -n dapl
%defattr(-,root,root)
%{LIB_DIR}/libda*.so.*
%config(noreplace) %{_sysconfdir}/dat.conf
%endif

%if %{build_dapl_devel}
%files -n dapl-devel
%defattr(-,root,root)
%{LIB_DIR}/libda*.so
%{LIB_DIR}/*.a
%{STACK_PREFIX}/include/dat/dat.h
%{STACK_PREFIX}/include/dat/dat_error.h
%{STACK_PREFIX}/include/dat/dat_platform_specific.h
%{STACK_PREFIX}/include/dat/dat_redirection.h
%{STACK_PREFIX}/include/dat/dat_registry.h
%{STACK_PREFIX}/include/dat/dat_vendor_specific.h
%{STACK_PREFIX}/include/dat/udat_config.h
%{STACK_PREFIX}/include/dat/udat.h
%{STACK_PREFIX}/include/dat/udat_redirection.h
%{STACK_PREFIX}/include/dat/udat_vendor_specific.h
%endif
# END Files

%changelog
* Thu May 18 2006 Vladimir Sokolovsky <vlad@mellanox.co.il>
- Added libibcm-devel, librdmacm-devel and librdmacm-utils packages
* Tue May 16 2006 Vladimir Sokolovsky <vlad@mellanox.co.il>
- Removed links from /usr/bin to 'prifix'/bin
* Sun May 14 2006 Vladimir Sokolovsky <vlad@mellanox.co.il>
- Removed ibutils
* Wed Apr  27 2006 Vladimir Sokolovsky <vlad@mellanox.co.il>
- Removed libibat
* Wed Apr  5 2006 Vladimir Sokolovsky <vlad@mellanox.co.il>
- Added dapl and dapl-devel packages
* Sun Apr  2 2006 Vladimir Sokolovsky <vlad@mellanox.co.il>
- Changed ibdiag to ibutils. Added ibis, ibdm and ibmgtsim packages
* Thu Mar 23 2006 Vladimir Sokolovsky <vlad@mellanox.co.il>
- Added libibcommon-devel, libibmad-devel and libibumad-devel packages
* Tue Mar 14 2006 Vladimir Sokolovsky <vlad@mellanox.co.il>
- Added ibdiag tools
* Mon Mar 13 2006 Vladimir Sokolovsky <vlad@mellanox.co.il>
- Changed osm to opensm, added opensm-devel package
* Wed Mar  8 2006 Vladimir Sokolovsky <vlad@mellanox.co.il>
- Added header files: include/infiniband/...
* Sun Mar  5 2006 Vladimir Sokolovsky <vlad@mellanox.co.il>
- Repackaging: openib like RPMs
* Mon Jan  2 2006 Vladimir Sokolovsky <vlad@mellanox.co.il>
- Added libsdp 32 bit libraries for x86_64 platform
* Mon Nov 14 2005 Vladimir Sokolovsky <vlad@mellanox.co.il>
- Initial packaging for openib gen2 stack
