#!/bin/bash
#
# Copyright (c) 2006 Mellanox Technologies. All rights reserved.
#
# This Software is licensed under one of the following licenses:
#
# 1) under the terms of the "Common Public License 1.0" a copy of which is
#    available from the Open Source Initiative, see
#    http://www.opensource.org/licenses/cpl.php.
#
# 2) under the terms of the "The BSD License" a copy of which is
#    available from the Open Source Initiative, see
#    http://www.opensource.org/licenses/bsd-license.php.
#
# 3) under the terms of the "GNU General Public License (GPL) Version 2" a
#    copy of which is available from the Open Source Initiative, see
#    http://www.opensource.org/licenses/gpl-license.php.
#
# Licensee has the right to choose one of the above licenses.
#
# Redistributions of source code must retain the above copyright
# notice and one of the license notices.
#
# Redistributions in binary form must reproduce both the above copyright
# notice, one of the license notices in the documentation
# and/or other materials provided with the distribution.
#
#  $Id: build_rpm.sh 7673 2006-06-05 08:48:20Z vlad $
#
# Description: RPM build script
#

build_root="/var/tmp/OFED"
STACK_PREFIX=/usr/local/ofed
PACKAGES=""
WITH_PACKAGES=""
ALL_PACKAGES="ib_verbs ib_mthca ib_ipath ib_ipoib ib_sdp ib_iser ib_rds ib_srp"
WITH_ALL_PACKAGES="--with-all-libs"
MEMTRACK=0
modprobe_update=1
include_ipoib_conf=1
BUILD_MODULES=0
RPM_DIR=$(rpm --eval '%{_topdir}')

usage()
{
cat << EOF

    `basename $0` [ --prefix <install-dir> ] [ --build_root <BUILD_ROOT> ] [-kver <kernel version>] [-k|--ksrc DIR]
                  [--packages package1 package2 ... -- | --all] [--memtrack] 
                  [--with-modprobe] [--without-modprobe] [--with-ipoibconf] [--without-ipoibconf]
                  [--topdir <rpmbuild topdir>]
        
        The default software stack prefix is $STACK_PREFIX
        The default BUILD_ROOT is $build_root
        Available Packages: $ALL_PACKAGES
        The default user level libraries list: ""
        The default _topdir: $RPM_DIR

EOF
}

while [ $# -gt 0 ]
do
    case $1 in
            --topdir)
                shift
                RPM_DIR=$1
            ;;
            -p|--prefix)
                shift
                STACK_PREFIX=$1
            ;;
            --build_root)
                shift
                build_root=$1
            ;; 
            --packages)
                shift
                BUILD_MODULES=1
                while [ "$1" != "--" ]
                do
                    PACKAGES="$PACKAGES $1"
                    shift
                done    
                if [ -z "$PACKAGES" ]; then
                        BUILD_MODULES=0
                fi
            ;;
            --all)
                PACKAGES="${ALL_PACKAGES}"
                BUILD_MODULES=1
            ;;
            -kver)
                shift
                KVERSION=$1
            ;;
            -k|--ksrc)
                shift
                KSRC=$1
            ;;
            --memtrack)
                MEMTRACK=1
            ;;
            --with-modprobe)
                modprobe_update=1
            ;;
            --without-modprobe)
                modprobe_update=0
            ;;
            --with-ipoibconf)
                include_ipoib_conf=1
            ;;
            --without-ipoibconf)
                include_ipoib_conf=0
            ;;
            --debug)
                WITH_PACKAGES="${WITH_PACKAGES} $1"
            ;;
            --with*)
                WITH_PACKAGES="${WITH_PACKAGES} $1"
                case "$1" in
                         *-mod)
                                 BUILD_MODULES=1
                         ;;
                esac
            ;;  
            *)
                usage
                exit 1
            ;;
    esac            
    shift
done

# Set default value for PACKAGES  
if [ -z "${PACKAGES}" ] && [ $BUILD_MODULES -eq 1 ]; then
    PACKAGES="${ALL_PACKAGES}"
fi

# if [ -z "$WITH_PACKAGES" ]; then
#     WITH_PACKAGES="${WITH_ALL_PACKAGES}"
# fi
    
#PACKAGES=($PACKAGES)
KVERSION=${KVERSION:-$(uname -r)}
KSRC=${KSRC:-/lib/modules/${KVERSION}/build}
NETWORK_CONF_DIR=${NETWORK_CONF_DIR:-/etc/infiniband}
KERNEL_TREE_ROOT=${KSRC%*/*}

BUILD_ENV="env build_root=${build_root} STACK_PREFIX=${STACK_PREFIX} KVERSION=${KVERSION} KSRC=${KSRC} BUILD_MODULES=$BUILD_MODULES MEMTRACK=${MEMTRACK} NETWORK_CONF_DIR=${NETWORK_CONF_DIR} modprobe_update=${modprobe_update} include_ipoib_conf=${include_ipoib_conf}"

cd ${0%*/*}

TMPFILE=/tmp/$$.tmp
SOURCE_DIR=`pwd`
KERNEL=`uname -r | sed -e "s/\-/\_/g"`
OpenIB_DIR=${PWD##*/}
NAME="openib"
VERSION=`echo ${PWD##*/} | cut -d \- -f 2- | tr -s '-' '_'`
RELVER=`echo ${PWD##*/} | cut -d \- -f 2-`
BUILD_REQUIRES=""

# Check kernel sources existence
if ! test -d ${KSRC}; then
        echo In order to build RPM kernel sources need to be installed
        exit 1
fi

# Check dependencies
for pack in $BUILD_REQUIRES
do            
    if ! ( rpm -q $pack > /dev/null 2>&1 ); then
        echo In order to build RPM $pack need to be installed
        exit 1
    fi
done


# build_arch=`rpm --showrc | grep -w "build arch" | cut -d : -f 2 | tr -d " "`
build_arch=$(rpm --eval '%{_target_cpu}')
spec="openib.spec"

if [ ! -d ${RPM_DIR} ]; then
    mkdir -p $RPM_DIR/{BUILD,RPMS,SOURCES,SPECS,SRPMS}
fi

if [ -f $RPM_DIR/SPECS/$spec ]; then
        rm -f $RPM_DIR/SPECS/$spec 
fi

# Update Package name, version and release in the spec file
sed -e "s/XXXXXX/$VERSION/g" -e "s/YYYYYY/$NAME/g" -e "s/ZZZZZZ/$RELVER/g" $spec > $RPM_DIR/SPECS/$spec

cd ..
rm -f /tmp/${NAME}-${RELVER}.tgz
tar czvf /tmp/${NAME}-${RELVER}.tgz $OpenIB_DIR > /dev/null 2>&1
mv -f /tmp/${NAME}-${RELVER}.tgz $RPM_DIR/SOURCES/

if [ -f /etc/SuSE-release ]; then
   if [ `grep VERSION /etc/SuSE-release | cut -d = -f 2 | cut -d . -f 1 | tr -d '[:space:]'` -ge 9 ]; then
        $BUILD_ENV  PACKAGES="$PACKAGES" WITH_PACKAGES="${WITH_PACKAGES}" rpmbuild -ba --define "_topdir $RPM_DIR" $RPM_DIR/SPECS/$spec
   else 
        $BUILD_ENV  PACKAGES="$PACKAGES" WITH_PACKAGES="${WITH_PACKAGES}" rpm -ba --define "_topdir $RPM_DIR" $RPM_DIR/SPECS/$spec
   fi
elif [[ -f /etc/redhat-release || -f /etc/rocks-release ]]; then
        $BUILD_ENV PACKAGES="$PACKAGES" WITH_PACKAGES="${WITH_PACKAGES}" rpmbuild -ba --define "_topdir $RPM_DIR" $RPM_DIR/SPECS/$spec
else
        echo Build rpm on this system is not supported...
        exit 1
fi

if [ $? -ne 0 ]; then
    echo RPM building failed...
    exit 1
fi 

rm -f $RPM_DIR/SOURCES/$OpenIB_DIR.tgz
rm -f $RPM_DIR/SPECS/$spec

exit 0
