// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

#![cfg(unix)]

use hinawa_sys::*;
use std::env;
use std::error::Error;
use std::ffi::OsString;
use std::mem::{align_of, size_of};
use std::path::Path;
use std::process::Command;
use std::str;
use tempfile::Builder;

static PACKAGES: &[&str] = &["hinawa"];

#[derive(Clone, Debug)]
struct Compiler {
    pub args: Vec<String>,
}

impl Compiler {
    pub fn new() -> Result<Self, Box<dyn Error>> {
        let mut args = get_var("CC", "cc")?;
        args.push("-Wno-deprecated-declarations".to_owned());
        // For _Generic
        args.push("-std=c11".to_owned());
        // For %z support in printf when using MinGW.
        args.push("-D__USE_MINGW_ANSI_STDIO".to_owned());
        args.extend(get_var("CFLAGS", "")?);
        args.extend(get_var("CPPFLAGS", "")?);
        args.extend(pkg_config_cflags(PACKAGES)?);
        Ok(Self { args })
    }

    pub fn compile(&self, src: &Path, out: &Path) -> Result<(), Box<dyn Error>> {
        let mut cmd = self.to_command();
        cmd.arg(src);
        cmd.arg("-o");
        cmd.arg(out);
        let status = cmd.spawn()?.wait()?;
        if !status.success() {
            return Err(format!("compilation command {cmd:?} failed, {status}").into());
        }
        Ok(())
    }

    fn to_command(&self) -> Command {
        let mut cmd = Command::new(&self.args[0]);
        cmd.args(&self.args[1..]);
        cmd
    }
}

fn get_var(name: &str, default: &str) -> Result<Vec<String>, Box<dyn Error>> {
    match env::var(name) {
        Ok(value) => Ok(shell_words::split(&value)?),
        Err(env::VarError::NotPresent) => Ok(shell_words::split(default)?),
        Err(err) => Err(format!("{name} {err}").into()),
    }
}

fn pkg_config_cflags(packages: &[&str]) -> Result<Vec<String>, Box<dyn Error>> {
    if packages.is_empty() {
        return Ok(Vec::new());
    }
    let pkg_config = env::var_os("PKG_CONFIG").unwrap_or_else(|| OsString::from("pkg-config"));
    let mut cmd = Command::new(pkg_config);
    cmd.arg("--cflags");
    cmd.args(packages);
    let out = cmd.output()?;
    if !out.status.success() {
        return Err(format!("command {cmd:?} returned {}", out.status).into());
    }
    let stdout = str::from_utf8(&out.stdout)?;
    Ok(shell_words::split(stdout.trim())?)
}

#[derive(Copy, Clone, Debug, Eq, PartialEq)]
struct Layout {
    size: usize,
    alignment: usize,
}

#[derive(Copy, Clone, Debug, Default, Eq, PartialEq)]
struct Results {
    /// Number of successfully completed tests.
    passed: usize,
    /// Total number of failed tests (including those that failed to compile).
    failed: usize,
}

impl Results {
    fn record_passed(&mut self) {
        self.passed += 1;
    }
    fn record_failed(&mut self) {
        self.failed += 1;
    }
    fn summary(&self) -> String {
        format!("{} passed; {} failed", self.passed, self.failed)
    }
    fn expect_total_success(&self) {
        if self.failed == 0 {
            println!("OK: {}", self.summary());
        } else {
            panic!("FAILED: {}", self.summary());
        };
    }
}

#[test]
fn cross_validate_constants_with_c() {
    let mut c_constants: Vec<(String, String)> = Vec::new();

    for l in get_c_output("constant").unwrap().lines() {
        let (name, value) = l.split_once(';').expect("Missing ';' separator");
        c_constants.push((name.to_owned(), value.to_owned()));
    }

    let mut results = Results::default();

    for ((rust_name, rust_value), (c_name, c_value)) in
        RUST_CONSTANTS.iter().zip(c_constants.iter())
    {
        if rust_name != c_name {
            results.record_failed();
            eprintln!("Name mismatch:\nRust: {rust_name:?}\nC:    {c_name:?}");
            continue;
        }

        if rust_value != c_value {
            results.record_failed();
            eprintln!(
                "Constant value mismatch for {rust_name}\nRust: {rust_value:?}\nC:    {c_value:?}",
            );
            continue;
        }

        results.record_passed();
    }

    results.expect_total_success();
}

#[test]
fn cross_validate_layout_with_c() {
    let mut c_layouts = Vec::new();

    for l in get_c_output("layout").unwrap().lines() {
        let (name, value) = l.split_once(';').expect("Missing first ';' separator");
        let (size, alignment) = value.split_once(';').expect("Missing second ';' separator");
        let size = size.parse().expect("Failed to parse size");
        let alignment = alignment.parse().expect("Failed to parse alignment");
        c_layouts.push((name.to_owned(), Layout { size, alignment }));
    }

    let mut results = Results::default();

    for ((rust_name, rust_layout), (c_name, c_layout)) in RUST_LAYOUTS.iter().zip(c_layouts.iter())
    {
        if rust_name != c_name {
            results.record_failed();
            eprintln!("Name mismatch:\nRust: {rust_name:?}\nC:    {c_name:?}");
            continue;
        }

        if rust_layout != c_layout {
            results.record_failed();
            eprintln!("Layout mismatch for {rust_name}\nRust: {rust_layout:?}\nC:    {c_layout:?}",);
            continue;
        }

        results.record_passed();
    }

    results.expect_total_success();
}

fn get_c_output(name: &str) -> Result<String, Box<dyn Error>> {
    let tmpdir = Builder::new().prefix("abi").tempdir()?;
    let exe = tmpdir.path().join(name);
    let c_file = Path::new("tests").join(name).with_extension("c");

    let cc = Compiler::new().expect("configured compiler");
    cc.compile(&c_file, &exe)?;

    let mut abi_cmd = Command::new(exe);
    let output = abi_cmd.output()?;
    if !output.status.success() {
        return Err(format!("command {abi_cmd:?} failed, {output:?}").into());
    }

    Ok(String::from_utf8(output.stdout)?)
}

const RUST_LAYOUTS: &[(&str, Layout)] = &[
    (
        "HinawaFwFcp",
        Layout {
            size: size_of::<HinawaFwFcp>(),
            alignment: align_of::<HinawaFwFcp>(),
        },
    ),
    (
        "HinawaFwFcpClass",
        Layout {
            size: size_of::<HinawaFwFcpClass>(),
            alignment: align_of::<HinawaFwFcpClass>(),
        },
    ),
    (
        "HinawaFwFcpError",
        Layout {
            size: size_of::<HinawaFwFcpError>(),
            alignment: align_of::<HinawaFwFcpError>(),
        },
    ),
    (
        "HinawaFwNode",
        Layout {
            size: size_of::<HinawaFwNode>(),
            alignment: align_of::<HinawaFwNode>(),
        },
    ),
    (
        "HinawaFwNodeClass",
        Layout {
            size: size_of::<HinawaFwNodeClass>(),
            alignment: align_of::<HinawaFwNodeClass>(),
        },
    ),
    (
        "HinawaFwNodeError",
        Layout {
            size: size_of::<HinawaFwNodeError>(),
            alignment: align_of::<HinawaFwNodeError>(),
        },
    ),
    (
        "HinawaFwRcode",
        Layout {
            size: size_of::<HinawaFwRcode>(),
            alignment: align_of::<HinawaFwRcode>(),
        },
    ),
    (
        "HinawaFwReq",
        Layout {
            size: size_of::<HinawaFwReq>(),
            alignment: align_of::<HinawaFwReq>(),
        },
    ),
    (
        "HinawaFwReqClass",
        Layout {
            size: size_of::<HinawaFwReqClass>(),
            alignment: align_of::<HinawaFwReqClass>(),
        },
    ),
    (
        "HinawaFwReqError",
        Layout {
            size: size_of::<HinawaFwReqError>(),
            alignment: align_of::<HinawaFwReqError>(),
        },
    ),
    (
        "HinawaFwResp",
        Layout {
            size: size_of::<HinawaFwResp>(),
            alignment: align_of::<HinawaFwResp>(),
        },
    ),
    (
        "HinawaFwRespClass",
        Layout {
            size: size_of::<HinawaFwRespClass>(),
            alignment: align_of::<HinawaFwRespClass>(),
        },
    ),
    (
        "HinawaFwRespError",
        Layout {
            size: size_of::<HinawaFwRespError>(),
            alignment: align_of::<HinawaFwRespError>(),
        },
    ),
    (
        "HinawaFwTcode",
        Layout {
            size: size_of::<HinawaFwTcode>(),
            alignment: align_of::<HinawaFwTcode>(),
        },
    ),
];

const RUST_CONSTANTS: &[(&str, &str)] = &[
    ("(gint) HINAWA_FW_FCP_ERROR_ABORTED", "2"),
    ("(gint) HINAWA_FW_FCP_ERROR_LARGE_RESP", "1"),
    ("(gint) HINAWA_FW_FCP_ERROR_TIMEOUT", "0"),
    ("(gint) HINAWA_FW_NODE_ERROR_DISCONNECTED", "0"),
    ("(gint) HINAWA_FW_NODE_ERROR_FAILED", "3"),
    ("(gint) HINAWA_FW_NODE_ERROR_NOT_OPENED", "2"),
    ("(gint) HINAWA_FW_NODE_ERROR_OPENED", "1"),
    ("(gint) HINAWA_FW_RCODE_ADDRESS_ERROR", "7"),
    ("(gint) HINAWA_FW_RCODE_BUSY", "18"),
    ("(gint) HINAWA_FW_RCODE_CANCELLED", "17"),
    ("(gint) HINAWA_FW_RCODE_COMPLETE", "0"),
    ("(gint) HINAWA_FW_RCODE_CONFLICT_ERROR", "4"),
    ("(gint) HINAWA_FW_RCODE_DATA_ERROR", "5"),
    ("(gint) HINAWA_FW_RCODE_GENERATION", "19"),
    ("(gint) HINAWA_FW_RCODE_INVALID", "21"),
    ("(gint) HINAWA_FW_RCODE_NO_ACK", "20"),
    ("(gint) HINAWA_FW_RCODE_SEND_ERROR", "16"),
    ("(gint) HINAWA_FW_RCODE_TYPE_ERROR", "6"),
    ("(gint) HINAWA_FW_REQ_ERROR_ADDRESS_ERROR", "7"),
    ("(gint) HINAWA_FW_REQ_ERROR_BUSY", "18"),
    ("(gint) HINAWA_FW_REQ_ERROR_CANCELLED", "17"),
    ("(gint) HINAWA_FW_REQ_ERROR_CONFLICT_ERROR", "4"),
    ("(gint) HINAWA_FW_REQ_ERROR_DATA_ERROR", "5"),
    ("(gint) HINAWA_FW_REQ_ERROR_GENERATION", "19"),
    ("(gint) HINAWA_FW_REQ_ERROR_INVALID", "21"),
    ("(gint) HINAWA_FW_REQ_ERROR_NO_ACK", "20"),
    ("(gint) HINAWA_FW_REQ_ERROR_SEND_ERROR", "16"),
    ("(gint) HINAWA_FW_REQ_ERROR_TYPE_ERROR", "6"),
    ("(gint) HINAWA_FW_RESP_ERROR_ADDR_SPACE_USED", "2"),
    ("(gint) HINAWA_FW_RESP_ERROR_FAILED", "0"),
    ("(gint) HINAWA_FW_RESP_ERROR_RESERVED", "1"),
    ("(gint) HINAWA_FW_TCODE_CYCLE_START", "8"),
    ("(gint) HINAWA_FW_TCODE_LOCK_BOUNDED_ADD", "21"),
    ("(gint) HINAWA_FW_TCODE_LOCK_COMPARE_SWAP", "18"),
    ("(gint) HINAWA_FW_TCODE_LOCK_FETCH_ADD", "19"),
    ("(gint) HINAWA_FW_TCODE_LOCK_LITTLE_ADD", "20"),
    ("(gint) HINAWA_FW_TCODE_LOCK_MASK_SWAP", "17"),
    ("(gint) HINAWA_FW_TCODE_LOCK_REQUEST", "9"),
    ("(gint) HINAWA_FW_TCODE_LOCK_RESPONSE", "11"),
    ("(gint) HINAWA_FW_TCODE_LOCK_VENDOR_DEPENDENT", "23"),
    ("(gint) HINAWA_FW_TCODE_LOCK_WRAP_ADD", "22"),
    ("(gint) HINAWA_FW_TCODE_READ_BLOCK_REQUEST", "5"),
    ("(gint) HINAWA_FW_TCODE_READ_BLOCK_RESPONSE", "7"),
    ("(gint) HINAWA_FW_TCODE_READ_QUADLET_REQUEST", "4"),
    ("(gint) HINAWA_FW_TCODE_READ_QUADLET_RESPONSE", "6"),
    ("(gint) HINAWA_FW_TCODE_STREAM_DATA", "10"),
    ("(gint) HINAWA_FW_TCODE_WRITE_BLOCK_REQUEST", "1"),
    ("(gint) HINAWA_FW_TCODE_WRITE_QUADLET_REQUEST", "0"),
    ("(gint) HINAWA_FW_TCODE_WRITE_RESPONSE", "2"),
];
