#ifndef __LINUX_QUICKCAM_HDCS_H
#define __LINUX_QUICKCAM_HDCS_H

// I2C Address
#define HDCS_ADDR 			0xaa
 
// I2C Registers
#define HDCS_IDENT	 		0x00
#define HDCS_STATUS	 		0x02	// Status
#define HDCS_IMASK 			0x04	// Interrupt mask
#define HDCS_REG06 			0x06
#define HDCS_REG08 			0x08
#define HDCS_REG0A 			0x0a
#define HDCS_REG0C 			0x0c
#define HDCS_REG0E 			0x0e
 
#define HDCS_REG10 			0x10
#define HDCS_ADC_BITS 		0x12
 
#define HDCS_STARTY 		0x14
#define HDCS_STARTX 		0x16
#define HDCS_STOPY 			0x18
#define HDCS_STOPX 			0x1a
 
#define HDCS_INTEGRATE 		0x1c
 
#define HDCS_GAIN_GREEN1	0x1e
#define HDCS_GAIN_RED    	0x20
#define HDCS_GAIN_BLUE   	0x22
#define HDCS_GAIN_GREEN2	0x24
 
#define HDCS_SHUTTERL 		0x26
#define HDCS_SHUTTERH 		0x28
 
#define HDCS_REG2A  		0x2a
#define HDCS_REG2C  		0x2C

#define HDCS_CONFIG  		0x2E	// Configuration
#define HDCS20_CONFIG  		0x36	// Configuration for HDCS1020
#define HDCS_CONTROL 		0x30	// Control
#define HDCS20_CONTROL 		0x38	// Control for HDCS1020
 
#define HDCS_REG32  		0x32
#define HDCS_REG34  		0x34
#define HDCS_REG36  		0x36
#define HDCS_REG38  		0x38

#endif
