/*******************************************************************
 * This file is part of the Emulex Linux Device Driver for         *
 * Enterprise Fibre Channel Host Bus Adapters.                     *
 * Refer to the README file included with this package for         *
 * driver version and adapter support.                             *
 * Copyright (C) 2003 Emulex Corporation.                          *
 * www.emulex.com                                                  *
 *                                                                 *
 * This program is free software; you can redistribute it and/or   *
 * modify it under the terms of the GNU General Public License     *
 * as published by the Free Software Foundation; either version 2  *
 * of the License, or (at your option) any later version.          *
 *                                                                 *
 * This program is distributed in the hope that it will be useful, *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of  *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the   *
 * GNU General Public License for more details, a copy of which    *
 * can be found in the file COPYING included with this package.    *
 *******************************************************************/

#ifndef _H_CFGPARAM
#define _H_CFGPARAM

#define LPFC_DFT_POST_IP_BUF            128
#define LPFC_MIN_POST_IP_BUF            64
#define LPFC_MAX_POST_IP_BUF            1024
#define LPFC_DFT_XMT_QUE_SIZE           256
#define LPFC_MIN_XMT_QUE_SIZE           128
#define LPFC_MAX_XMT_QUE_SIZE           10240
#define LPFC_DFT_NUM_IOCBS              1024
#define LPFC_MIN_NUM_IOCBS              128
#define LPFC_MAX_NUM_IOCBS              10240
#define LPFC_DFT_NUM_BUFS               1024
#define LPFC_MIN_NUM_BUFS               64
#define LPFC_MAX_NUM_BUFS               4096
#define LPFC_DFT_NUM_NODES              510
#define LPFC_MIN_NUM_NODES              64
#define LPFC_MAX_NUM_NODES              4096
#define LPFC_DFT_TOPOLOGY               0
#define LPFC_DFT_FC_CLASS               3

#define LPFC_DFT_NO_DEVICE_DELAY        1        /* 1 sec */
#define LPFC_MAX_NO_DEVICE_DELAY        30       /* 30 sec */
#define LPFC_DFT_FABRIC_TIMEOUT         0       
#define LPFC_MAX_FABRIC_TIMEOUT         255      /* 255 sec */
#define LPFC_DFT_LNKDWN_TIMEOUT         30      
#define LPFC_MAX_LNKDWN_TIMEOUT         255      /* 255 sec */
#define LPFC_DFT_NODEV_TIMEOUT          0      
#define LPFC_MAX_NODEV_TIMEOUT          255      /* 255 sec */
#define LPFC_DFT_RSCN_NS_DELAY          0      
#define LPFC_MAX_RSCN_NS_DELAY          255      /* 255 sec */

#define LPFC_MAX_TGT_Q_DEPTH            10240   /* max cmds allowed per tgt */
#define LPFC_DFT_TGT_Q_DEPTH            0       /* default max cmds per tgt */

#define LPFC_MAX_LUN_Q_DEPTH            128     /* max cmds to allow per lun */
#define LPFC_DFT_LUN_Q_DEPTH            30      /* default max cmds per lun */

#define LPFC_MAX_DQFULL_THROTTLE        1       /* Boolean (max value) */

#define CFG_INTR_ACK            0       /* intr-ack */
#define CFG_LOG_VERBOSE         1       /* log-verbose */
#define CFG_LOG_ONLY            2       /* log-only */
#define CFG_IDENTIFY_SELF       3       /* identify-self */
#define CFG_NUM_IOCBS           4       /* num-iocbs */
#define CFG_NUM_BUFS            5       /* num-bufs */
#define CFG_FCP_ON              6       /* fcp-on */
#define CFG_DEVICE_REPORT       7       /* device-report */
#define CFG_AUTOMAP             8       /* automap */
#define CFG_DFT_TGT_Q_DEPTH     9       /* tgt_queue_depth */
#define CFG_DFT_LUN_Q_DEPTH     10      /* lun_queue_depth */
#define CFG_FIRST_CHECK         11      /* first-check */
#define CFG_FCPFABRIC_TMO       12      /* fcpfabric-tmo */
#define CFG_FCP_CLASS           13      /* fcp-class */
#define CFG_USE_ADISC           14      /* use-adisc */
#define CFG_NO_DEVICE_DELAY     15      /* no-device-delay */
#define CFG_NETWORK_ON          16      /* network-on */
#define CFG_POST_IP_BUF         17      /* post-ip-buf */
#define CFG_XMT_Q_SIZE          18      /* xmt-que-size */
#define CFG_IP_CLASS            19      /* ip-class */
#define CFG_ACK0                20      /* ack0 */
#define CFG_TOPOLOGY            21      /* topology */
#define CFG_SCAN_DOWN           22      /* scan-down */
#define CFG_LINKDOWN_TMO        23      /* linkdown-tmo */
#define CFG_USE_LOMEM           24      /* use-lomempages */
#define CFG_ZONE_RSCN           25      /* zone-rscn */
#define CFG_HOLDIO              26      /* nodev-holdio */
#define CFG_DELAY_RSP_ERR       27      /* delay-rsp-err */
#define CFG_CHK_COND_ERR        28      /* check-cond-err */
#define CFG_NODEV_TMO           29      /* nodev-tmo */
#define CFG_DQFULL_THROTTLE     30      /* dqfull-throttle */
#define CFG_LINK_SPEED          31      /* link-speed NEW_FETURE */
#define CFG_QFULL_RSP_ERR       32      /* qfull-rsp-err */
#define CFG_DQFULL_THROTTLE_UP_TIME 33  /* dqfull-throttle-up-time */
#define CFG_DQFULL_THROTTLE_UP_INC  34  /* dqfull-throttle-up-inc */
#define CFG_NUM_NODES           35      /* num-nodes */
#define CFG_CR_DELAY            36      /* cr-delay */
#define CFG_CR_COUNT            37      /* cr-count */
#define NUM_CFG_PARAM           38

#ifdef DEF_ICFG
_static_ iCfgParam icfgparam[NUM_CFG_PARAM] = {

   /* general driver parameters */
   { "intr-ack",
    0, 1, TRUE, 0,
    (ushort)0,
    (ushort)CFG_DYNAMIC,
   "Claim interrupt even if no work discovered" },

   { "log-verbose",
    0, 0xffff,  FALSE, 0,
    (ushort)0,
    (ushort)CFG_DYNAMIC,
   "Verbose logging mask" },

   { "log-only",
    0, 2,  TRUE, 0,
    (ushort)0,
    (ushort)CFG_DYNAMIC,
   "Log messages only go to system logger, not console" },

   { "identify-self",
    0, 2,  TRUE, 0,
    (ushort)0,
    (ushort)CFG_REBOOT,
   "Driver startup will report driver version and release information" },

   { "num-iocbs",
    LPFC_MIN_NUM_IOCBS, LPFC_MAX_NUM_IOCBS, LPFC_DFT_NUM_IOCBS, 0,
    (ushort)0,
    (ushort)CFG_RESTART,
   "Number of outstanding IOCBs driver can queue to adapter" },

   { "num-bufs",
    LPFC_MIN_NUM_BUFS, LPFC_MAX_NUM_BUFS, LPFC_DFT_NUM_BUFS, 0,
    (ushort)0,
    (ushort)CFG_RESTART,
   "Number of buffers driver uses for ELS commands and Buffer Pointer Lists." },

   /* FCP specific parameters */
   { "fcp-on",
    0, 1, TRUE, 0,
    (ushort)0,
    (ushort)CFG_REBOOT,
   "Enable FCP processing" },

   { "device-report",
    0, 1,  TRUE, 0,
    (ushort)0,
    (ushort)CFG_RESTART,
   "Driver will report FCP devices as it finds them" },

   { "automap",
    0, 3, 2, 0,
    (ushort)0,
    (ushort)CFG_RESTART,
   "Automatically bind FCP devices as they are discovered" },

   { "tgt-queue-depth",
    0, LPFC_MAX_TGT_Q_DEPTH, LPFC_DFT_TGT_Q_DEPTH, 0,
    (ushort)0,
    (ushort)CFG_RESTART,
   "Max number of FCP commands we can queue to a specific target" },

   { "lun-queue-depth",
    0, LPFC_MAX_LUN_Q_DEPTH, LPFC_DFT_LUN_Q_DEPTH, 0,
    (ushort)0,
    (ushort)CFG_RESTART,
   "Max number of FCP commands we can queue to a specific LUN" },

   { "first-check",
    0, 1, 
          FALSE,
          0,
    (ushort)0,
    (ushort)CFG_DYNAMIC,
   "Retry the first 29xx check condition for FCP devices during discovery" },

   { "fcpfabric-tmo",
    0, LPFC_MAX_FABRIC_TIMEOUT, LPFC_DFT_FABRIC_TIMEOUT, 0,
    (ushort)0,
    (ushort)CFG_DYNAMIC,
   "Extra FCP command timeout when connected to a fabric" },

   { "fcp-class",
    2, 3,  LPFC_DFT_FC_CLASS, 0,
    (ushort)0,
    (ushort)CFG_DYNAMIC,
   "Select Fibre Channel class of service for FCP sequences" },

   { "use-adisc",
    0, 1, FALSE, 0,
    (ushort)0,
    (ushort)CFG_DYNAMIC,
   "Use ADISC on rediscovery to authenticate FCP devices" },

   { "no-device-delay",
    0, LPFC_MAX_NO_DEVICE_DELAY, LPFC_DFT_NO_DEVICE_DELAY, 0,
    (ushort)0,
    (ushort)CFG_DYNAMIC,
   "No FCP device failed I/O sec delay" },

   /* IP specific parameters */
   { "network-on",
    0, 1, FALSE, 0,
    (ushort)0,
    (ushort)CFG_REBOOT,
   "Enable IP processing" },

   { "post-ip-buf",
    LPFC_MIN_POST_IP_BUF, LPFC_MAX_POST_IP_BUF, LPFC_DFT_POST_IP_BUF, 0,
    (ushort)0,
    (ushort)CFG_RESTART,
   "Number of IP buffers to post to adapter" },

   { "xmt-que-size",
    LPFC_MIN_XMT_QUE_SIZE, LPFC_MAX_XMT_QUE_SIZE, LPFC_DFT_XMT_QUE_SIZE, 0,
    (ushort)0,
    (ushort)CFG_RESTART,
   "Number of outstanding IP cmds for an adapter" },

   { "ip-class",
    2, 3,  LPFC_DFT_FC_CLASS, 0,
    (ushort)0,
    (ushort)CFG_DYNAMIC,
   "Select Fibre Channel class of service for IP sequences" },

   /* Fibre Channel specific parameters */
   { "ack0",
    0,  1,  FALSE, 0,
    (ushort)0,
    (ushort)CFG_RESTART,
   "Enable ACK0 support" },

   { "topology",
    0, 6,  LPFC_DFT_TOPOLOGY, 0,
    (ushort)0,
    (ushort)CFG_RESTART,
   "Select Fibre Channel topology" },

   { "scan-down",
    0,  2,  2, 0,
    (ushort)0,
    (ushort)CFG_DYNAMIC,
   "Start scanning for devices from highest ALPA to lowest" },

   { "linkdown-tmo",
    0, LPFC_MAX_LNKDWN_TIMEOUT, LPFC_DFT_LNKDWN_TIMEOUT, 0,
    (ushort)0,
    (ushort)CFG_DYNAMIC,
   "Seconds driver will wait before deciding link is really down" },

   { "use-lomempages",
    0, 1, FALSE, 0,
    (ushort)0,
    (ushort)CFG_RESTART,
   "Use low memory for adapter DMA buffers" },

   { "zone-rscn",
    0,  1,  FALSE, 0,
    (ushort)0,
    (ushort)CFG_DYNAMIC,
   "Force RSCNs to always check NameServer for N_Port IDs" },

   { "nodev-holdio",
    0,  1,  FALSE, 0,
    (ushort)0,
    (ushort)CFG_DYNAMIC,
   "Hold I/O errors if device disappears " },

   { "delay-rsp-err",
    0, 1, FALSE, 0,
    (ushort)0,
    (ushort)CFG_DYNAMIC,
   "Delay FCP error return for FCP RSP error and Check Condition" },

   { "check-cond-err",
    0, 1, FALSE, 0,
    (ushort)0,
    (ushort)CFG_DYNAMIC,
   "Treat special Check Conditions as a FCP error" },

   { "nodev-tmo",
    0, LPFC_MAX_NODEV_TIMEOUT, LPFC_DFT_NODEV_TIMEOUT, 0,
    (ushort)0,
    (ushort)CFG_DYNAMIC,
   "Seconds driver will hold I/O waiting for a device to come back" },

   { "dqfull-throttle",
    0, 1, 1, 0,
    (ushort)0,
    (ushort)CFG_DYNAMIC,
   "Decrement LUN throttle on a queue full condition" },

   { "link-speed",
    0, 2, 0, 0,
    (ushort)0,
    (ushort)CFG_RESTART,
   "Select link speed" },

   { "qfull-rsp-err",
    0, 1, FALSE, 0,
    (ushort)0,
    (ushort)CFG_DYNAMIC,
   "Return BUSY (default) or TERMINATED as SCSI status on a queue full condition" },

   { "dqfull-throttle-up-time",
    0, 30, 1, 0,
    (ushort)0,
    (ushort)CFG_RESTART,
   "When to increment the current Q depth " },

   { "dqfull-throttle-up-inc",
    0, LPFC_MAX_LUN_Q_DEPTH, 1, 0,
    (ushort)0,
    (ushort)CFG_RESTART,
   "Increment the current Q depth by dqfull-throttle-up-inc" },

   { "num-nodes",
    LPFC_MIN_NUM_NODES, LPFC_MAX_NUM_NODES, LPFC_DFT_NUM_NODES, 0,
    (ushort)0,
    (ushort)CFG_RESTART,
   "Number of fibre channel nodes (NPorts) the driver will support." },

   { "cr-delay",
    0, 63, 0, 0,
    (ushort)0,
    (ushort)CFG_RESTART,
   "A count of milliseconds after which an interrupt response is generated" },

   { "cr-count",
    1, 255, 0, 0,
    (ushort)0,
    (ushort)CFG_RESTART,
   "A count of I/O completions after which an interrupt response is generated" },

   };
#endif /* DEF_ICFG */

#endif /* _H_CFGPARAM */
