/*
 * memmap support for the proc filesystem
 * (-> /proc/memmap)
 *
 * written by Nico Schmoigl, nico@writemail.com, 2000
 * 
 * Updates:
 * 
 */

#include <linux/mm.h>
#include <linux/bootmem.h>
#include <linux/kernel.h>
#include <asm/uaccess.h>
#include <linux/proc_fs.h>

const int maxlines = 30, maxchars = 116;
static long frompage = 0, topage = 0;

int memmap_read_proc (char *buf, char **start, off_t off, int count, int *eof, void *data)
{
   char *dat = buf;
   char line[maxchars+1];
   int len = 0, totallen = 0, dotconst = (topage-frompage)/maxlines/maxchars;
   register int i = 0, k = 0, j = 0, offset = 0;
   
   if (dotconst == 0)
     dotconst = 1;

   len = sprintf (dat, "1 char <=> %u pages\nShowing pages #%li - #%li\n\n", dotconst,frompage,topage);
   totallen += len;
   dat += len;

   
   offset = frompage;
   
   for (j = 0; j < maxlines; j++) {
      for (k = 0; k < maxchars; k++) {
	 char dot = '.';

	 if (offset > max_low_pfn)
	   break;
	 
	 for (i = offset; i < dotconst+offset; i++) {
	    
	    if (i > max_low_pfn)
	      break;
	      
	    if (dot == 'B') continue;
#ifdef CONFIG_BADMEM		 
	    if (PageBad(mem_map+i)) {
	       dot = 'B';
	       continue;
	    }
#endif /* CONFIG_BADMEM */		 
	 
	    if (dot == 'R') continue;
	    if (PageReserved(mem_map+i)) {   
	       dot = 'R';
	       continue;
	    }
	 
	    if (dot == '*') continue;
	 
	    if (atomic_read(&mem_map[i].count)) {
	       dot = '*';
	       continue;
	    }
	 
	 }
	 offset += dotconst;
	 line[k] = dot;
	 
      }
      line[maxchars] = 0;
      len = sprintf (dat, "#%5i: %s\n", offset, line);
      totallen += len;
      dat += len;
      
   }

   len = sprintf (dat, "\nLegend: 'B' at least one Bad\t'R' at least one Reserved\t'*' used\t'.' all unused\n");
   totallen += len;
   dat += len;
   
   *eof = 1;
   *start = buf+off;
   totallen -= off;
   
   return totallen;
   
}

int memmap_write_proc (struct file *file, const char *buffer, unsigned long count, void *data) {
   char gtest[100];
   long from = 0, to = 0;
   char *tmp, *ptr = gtest;

   copy_from_user(&gtest, buffer, count);
   tmp = strchr (gtest, ' ');
   if (tmp == 0)
     return -EINVAL;
   
   *tmp = 0;
   tmp++;

   from = simple_strtol(gtest, &ptr, 10);
   to = simple_strtol(tmp, &tmp, 10);
   
   if (to < from)
     return EINVAL;

   if (from > max_low_pfn)
     return EINVAL;
   
   if (to > max_low_pfn)
     to = max_low_pfn;
   
   frompage = from;
   topage = to;
   
   return count;
}

static int __init memmap_proc_init(void) {
   struct proc_dir_entry *pde = create_proc_entry ("memmap", S_IWUSR | S_IRUSR, NULL);
   
   if (pde) {
      pde->read_proc = memmap_read_proc;
      pde->write_proc = memmap_write_proc;
   }
   
   topage = max_low_pfn;
   
   
   return 0;
   
}

__initcall(memmap_proc_init);
