#ifndef __LINUX_QUICKCAM_PB0100_H
#define __LINUX_QUICKCAM_PB0100_H

// I2C Address
#define PB_ADDR 			0xba
 
// I2C Registers
#define PB_IDENT			0	// Identification
#define PB_RSTART         	1 	// First row
#define PB_CSTART         	2 	// First column
#define PB_RWSIZE         	3 	// Row window size
#define PB_CWSIZE         	4 	// Col window size
#define PB_CFILLIN        	5 	// Col fill-in
#define PB_VBL            	6 	// Vertical blank count
#define PB_CONTROL        	7 	// Control Mode
#define PB_FINTTIME       	8 	// Frame integration time
#define PB_RINTTIME       	9 	// Row frame integration time
#define PB_ROWSPEED      	10	// Row speed control
#define PB_ABORTFRAME    	11 	// Abort Frame.
#define PB_RESET         	13 	// Hard reset.
#define PB_EXPGAIN       	14 	// Exposure Gain Command.
#define PB_UPDATEINT     	23 	// Auto-exposure update interval.
#define PB_PREADCTRL     	32 	// Pixel Read Control Mode.
#define PB_G1GAIN        	43 	// Green gain
#define PB_BGAIN         	44 	// Blue gain
#define PB_RGAIN         	45 	// Red gain.
#define PB_G2GAIN        	46 	// Greeb gain (one line is RG the other BG).
#define PB_ADCMAXGAIN   	51 	// Max gain for auto-exposure.
#define PB_ADCMINGAIN    	52 	// Min gain for auto-exposure.
#define PB_ADCGLOBALGAIN 	53 	// Global gain (copied in G1,G2,B and R).
#define PB_VOFFSET       	57 	// Voltage offset.
#define PB_ADCGAINH      	59 	// high ref.
#define PB_ADCGAINL      	60 	// low ref.
 
 /*
  * The spec file for the PB-0100 suggests the following for best quality
  * images after the sensor has been reset :
  *
  * R60 = 0x03 (3 dec)      : sets low reference of ADC to produce good black level
  * R32 = 0x1400 (5120 dec) : Enables global gain changes through R53
  * R52 = 0x10 (16 dec)     : Sets the minimum gain for auto-exposure
  * R53 = 0x10 (16 dec)     : Sets the global gain
  * R14 = 0x11 (17 dec)     : Sets the auto-exposure value
  * R23 = 0x02 (2 dec)      : Sets the speed on auto-exposure routine
  * R5 = 0x0e (14 dec)      : Sets the frame rate
  */

#endif
