// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/bigquery/datapolicies/v1/datapolicy.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BIGQUERY_DATAPOLICIES_V1_MOCKS_MOCK_DATA_POLICY_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BIGQUERY_DATAPOLICIES_V1_MOCKS_MOCK_DATA_POLICY_CONNECTION_H

#include "google/cloud/bigquery/datapolicies/v1/data_policy_connection.h"
#include <gmock/gmock.h>

namespace google {
namespace cloud {
namespace bigquery_datapolicies_v1_mocks {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

/**
 * A class to mock `DataPolicyServiceConnection`.
 *
 * Application developers may want to test their code with simulated responses,
 * including errors, from an object of type `DataPolicyServiceClient`. To do so,
 * construct an object of type `DataPolicyServiceClient` with an instance of
 * this class. Then use the Google Test framework functions to program the
 * behavior of this mock.
 *
 * @see [This example][bq-mock] for how to test your application with GoogleTest.
 * While the example showcases types from the BigQuery library, the underlying
 * principles apply for any pair of `*Client` and `*Connection`.
 *
 * [bq-mock]: @cloud_cpp_docs_link{bigquery,bigquery-read-mock}
 */
class MockDataPolicyServiceConnection
    : public bigquery_datapolicies_v1::DataPolicyServiceConnection {
 public:
  MOCK_METHOD(Options, options, (), (override));

  MOCK_METHOD(
      StatusOr<google::cloud::bigquery::datapolicies::v1::DataPolicy>,
      CreateDataPolicy,
      (google::cloud::bigquery::datapolicies::v1::CreateDataPolicyRequest const&
           request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::bigquery::datapolicies::v1::DataPolicy>,
      UpdateDataPolicy,
      (google::cloud::bigquery::datapolicies::v1::UpdateDataPolicyRequest const&
           request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::bigquery::datapolicies::v1::DataPolicy>,
      RenameDataPolicy,
      (google::cloud::bigquery::datapolicies::v1::RenameDataPolicyRequest const&
           request),
      (override));

  MOCK_METHOD(
      Status, DeleteDataPolicy,
      (google::cloud::bigquery::datapolicies::v1::DeleteDataPolicyRequest const&
           request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::bigquery::datapolicies::v1::DataPolicy>,
      GetDataPolicy,
      (google::cloud::bigquery::datapolicies::v1::GetDataPolicyRequest const&
           request),
      (override));

  MOCK_METHOD(
      (StreamRange<google::cloud::bigquery::datapolicies::v1::DataPolicy>),
      ListDataPolicies,
      (google::cloud::bigquery::datapolicies::v1::ListDataPoliciesRequest
           request),
      (override));

  MOCK_METHOD(StatusOr<google::iam::v1::Policy>, GetIamPolicy,
              (google::iam::v1::GetIamPolicyRequest const& request),
              (override));

  MOCK_METHOD(StatusOr<google::iam::v1::Policy>, SetIamPolicy,
              (google::iam::v1::SetIamPolicyRequest const& request),
              (override));

  MOCK_METHOD(StatusOr<google::iam::v1::TestIamPermissionsResponse>,
              TestIamPermissions,
              (google::iam::v1::TestIamPermissionsRequest const& request),
              (override));
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace bigquery_datapolicies_v1_mocks
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BIGQUERY_DATAPOLICIES_V1_MOCKS_MOCK_DATA_POLICY_CONNECTION_H
