
#include <tests/vala-demo/tinymail-vala-test.h>
#include <tny-gtk-msg-view.h>
#include <tny.h>
#include <tnyui.h>
#include <tny-gtk-header-list-model.h>
#include <stdlib.h>
#include <string.h>
#include <tny-gnome-platform-factory.h>
#include <tny-gtk-folder-store-tree-model.h>
#include <string.h>

struct _TnyValaMailWindowPrivate {
	TnyGtkMsgView* msgview;
	GtkTreeView* headerlist;
	GtkProgressBar* progressbar;
};
#define TNY_VALA_MAIL_WINDOW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TNY_TYPE_VALA_MAIL_WINDOW, TnyValaMailWindowPrivate))
enum  {
	TNY_VALA_MAIL_WINDOW_DUMMY_PROPERTY
};
static void tny_vala_mail_window_on_folder_selected (GtkTreeSelection* treeselection, TnyValaMailWindow* self);
static void tny_vala_mail_window_on_message_selected (GtkTreeSelection* treeselection, TnyValaMailWindow* self);
static void tny_vala_mail_window_on_refresh_folder (TnyFolder* folder, gboolean cancelled, GError* err, TnyValaMailWindow* self);
static void tny_vala_mail_window_on_status (GObject* obj, TnyStatus* status, TnyValaMailWindow* self);
static void tny_vala_mail_window_main (int args_length1, char** args);
static GObject * tny_vala_mail_window_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer tny_vala_mail_window_parent_class = NULL;
static void tny_vala_mail_window_dispose (GObject * obj);


TnyValaMailWindow* tny_vala_mail_window_new (void) {
	TnyValaMailWindow * self;
	self = g_object_newv (TNY_TYPE_VALA_MAIL_WINDOW, 0, NULL);
	gtk_window_set_title (GTK_WINDOW (self), "Vala Mail Demo");
	return self;
}


static void tny_vala_mail_window_on_folder_selected (GtkTreeSelection* treeselection, TnyValaMailWindow* self) {
	GtkTreeModel* model;
	GtkTreeIter iter;
	TnyFolderType folder_type;
	GObject* folder_instance;
	g_return_if_fail (TNY_IS_VALA_MAIL_WINDOW (self));
	g_return_if_fail (treeselection == NULL || GTK_IS_TREE_SELECTION (treeselection));
	model = NULL;
	memset (&iter, 0, sizeof (GtkTreeIter));
	gtk_tree_selection_get_selected (treeselection, &model, &iter);
	folder_instance = NULL;
	gtk_tree_model_get (model, &iter, TNY_GTK_FOLDER_STORE_TREE_MODEL_TYPE_COLUMN, &folder_type, TNY_GTK_FOLDER_STORE_TREE_MODEL_INSTANCE_COLUMN, &folder_instance, -1);
	if (folder_type != TNY_FOLDER_TYPE_ROOT) {
		TnyFolder* _tmp0;
		TnyFolder* folder;
		_tmp0 = NULL;
		folder = (_tmp0 = TNY_FOLDER (folder_instance), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
		gtk_widget_show (GTK_WIDGET (self->priv->progressbar));
		tny_folder_refresh_async (folder, ((TnyFolderCallback) tny_vala_mail_window_on_refresh_folder), ((TnyStatusCallback) tny_vala_mail_window_on_status), ((gpointer) self));
		(folder == NULL ? NULL : (folder = (g_object_unref (folder), NULL)));
	}
	(folder_instance == NULL ? NULL : (folder_instance = (g_object_unref (folder_instance), NULL)));
}


static void tny_vala_mail_window_on_message_selected (GtkTreeSelection* treeselection, TnyValaMailWindow* self) {
	GError * inner_error;
	GtkTreeModel* model;
	GtkTreeIter iter;
	g_return_if_fail (TNY_IS_VALA_MAIL_WINDOW (self));
	g_return_if_fail (treeselection == NULL || GTK_IS_TREE_SELECTION (treeselection));
	inner_error = NULL;
	model = NULL;
	memset (&iter, 0, sizeof (GtkTreeIter));
	if (gtk_tree_selection_get_selected (treeselection, &model, &iter)) {
		TnyHeader* header;
		TnyFolder* _tmp0;
		TnyFolder* folder;
		TnyMsg* _tmp1;
		TnyMsg* msg;
		header = NULL;
		gtk_tree_model_get (model, &iter, TNY_GTK_HEADER_LIST_MODEL_INSTANCE_COLUMN, &header, -1);
		_tmp0 = NULL;
		folder = (_tmp0 = tny_header_get_folder (header), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
		_tmp1 = NULL;
		msg = (_tmp1 = tny_folder_get_msg (folder, header, &inner_error), (_tmp1 == NULL ? NULL : g_object_ref (_tmp1)));
		if (inner_error != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
			g_clear_error (&inner_error);
		}
		tny_msg_view_set_msg (((TnyMsgView*) self->priv->msgview), msg);
		(header == NULL ? NULL : (header = (g_object_unref (header), NULL)));
		(folder == NULL ? NULL : (folder = (g_object_unref (folder), NULL)));
		(msg == NULL ? NULL : (msg = (g_object_unref (msg), NULL)));
	}
}


static void tny_vala_mail_window_on_refresh_folder (TnyFolder* folder, gboolean cancelled, GError* err, TnyValaMailWindow* self) {
	TnyGtkHeaderListModel* listm;
	g_return_if_fail (TNY_IS_VALA_MAIL_WINDOW (self));
	g_return_if_fail (folder == NULL || TNY_IS_FOLDER (folder));
	listm = tny_gtk_header_list_model_new ();
	tny_gtk_header_list_model_set_folder (listm, folder, FALSE, NULL, NULL, NULL);
	gtk_tree_view_set_model (self->priv->headerlist, GTK_TREE_MODEL (listm));
	gtk_widget_hide (GTK_WIDGET (self->priv->progressbar));
	(listm == NULL ? NULL : (listm = (g_object_unref (listm), NULL)));
}


static void tny_vala_mail_window_on_status (GObject* obj, TnyStatus* status, TnyValaMailWindow* self) {
	g_return_if_fail (TNY_IS_VALA_MAIL_WINDOW (self));
	g_return_if_fail (obj == NULL || G_IS_OBJECT (obj));
	gtk_progress_bar_pulse (self->priv->progressbar);
}


static void tny_vala_mail_window_main (int args_length1, char** args) {
	TnyValaMailWindow* win;
	gtk_init (&args_length1, &args);
	win = g_object_ref_sink (tny_vala_mail_window_new ());
	gtk_widget_show_all (GTK_WIDGET (win));
	gtk_main ();
	(win == NULL ? NULL : (win = (g_object_unref (win), NULL)));
}


int main (int argc, char ** argv) {
	g_type_init ();
	tny_vala_mail_window_main (argc, argv);
	return 0;
}


static GObject * tny_vala_mail_window_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	TnyValaMailWindowClass * klass;
	GObjectClass * parent_class;
	TnyValaMailWindow * self;
	klass = TNY_VALA_MAIL_WINDOW_CLASS (g_type_class_peek (TNY_TYPE_VALA_MAIL_WINDOW));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = TNY_VALA_MAIL_WINDOW (obj);
	{
		GtkCellRenderer* renderer;
		GtkTreeViewColumn* column;
		TnyPlatformFactory* _tmp0;
		TnyPlatformFactory* platfact;
		TnyAccountStore* _tmp1;
		TnyAccountStore* account_store;
		TnyDevice* _tmp2;
		TnyDevice* device;
		GtkHPaned* hpaned;
		GtkScrolledWindow* _tmp3;
		GtkScrolledWindow* foldertree_scrolled;
		GtkTreeView* foldertree;
		GtkCellRenderer* _tmp4;
		GtkTreeViewColumn* _tmp5;
		TnyFolderStoreQuery* query;
		TnyGtkFolderStoreTreeModel* accounts;
		GtkVPaned* vpaned;
		GtkVBox* vbox;
		GtkScrolledWindow* _tmp6;
		GtkScrolledWindow* headerlist_scrolled;
		GtkTreeView* _tmp7;
		GtkProgressBar* _tmp8;
		GtkCellRenderer* _tmp9;
		GtkTreeViewColumn* _tmp10;
		GtkCellRenderer* _tmp11;
		GtkTreeViewColumn* _tmp12;
		GtkCellRenderer* _tmp13;
		GtkTreeViewColumn* _tmp14;
		TnyGtkMsgView* _tmp15;
		renderer = NULL;
		column = NULL;
		/* initialize Tinymail*/
		_tmp0 = NULL;
		platfact = (_tmp0 = tny_gnome_platform_factory_get_instance (), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
		_tmp1 = NULL;
		account_store = (_tmp1 = tny_platform_factory_new_account_store (platfact), (_tmp1 == NULL ? NULL : g_object_ref (_tmp1)));
		_tmp2 = NULL;
		device = (_tmp2 = tny_account_store_get_device (account_store), (_tmp2 == NULL ? NULL : g_object_ref (_tmp2)));
		tny_device_force_online (device);
		hpaned = g_object_ref_sink (gtk_hpaned_new ());
		gtk_container_add (GTK_CONTAINER (self), GTK_WIDGET (hpaned));
		/* create scrollable folder tree*/
		_tmp3 = NULL;
		foldertree_scrolled = g_object_ref_sink ((_tmp3 = gtk_scrolled_window_new (NULL, NULL), g_object_set (_tmp3, "hscrollbar-policy", GTK_POLICY_AUTOMATIC, NULL), g_object_set (_tmp3, "vscrollbar-policy", GTK_POLICY_AUTOMATIC, NULL), _tmp3));
		gtk_paned_pack1 (GTK_PANED (hpaned), GTK_WIDGET (foldertree_scrolled), FALSE, TRUE);
		foldertree = g_object_ref_sink (gtk_tree_view_new ());
		gtk_container_add (GTK_CONTAINER (foldertree_scrolled), GTK_WIDGET (foldertree));
		_tmp4 = NULL;
		renderer = (_tmp4 = GTK_CELL_RENDERER (g_object_ref_sink (gtk_cell_renderer_text_new ())), (renderer == NULL ? NULL : (renderer = (g_object_unref (renderer), NULL))), _tmp4);
		_tmp5 = NULL;
		column = (_tmp5 = g_object_ref_sink (gtk_tree_view_column_new_with_attributes ("Folder", renderer, "text", TNY_GTK_FOLDER_STORE_TREE_MODEL_NAME_COLUMN, NULL)), (column == NULL ? NULL : (column = (g_object_unref (column), NULL))), _tmp5);
		gtk_tree_view_column_set_fixed_width (column, 100);
		gtk_tree_view_column_set_sizing (column, GTK_TREE_VIEW_COLUMN_FIXED);
		gtk_tree_view_append_column (foldertree, column);
		/* add all subscribed folders to tree*/
		query = tny_folder_store_query_new ();
		tny_folder_store_query_add_item (query, "", TNY_FOLDER_STORE_QUERY_OPTION_SUBSCRIBED);
		accounts = tny_gtk_folder_store_tree_model_new (query);
		tny_account_store_get_accounts (account_store, ((TnyList*) accounts), TNY_ACCOUNT_STORE_STORE_ACCOUNTS);
		gtk_tree_view_set_model (foldertree, GTK_TREE_MODEL (accounts));
		vpaned = g_object_ref_sink (gtk_vpaned_new ());
		gtk_paned_pack2 (GTK_PANED (hpaned), GTK_WIDGET (vpaned), TRUE, TRUE);
		vbox = g_object_ref_sink (gtk_vbox_new (FALSE, 0));
		gtk_paned_pack1 (GTK_PANED (vpaned), GTK_WIDGET (vbox), TRUE, TRUE);
		/* create scrollable header list*/
		_tmp6 = NULL;
		headerlist_scrolled = g_object_ref_sink ((_tmp6 = gtk_scrolled_window_new (NULL, NULL), g_object_set (_tmp6, "hscrollbar-policy", GTK_POLICY_AUTOMATIC, NULL), g_object_set (_tmp6, "vscrollbar-policy", GTK_POLICY_AUTOMATIC, NULL), _tmp6));
		gtk_box_pack_start (GTK_BOX (vbox), GTK_WIDGET (headerlist_scrolled), TRUE, TRUE, 0);
		_tmp7 = NULL;
		self->priv->headerlist = (_tmp7 = g_object_ref_sink (gtk_tree_view_new ()), (self->priv->headerlist == NULL ? NULL : (self->priv->headerlist = (g_object_unref (self->priv->headerlist), NULL))), _tmp7);
		gtk_container_add (GTK_CONTAINER (headerlist_scrolled), GTK_WIDGET (self->priv->headerlist));
		_tmp8 = NULL;
		self->priv->progressbar = (_tmp8 = g_object_ref_sink (gtk_progress_bar_new ()), (self->priv->progressbar == NULL ? NULL : (self->priv->progressbar = (g_object_unref (self->priv->progressbar), NULL))), _tmp8);
		gtk_box_pack_start (GTK_BOX (vbox), GTK_WIDGET (self->priv->progressbar), FALSE, FALSE, 0);
		_tmp9 = NULL;
		renderer = (_tmp9 = GTK_CELL_RENDERER (g_object_ref_sink (gtk_cell_renderer_text_new ())), (renderer == NULL ? NULL : (renderer = (g_object_unref (renderer), NULL))), _tmp9);
		_tmp10 = NULL;
		column = (_tmp10 = g_object_ref_sink (gtk_tree_view_column_new_with_attributes ("From", renderer, "text", TNY_GTK_HEADER_LIST_MODEL_FROM_COLUMN, NULL)), (column == NULL ? NULL : (column = (g_object_unref (column), NULL))), _tmp10);
		gtk_tree_view_column_set_fixed_width (column, 100);
		gtk_tree_view_column_set_sizing (column, GTK_TREE_VIEW_COLUMN_FIXED);
		gtk_tree_view_append_column (self->priv->headerlist, column);
		_tmp11 = NULL;
		renderer = (_tmp11 = GTK_CELL_RENDERER (g_object_ref_sink (gtk_cell_renderer_text_new ())), (renderer == NULL ? NULL : (renderer = (g_object_unref (renderer), NULL))), _tmp11);
		_tmp12 = NULL;
		column = (_tmp12 = g_object_ref_sink (gtk_tree_view_column_new_with_attributes ("Subject", renderer, "text", TNY_GTK_HEADER_LIST_MODEL_SUBJECT_COLUMN, NULL)), (column == NULL ? NULL : (column = (g_object_unref (column), NULL))), _tmp12);
		gtk_tree_view_column_set_fixed_width (column, 200);
		gtk_tree_view_column_set_sizing (column, GTK_TREE_VIEW_COLUMN_FIXED);
		gtk_tree_view_append_column (self->priv->headerlist, column);
		_tmp13 = NULL;
		renderer = (_tmp13 = GTK_CELL_RENDERER (g_object_ref_sink (gtk_cell_renderer_text_new ())), (renderer == NULL ? NULL : (renderer = (g_object_unref (renderer), NULL))), _tmp13);
		_tmp14 = NULL;
		column = (_tmp14 = g_object_ref_sink (gtk_tree_view_column_new_with_attributes ("Received", renderer, "text", TNY_GTK_HEADER_LIST_MODEL_DATE_RECEIVED_COLUMN, NULL)), (column == NULL ? NULL : (column = (g_object_unref (column), NULL))), _tmp14);
		gtk_tree_view_column_set_fixed_width (column, 100);
		gtk_tree_view_column_set_sizing (column, GTK_TREE_VIEW_COLUMN_FIXED);
		gtk_tree_view_append_column (self->priv->headerlist, column);
		_tmp15 = NULL;
		self->priv->msgview = (_tmp15 = g_object_ref_sink (tny_gtk_msg_view_new ()), (self->priv->msgview == NULL ? NULL : (self->priv->msgview = (g_object_unref (self->priv->msgview), NULL))), _tmp15);
		gtk_paned_pack2 (GTK_PANED (vpaned), GTK_WIDGET (self->priv->msgview), TRUE, TRUE);
		g_signal_connect (self, "destroy", ((GCallback) gtk_main_quit), NULL);
		g_signal_connect_object (gtk_tree_view_get_selection (foldertree), "changed", ((GCallback) tny_vala_mail_window_on_folder_selected), self, 0);
		g_signal_connect_object (gtk_tree_view_get_selection (self->priv->headerlist), "changed", ((GCallback) tny_vala_mail_window_on_message_selected), self, 0);
		(renderer == NULL ? NULL : (renderer = (g_object_unref (renderer), NULL)));
		(column == NULL ? NULL : (column = (g_object_unref (column), NULL)));
		(platfact == NULL ? NULL : (platfact = (g_object_unref (platfact), NULL)));
		(account_store == NULL ? NULL : (account_store = (g_object_unref (account_store), NULL)));
		(device == NULL ? NULL : (device = (g_object_unref (device), NULL)));
		(hpaned == NULL ? NULL : (hpaned = (g_object_unref (hpaned), NULL)));
		(foldertree_scrolled == NULL ? NULL : (foldertree_scrolled = (g_object_unref (foldertree_scrolled), NULL)));
		(foldertree == NULL ? NULL : (foldertree = (g_object_unref (foldertree), NULL)));
		(query == NULL ? NULL : (query = (g_object_unref (query), NULL)));
		(accounts == NULL ? NULL : (accounts = (g_object_unref (accounts), NULL)));
		(vpaned == NULL ? NULL : (vpaned = (g_object_unref (vpaned), NULL)));
		(vbox == NULL ? NULL : (vbox = (g_object_unref (vbox), NULL)));
		(headerlist_scrolled == NULL ? NULL : (headerlist_scrolled = (g_object_unref (headerlist_scrolled), NULL)));
	}
	return obj;
}


static void tny_vala_mail_window_class_init (TnyValaMailWindowClass * klass) {
	tny_vala_mail_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TnyValaMailWindowPrivate));
	G_OBJECT_CLASS (klass)->constructor = tny_vala_mail_window_constructor;
	G_OBJECT_CLASS (klass)->dispose = tny_vala_mail_window_dispose;
}


static void tny_vala_mail_window_init (TnyValaMailWindow * self) {
	self->priv = TNY_VALA_MAIL_WINDOW_GET_PRIVATE (self);
}


static void tny_vala_mail_window_dispose (GObject * obj) {
	TnyValaMailWindow * self;
	self = TNY_VALA_MAIL_WINDOW (obj);
	(self->priv->msgview == NULL ? NULL : (self->priv->msgview = (g_object_unref (self->priv->msgview), NULL)));
	(self->priv->headerlist == NULL ? NULL : (self->priv->headerlist = (g_object_unref (self->priv->headerlist), NULL)));
	(self->priv->progressbar == NULL ? NULL : (self->priv->progressbar = (g_object_unref (self->priv->progressbar), NULL)));
	G_OBJECT_CLASS (tny_vala_mail_window_parent_class)->dispose (obj);
}


GType tny_vala_mail_window_get_type (void) {
	static GType tny_vala_mail_window_type_id = 0;
	if (G_UNLIKELY (tny_vala_mail_window_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (TnyValaMailWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tny_vala_mail_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TnyValaMailWindow), 0, (GInstanceInitFunc) tny_vala_mail_window_init };
		tny_vala_mail_window_type_id = g_type_register_static (GTK_TYPE_WINDOW, "TnyValaMailWindow", &g_define_type_info, 0);
	}
	return tny_vala_mail_window_type_id;
}




