/*
 * libsysactivity
 * http://sourceforge.net/projects/libsysactivity/
 * Copyright (c) 2009, 2010 Carlos Olmedo Escobar <carlos.olmedo.e@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <stdio.h>
#include <unistd.h>
#include <pthread.h>
#include <stdlib.h>
#include <string.h>

#include <libsysactivity/libsysactivity.h>

void print_cpu_info(struct sa_cpu* cpu) {
#ifdef SA_CPU_USER
	printf("user: %f", cpu->user);
#endif
#ifdef SA_CPU_NICE
	printf(", nice: %f", cpu->nice);
#endif
#ifdef SA_CPU_SYSTEM
	printf(", system: %f", cpu->system);
#endif
#ifdef SA_CPU_IDLE
	printf(", idle: %f", cpu->idle);
#endif
#ifdef SA_CPU_WAITING_FOR_IO
	printf(", waiting_for_io: %f", cpu->waiting_for_io);
#endif
#ifdef SA_CPU_HARDWARE_IRQ
	printf(", hardware_irq: %f", cpu->hardware_irq);
#endif
#ifdef SA_CPU_SOFTWARE_IRQ
	printf(", software_irq: %f", cpu->software_irq);
#endif
#ifdef SA_CPU_STOLEN
	printf(", stolen: %f", cpu->stolen);
#endif
#ifdef SA_CPU_INTR
	printf(", intr: %f", cpu->intr);
#endif
	printf("\n");
}

void test_cpu_info(struct sa_cpu* cpu) {
#ifdef SA_CPU_IDLE
	if (cpu->idle != 0) {
		printf("\nERROR: Idle is not zero\n");
		exit(EXIT_FAILURE);
	}
#endif
}

void* get_cpu_info(void* arg) {
	int i;
	int j;
	uint16_t number_cpus;
	uint16_t written;
	int ret;

#ifdef SA_OPEN_CPU
	ret = sa_open_cpu();
	if (ret != 0) {
		printf("sa_open_cpu(): %s\n", strerror(ret));
		exit(EXIT_FAILURE);
	}
#endif

	ret = sa_count_cpus(&number_cpus);
	if (ret != 0 || number_cpus == 0) {
		printf("sa_count_cpus(): %s\n", strerror(ret));
		exit(EXIT_FAILURE);
	}
	printf("Number of cpus: %u\n", number_cpus);

	struct sa_cpu* cpus = malloc(number_cpus * sizeof(struct sa_cpu));
	ret = sa_get_cpu(0, cpus);
	if (ret != 0) {
		printf("sa_get_cpu(): %s\n", strerror(ret));
		exit(EXIT_FAILURE);
	}
	print_cpu_info(cpus);
	printf("\n");

	sleep(1);
	for (i = 0; i < 6; i++) {
		written = 0;
		ret = sa_get_cpus(cpus, number_cpus, &written);
		if (ret != 0 || written == 0) {
			printf("sa_get_cpus(): %s\n", strerror(ret));
			exit(EXIT_FAILURE);
		}
		for (j = 0; j < written; j++) {
			printf("cpu index: %d\n", cpus[j].id);
			print_cpu_info(&cpus[j]);
			if (i > 0)
				test_cpu_info(&cpus[j]);
		}
		printf("\n");
		sleep(1);
	}
	free(cpus);

#ifdef SA_CLOSE_CPU
	ret = sa_close_cpu();
	if (ret != 0) {
		printf("sa_close_cpu(): %s\n", strerror(ret));
		exit(EXIT_FAILURE);
	}
#endif
#ifdef SA_OPEN_CPU
	ret = sa_open_cpu();
	if (ret != 0) {
		printf("sa_open_cpu(): %s\n", strerror(ret));
		exit(EXIT_FAILURE);
	}
#endif
#ifdef SA_CLOSE_CPU
	ret = sa_close_cpu();
	if (ret != 0) {
		printf("sa_close_cpu(): %s\n", strerror(ret));
		exit(EXIT_FAILURE);
	}
#endif
	return NULL;
}

void* stress_cpu(void* arg) {
	int i = 0;
	while (1)
		i++;
}

int main() {
	pthread_t thread1, thread2;
	struct timespec delay;
	delay.tv_sec = 0;
	delay.tv_nsec = 500000000;

	int ret;
#ifdef SA_OPEN_CPU
	ret = sa_open_cpu();
	if (ret != 0) {
		printf("sa_open_cpu(): %s\n", strerror(ret));
		exit(EXIT_FAILURE);
	}
#endif

	uint16_t number_cpus;
	ret = sa_count_cpus(&number_cpus);
	if (ret != 0 || number_cpus == 0) {
		printf("sa_count_cpus(): %s\n", strerror(ret));
		exit(EXIT_FAILURE);
	}

#ifdef SA_CLOSE_CPU
	ret = sa_close_cpu();
	if (ret != 0) {
		printf("sa_close_cpu(): %s\n", strerror(ret));
		exit(EXIT_FAILURE);
	}
#endif

	for (ret = 0; ret < number_cpus; ret++) {
		pthread_create(&thread2, NULL, stress_cpu, NULL);
	}
	nanosleep(&delay, NULL);

	pthread_create(&thread1, NULL, get_cpu_info, NULL);
	nanosleep(&delay, NULL);

	get_cpu_info(NULL);

	return EXIT_SUCCESS;
}
