/*
 * libsyncml - A syncml protocol implementation
 * Copyright (C) 2005  Armin Bauer <armin.bauer@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; version 
 * 2.1 of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 */

#ifndef _SML_NOTIFICATION_H_
#define _SML_NOTIFICATION_H_

typedef enum {
	SML_SAN_VERSION_UNKNOWN = 0,
	SML_SAN_VERSION_10 = 1,
	SML_SAN_VERSION_11 = 2,
	SML_SAN_VERSION_12 = 3
} SmlNotificationVersion;

typedef enum {
	SML_SAN_UIMODE_UNSPECIFIED = 0,
	SML_SAN_UIMODE_BACKGROUND = 1,
	SML_SAN_UIMODE_INFORMATIVE = 2,
	SML_SAN_UIMODE_USER = 3
} SmlNotificationUIMode;

typedef enum {
	SML_SAN_INITIATOR_USER = 0,
	SML_SAN_INITIATOR_SERVER = 1
} SmlNotificationInitiator;

SmlNotification *smlNotificationNew(SmlNotificationVersion version, SmlNotificationUIMode mode, SmlNotificationInitiator init, unsigned int sessionID, const char *identifier, const char *target, SmlMimeType type, SmlError **error);
void smlNotificationSetCred(SmlNotification *san, SmlCred *cred);
void smlNotificationSetManager(SmlNotification *san, SmlManager *manager);
void smlNotificationFree(SmlNotification *san);
SmlNotification *smlNotificationParse(const char *data, unsigned int size, SmlError **error);
SmlBool smlNotificationAssemble(SmlNotification *san, char **data, unsigned int *size, SmlError **error);
SmlBool smlNotificationSend(SmlNotification *san, SmlTransport *tsp, SmlError **error);

SmlBool smlNotificationNewAlert(SmlNotification *san, SmlAlertType type, const char *contenttype, const char *serverURI, SmlError **error);
void smlNotificationFreeAlert(SmlSanAlert *alert);

SmlNotificationVersion smlNotificationGetVersion(SmlNotification *san);
SmlNotificationUIMode smlNotificationGetMode(SmlNotification *san);
SmlNotificationInitiator smlNotificationGetInitiator(SmlNotification *san);
unsigned int smlNotificationGetSessionID(SmlNotification *san);
const char *smlNotificationGetIdentifier(SmlNotification *san);
unsigned int smlNotificationNumAlerts(SmlNotification *san);
SmlSanAlert *smlNotificationNthAlert(SmlNotification *san, unsigned int nth);

SmlAlertType smlSanAlertGetType(SmlSanAlert *alert);
const char *smlSanAlertGetContentType(SmlSanAlert *alert);
const char *smlSanAlertGetServerURI(SmlSanAlert *alert);

#endif //_SML_NOTIFICATION_H_
