/*
 * libsyncml - A syncml protocol implementation
 * Copyright (C) 2005  Armin Bauer <armin.bauer@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; version 
 * 2.1 of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 */

#ifndef _SML_ERROR_INTERNALS_H_
#define _SML_ERROR_INTERNALS_H_

/*! @brief Represent an error
 */
struct SmlError {
	/** The type of the error that occured */
	SmlErrorType type;
	/** The message */
	char *message;
	/** The reference counter */
	gint32 refCount;
};

void smlErrorSetVargs(SmlError **error, SmlErrorType type, const char *format, va_list args);

#endif //_SML_ERROR_INTERNALS_H_
