/* SingleSelectionAction.java
 * =========================================================================
 * This file is part of the SWIRL Library - http://swirl-lib.sourceforge.net
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 * 
 */

package be.ugent.caagt.swirl.actions;

import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.SingleSelectionModel;

/**
 * Simple action which selects a given index in a {@link SingleSelectionModel}.
 * <p>
 * @see be.ugent.caagt.swirl.SelectionGroup
 * @see Description
 */
public class SingleSelectionAction extends SimpleAction {
    
    //
    protected final SingleSelectionModel selectionModel;
    
    //
    protected final int value;
    
    /**
     * Construct an action of this type with an internationalized description
     * string and given icons.
     *
     * @param selectionModel Selection model which will be changed by this action
     * @param value Value to be selected by this action
     * @param bundle Resource bundle which contains the description for
     * this action.
     * @param key Key used for the description of this action in the bundle.
     * @param icon Small icon to be used for menu and standard button decoration (or null)
     * @param mediumIcon Medium size icon to be used for tool bar buttons (or null)
     * @param mediumDisabledIcon Medium size icon to be used for a disabled tool bar buttons (or null)
     */
    public SingleSelectionAction(SingleSelectionModel selectionModel, int value,
            ResourceBundle bundle, String key, Icon icon, Icon mediumIcon, Icon mediumDisabledIcon) {
        super(bundle, key, icon, mediumIcon, mediumDisabledIcon);
        this.selectionModel = selectionModel;
        this.value = value;
    }
    
    /**
     * Construct an action of this type with an internationalized description
     * string and given icon.
     *
     * @param selectionModel Selection model which will be changed by this action
     * @param value Value to be selected by this action
     * @param bundle Resource bundle which contains the description for
     * this action.
     * @param key Key used for the description of this action in the bundle.
     * @param icon Small icon to be used for menu and standard button decoration (or null).
     */
    public SingleSelectionAction(SingleSelectionModel selectionModel, int value,
            ResourceBundle bundle, String key, Icon icon) {
        super(bundle, key, icon);
        this.selectionModel = selectionModel;
        this.value = value;
    }
        
    public void actionPerformed(ActionEvent e) {
        selectionModel.setSelectedIndex(value);
    }
}
