/* Copyright 2004, 2005, 2006 Acegi Technology Pty Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springframework.security.acls.objectidentity;

/**
 * Basic implementation of {@link ObjectIdentityRetrievalStrategy} that uses the constructor of {@link
 * ObjectIdentityImpl} to create the {@link ObjectIdentity}.
 *
 * @author Ben Alex
 * @version $Id: ObjectIdentityRetrievalStrategyImpl.java 2142 2007-09-21 18:18:21Z luke_t $
 */
public class ObjectIdentityRetrievalStrategyImpl implements ObjectIdentityRetrievalStrategy {
    //~ Methods ========================================================================================================

    public ObjectIdentity getObjectIdentity(Object domainObject) {
        return new ObjectIdentityImpl(domainObject);
    }
}
