=begin
= Locale
	a module to provide locale features.

== Usage

Use with module methods and constants to set the locales for given
categories.
  
  require 'locale'

To set the locale for all categories use the LC_ALL category.
  
  Locale.setlocal(Locale::LC_ALL, 'en_GB')

To set the locale for a specific category use the specific category name.
  
  Locale.setlocal(Locale::LC_TIME, 'ja_JP')

To set a number of categories use a hash.

  Locale.setlocal(Locale::LC_MONETARY => 'en_GB', Locale::LC_TIME => 'ja_JP')
	
== Methods

--- Locale#setlocale(category, locale)

      for a given integer ((|category|)) set the string ((|locale|)). The 
      locale assigned is returned as a string. If you provide an empty
      string for the ((|locale|)), the default locale will be returned. The
      return value may be passed back to the function as a ((|locale|)) parameter.

--- Locale#setlocale(category_locale_hash)

      for each integer ((|category|)) and string ((|locale|)) mapping
      the locale will be set. The return value is a hash of the locales assigned
      for each mapping. The return value may be passed back to the function as
      a ((|category_local_hash|)) parameter.

== Constants

--- Locale::LC_ALL

      for all the locale

--- Locale::LC_COLLATE

      for  regular expression matching (it determines the meaning  of  range
      expressions and equivalence classes) and string collation.

--- Locale::LC_CTYPE

      for regular expression matching, character classification, conversion,
      case-sensitive comparison, and wide character functions.

--- Locale::LC_MESSAGES

      for localizable natural-language messages.

--- Locale::LC_MONETARY

      for monetary formatting.

--- Locale::LC_NUMERIC

      for number formatting (such as the decimal point and the thousands separator).

--- Locale::LC_TIME

      for time and date formatting.

Each constant provides an integer value for each category (except LC_ALL which
represents all categories). The constants defined are the most common; ther may be more
categories available. Consult the local documentation for any other categories.

=== Notes

For a good discussion of the use of locales see "The GNU C Library",
chapter "Locales and Internationalization".

= Locate::LangInfo

a module to query language and locale information.

== Usage

	Locale::LangInfo.langinfo(Locale::LangInfo::D_T_FMT)

to return the format string for the date time in the currently set locale.

== Methods

--- Locale::LangInfo#langinfo(item)

      for a given integer ((|item|)) then corresponding locale specific string is returned.

== Constants

--- Locale::LangInfo::DAY_1
--- Locale::LangInfo::DAY_2

      represents the days of the week in the current locale.

--- Locale::LangInfo::ABDAY_1
--- Locale::LangInfo::ABDAY_2

      represents the abbreviated name for the days of the week in the current locale.

--- Locale::LangInfo::D_T_FMT

      represents the date time format for the current locale.

== Notes

The are many more constants defined. Consult your local documentation for a list of
possible items.

=end
