/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.generator;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.jfree.io.IOUtils;
import org.jfree.util.HashNMap;
import org.jfree.util.Log;
import org.jfree.xml.generator.ModelWriter;
import org.jfree.xml.generator.model.ClassDescription;
import org.jfree.xml.generator.model.DescriptionModel;
import org.jfree.xml.generator.model.ManualMappingInfo;
import org.jfree.xml.generator.model.MappingModel;
import org.jfree.xml.generator.model.MultiplexMappingInfo;

public class SplittingModelWriter
extends ModelWriter {
    private HashNMap classDescriptionByPackage;
    private ArrayList sources;
    private File targetFile;
    private String extension;
    private String plainFileName;
    private HashNMap manualMappingByPackage;
    private HashNMap multiplexMappingByPackage;

    public static String getPackage(Class c) {
        String className = c.getName();
        int idx = className.lastIndexOf(46);
        if (idx <= 0) {
            return "";
        }
        return className.substring(0, idx);
    }

    public synchronized void write(String target) throws IOException {
        DescriptionModel model = this.getModel();
        this.sources = new ArrayList<String>(Arrays.asList(model.getSources()));
        this.targetFile = new File(target);
        this.plainFileName = IOUtils.getInstance().stripFileExtension(this.targetFile.getName());
        this.extension = IOUtils.getInstance().getFileExtension(target);
        this.classDescriptionByPackage = new HashNMap();
        int i = 0;
        while (i < model.size()) {
            ClassDescription cd = model.get(i);
            if (cd.getSource() == null) {
                String packageName = SplittingModelWriter.getPackage(cd.getObjectClass());
                String includeFileName = String.valueOf(this.plainFileName) + "-" + packageName + this.extension;
                this.classDescriptionByPackage.add((Object)includeFileName, (Object)cd);
            } else {
                this.classDescriptionByPackage.add((Object)cd.getSource(), (Object)cd);
            }
            ++i;
        }
        MappingModel mappingModel = model.getMappingModel();
        ManualMappingInfo[] manualMappings = mappingModel.getManualMapping();
        this.manualMappingByPackage = new HashNMap();
        int i2 = 0;
        while (i2 < manualMappings.length) {
            ManualMappingInfo mapping = manualMappings[i2];
            if (mapping.getSource() == null) {
                this.manualMappingByPackage.add((Object)"", (Object)mapping);
            } else {
                this.manualMappingByPackage.add((Object)mapping.getSource(), (Object)mapping);
            }
            ++i2;
        }
        MultiplexMappingInfo[] multiplexMappings = mappingModel.getMultiplexMapping();
        this.multiplexMappingByPackage = new HashNMap();
        int i3 = 0;
        while (i3 < multiplexMappings.length) {
            MultiplexMappingInfo mapping = multiplexMappings[i3];
            if (mapping.getSource() == null) {
                this.multiplexMappingByPackage.add((Object)"", (Object)mapping);
            } else {
                this.multiplexMappingByPackage.add((Object)mapping.getSource(), (Object)mapping);
            }
            ++i3;
        }
        Object[] keys = this.classDescriptionByPackage.keySet().toArray();
        int i4 = 0;
        while (i4 < keys.length) {
            String includeFileName = (String)keys[i4];
            if (!includeFileName.equals("")) {
                this.writePackageFile(includeFileName);
            }
            ++i4;
        }
        this.writeMasterFile();
        this.manualMappingByPackage = null;
        this.multiplexMappingByPackage = null;
        this.classDescriptionByPackage = null;
        this.sources = null;
    }

    private void writeMasterFile() throws IOException {
        Log.debug((Object)("Writing master file: " + this.targetFile));
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.targetFile), "UTF-8"));
        ModelWriter.writeXMLHeader(writer);
        this.writeStandardComment(writer, this.getModel().getModelComments());
        this.getWriterSupport().writeTag(writer, "objects");
        int i = 0;
        while (i < this.sources.size()) {
            String includeFileName = (String)this.sources.get(i);
            if (!includeFileName.equals("")) {
                this.writeTag(writer, "include", "src", includeFileName, this.getModel().getIncludeComment(includeFileName));
            }
            ++i;
        }
        Object[] keys = this.classDescriptionByPackage.keySet().toArray();
        Arrays.sort(keys);
        int i2 = 0;
        while (i2 < keys.length) {
            String includeFileName = (String)keys[i2];
            if (!includeFileName.equals("")) {
                this.writeTag(writer, "include", "src", includeFileName, this.getModel().getIncludeComment(includeFileName));
            }
            ++i2;
        }
        Iterator values = this.classDescriptionByPackage.getAll((Object)"");
        while (values.hasNext()) {
            ClassDescription cd = (ClassDescription)values.next();
            this.writeClassDescription(writer, cd);
        }
        Iterator manualMappings = this.manualMappingByPackage.getAll((Object)"");
        while (manualMappings.hasNext()) {
            ManualMappingInfo mi = (ManualMappingInfo)manualMappings.next();
            this.writeManualMapping(writer, mi);
        }
        Iterator multiplexMappings = this.multiplexMappingByPackage.getAll((Object)"");
        while (multiplexMappings.hasNext()) {
            MultiplexMappingInfo mi = (MultiplexMappingInfo)multiplexMappings.next();
            this.writeMultiplexMapping(writer, mi);
        }
        this.writeCloseComment(writer, this.getModel().getModelComments());
        this.getWriterSupport().writeCloseTag(writer, "objects");
        writer.close();
    }

    private void writePackageFile(String includeFileName) throws IOException {
        Object mi;
        Iterator values = this.classDescriptionByPackage.getAll((Object)includeFileName);
        Iterator manualMappings = this.manualMappingByPackage.getAll((Object)includeFileName);
        Iterator multiplexMappings = this.multiplexMappingByPackage.getAll((Object)includeFileName);
        if (!(values.hasNext() || manualMappings.hasNext() || multiplexMappings.hasNext())) {
            return;
        }
        Log.debug((Object)("Writing included file: " + includeFileName));
        ((AbstractCollection)this.sources).remove(includeFileName);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(this.targetFile.getParentFile(), includeFileName)), "UTF-8"));
        ModelWriter.writeXMLHeader(writer);
        this.writeStandardComment(writer, this.getModel().getModelComments());
        this.getWriterSupport().writeTag(writer, "objects");
        while (values.hasNext()) {
            ClassDescription cd = (ClassDescription)values.next();
            this.writeClassDescription(writer, cd);
        }
        while (manualMappings.hasNext()) {
            mi = (ManualMappingInfo)manualMappings.next();
            this.writeManualMapping(writer, (ManualMappingInfo)mi);
        }
        while (multiplexMappings.hasNext()) {
            mi = (MultiplexMappingInfo)multiplexMappings.next();
            this.writeMultiplexMapping(writer, (MultiplexMappingInfo)mi);
        }
        this.writeCloseComment(writer, this.getModel().getModelComments());
        this.getWriterSupport().writeCloseTag(writer, "objects");
        writer.close();
    }
}

