/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.generator;

import java.io.File;
import java.io.FileFilter;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import org.jfree.ui.ExtensionFileFilter;
import org.jfree.util.Log;
import org.jfree.util.ObjectUtilities;
import org.jfree.xml.generator.SourceCollector;

public class JavaSourceCollector
implements SourceCollector {
    private CollectorFileFilter eff = new CollectorFileFilter("<ignore>", ".java");
    private ArrayList fileList = new ArrayList();
    private ArrayList ignoredPackages;
    private ArrayList ignoredBaseClasses;
    private File startDirectory;
    private String initialPackageName;
    static /* synthetic */ Class class$org$jfree$xml$generator$JavaSourceCollector;

    public JavaSourceCollector(File startDirectory) {
        this(startDirectory, "");
    }

    public JavaSourceCollector(File startDirectory, String packageName) {
        this.startDirectory = startDirectory;
        this.initialPackageName = packageName;
        this.ignoredPackages = new ArrayList();
        this.ignoredBaseClasses = new ArrayList();
    }

    public void addIgnoredBaseClass(Class baseClass) {
        this.ignoredBaseClasses.add(baseClass);
    }

    public void addIgnoredBaseClass(String baseClass) {
        Class loadedClass = this.loadClass(baseClass);
        if (loadedClass != null) {
            Log.debug((Object)new Log.SimpleMessage("Added IgnClass: ", (Object)baseClass));
            this.ignoredBaseClasses.add(loadedClass);
        }
    }

    public void addIgnoredPackage(String pkg) {
        Log.debug((Object)new Log.SimpleMessage("Added IgnPackage: ", (Object)pkg));
        this.ignoredPackages.add(pkg);
    }

    protected String buildJavaName(String packageName, String newPackage) {
        if (packageName.length() == 0) {
            return newPackage;
        }
        return String.valueOf(packageName) + "." + newPackage;
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public void collectFiles() {
        this.collectFiles(this.startDirectory, this.initialPackageName);
    }

    protected void collectFiles(File directory, String packageName) {
        File[] files = directory.listFiles(this.eff);
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                this.collectFiles(files[i], this.buildJavaName(packageName, files[i].getName()));
            } else {
                String fname = files[i].getName();
                String className = fname.substring(0, fname.length() - 5);
                String fullName = this.buildJavaName(packageName, className);
                if (this.isIgnoredPackage(fullName)) {
                    Log.debug((Object)new Log.SimpleMessage("Do not process: Ignored: ", (Object)className));
                } else {
                    Class jclass = this.loadClass(fullName);
                    if (jclass != null && !this.isIgnoredBaseClass(jclass)) {
                        if (jclass.isInterface() || Modifier.isAbstract(jclass.getModifiers())) {
                            Log.debug((Object)new Log.SimpleMessage("Do not process: Abstract: ", (Object)className));
                        } else if (!Modifier.isPublic(jclass.getModifiers())) {
                            Log.debug((Object)new Log.SimpleMessage("Do not process: Not public: ", (Object)className));
                        } else {
                            this.fileList.add(jclass);
                        }
                    }
                }
            }
            ++i;
        }
    }

    public Class[] getClasses() {
        return this.fileList.toArray(new Class[0]);
    }

    protected boolean isIgnoredBaseClass(Class c) {
        int i = 0;
        while (i < this.ignoredBaseClasses.size()) {
            Class ignoredClass = (Class)this.ignoredBaseClasses.get(i);
            if (ignoredClass.isAssignableFrom(c)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean isIgnoredPackage(String classname) {
        int i = 0;
        while (i < this.ignoredPackages.size()) {
            String ignoredPackage = (String)this.ignoredPackages.get(i);
            if (classname.startsWith(ignoredPackage)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected Class loadClass(String name) {
        try {
            return ObjectUtilities.getClassLoader((Class)(class$org$jfree$xml$generator$JavaSourceCollector != null ? class$org$jfree$xml$generator$JavaSourceCollector : (class$org$jfree$xml$generator$JavaSourceCollector = JavaSourceCollector.class$("org.jfree.xml.generator.JavaSourceCollector")))).loadClass(name);
        }
        catch (Exception exception) {
            Log.warn((Object)new Log.SimpleMessage("Do not process: Failed to load class:", (Object)name));
            return null;
        }
    }

    private static class CollectorFileFilter
    extends ExtensionFileFilter
    implements FileFilter {
        public CollectorFileFilter(String description, String extension) {
            super(description, extension);
        }
    }
}

