/**
 * GUI Commands
 * Copyright 2004 Andrew Pietsch
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * $Id: PageSelectCommand.java,v 1.7 2005/01/09 03:24:04 pietschy Exp $
 */
package org.pietschy.command.demo;

import org.pietschy.command.ToggleCommand;

import javax.swing.*;

public class
PageSelectCommand
extends ToggleCommand
{
   static final String _ID_ = "$Id: PageSelectCommand.java,v 1.7 2005/01/09 03:24:04 pietschy Exp $";

   private DemoPanel panel;

   public PageSelectCommand(String commandId, DemoPanel panel)
   {
      super(commandId);
      this.panel = panel;
      export();
   }

   /**
    * Entry for subclasses to handle the selection process.  When a request to change
    * the selection is made, this method will be called.  The selection process will
    * continue with the value that is returned from this method.  Thus, to cancel a selection
    * change the method would return <tt>!selected</tt>, to implement a do-nothing subclass
    * that always toggles this method should just return <tt>selected</tt>.  Please note that
    * the current state of {@link #isSelected} will not be updated until after this method
    * has been called and so should not be used in this method.
    *
    * @param selected the requested selection state.
    */
   protected void
   handleSelection(boolean selected)
   {
      // Toggles only activate thier page on selection.
      if (!selected)
         return;

      Runnable r = new Runnable()
      {
         public void run()
         {
            Demo.instance().getMainFrame().setDemoPanel(panel);
         }
      };

      if (SwingUtilities.isEventDispatchThread())
         r.run();
      else
         SwingUtilities.invokeLater(r);
   }
}
