/**
 * GUI Commands
 * Copyright 2004 Andrew Pietsch
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * $Id: DemoPanel.java,v 1.12 2007/01/11 08:28:39 pietschy Exp $
 */

package org.pietschy.command.demo;

import au.com.skypie.ui.BorderUtil;
import org.pietschy.command.CommandGroup;
import org.pietschy.command.CommandManager;
import org.pietschy.command.ActionCommandExecutor;
import org.pietschy.command.delegate.DelegateContainer;
import org.pietschy.command.delegate.CommandDelegate;

import javax.swing.*;
import java.awt.*;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.Map;
import java.util.HashMap;
import java.beans.PropertyChangeListener;

public abstract class
DemoPanel
extends JPanel implements DelegateContainer
{
   static final String _ID_ = "$Id: DemoPanel.java,v 1.12 2007/01/11 08:28:39 pietschy Exp $";
   private JPanel commandFileViewer;
   private HashMap delegates = new HashMap();
   private String selectorId;
   private PageSelectCommand demoSelectCommand;

   /**
    * Creates a new <code>JPanel</code> with a double buffer
    * and a flow layout.
    */
   public DemoPanel(final String name, String selectorId, String commandsUrl)
   {
      setName(name);
      this.selectorId = selectorId;
      setBorder(BorderUtil.standardPadding());
      try
      {
         java.net.URL commandFile = getClass().getResource(commandsUrl);
         CommandManager.defaultInstance().load(commandFile);
         LineNumberReader lr = new LineNumberReader(new InputStreamReader(commandFile.openStream()));
         StringBuffer buf = new StringBuffer();
         String line;
         while ((line = lr.readLine()) != null)
         {
            buf.append(line).append("\n");
         }

         JTextArea textPane = new JTextArea();
         textPane.setFont(new Font("Monospaced", Font.PLAIN, textPane.getFont().getSize()));
         textPane.setText(buf.toString());
         textPane.setLineWrap(false);
         commandFileViewer = new JPanel(new BorderLayout());
         commandFileViewer.add(new JScrollPane(textPane));
         commandFileViewer.setBorder(BorderUtil.standardPadding());

         registerDelegate(new CommandDelegate("print-delegate")
         {
            public void execute(Map hints)
            {
               JOptionPane.showMessageDialog(SwingUtilities.getWindowAncestor(DemoPanel.this), "This is the print delegate for " + name);
            }
         });

      }
      catch (Exception e)
      {
         throw new RuntimeException("Couldn't load command file: " + commandsUrl, e);
      }
   }

   public PageSelectCommand
   getSelector()
   {
      if (demoSelectCommand == null)
      {
         demoSelectCommand = new PageSelectCommand(selectorId, this);
      }

      return demoSelectCommand;
   }

   public abstract CommandGroup[]
   getMenuGroups();

   public abstract CommandGroup
   getToolbarGroup();

   public JComponent
   getCommandFileViewer()
   {
      return commandFileViewer;
   }

   protected void registerDelegate(CommandDelegate delegate)
   {
      registerDelegate(delegate.getId(), delegate);
   }

   protected void registerDelegate(String id, ActionCommandExecutor delegate)
   {
      delegates.put(id, delegate);
   }

   public ActionCommandExecutor getCommandExecutor(String commandId)
   {
      return (ActionCommandExecutor) delegates.get(commandId);
   }

}
