/**
 * GUI Commands
 * Copyright 2004 Andrew Pietsch
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * $Id: SeparatorMember.java,v 1.10 2006/02/26 00:59:06 pietschy Exp $
 */

package org.pietschy.command;

import org.pietschy.command.log.Logger;

import javax.swing.*;
import java.util.List;


class
SeparatorMember
extends AbstractGroupMember
{
   private static final Logger log = CommandManager.getLogger(SeparatorMember.class);


   protected SeparatorMember()
   {
   }

   public void addComponentTo(JComponent container, Object factory, String faceId, List previousButtons, int buttonIndex)
   {
      log.enter("addTo");
      log.param("container", String.valueOf(container.getClass()));
      addSeparator(container);
      log.exit("addTo()");
   }


   public boolean isMemberFor(Command c)
   {
      return false;
   }

   /**
    * Checks if this group is dependant on the specified command.
    * @param c the Command in question.
    * @return <tt>true</tt> if this member
    */
   public boolean isDependantOn(Command c)
   {
      return false;
   }

   public void
   acceptVisitor(GroupVisitor visitor)
   {
   }
}
